package com.bokesoft.yigo.meta.form.component.view.layout;

import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaColumnLayout extends MetaComponentLayout<MetaLayoutSpan> {

	@Override
	public int getLayoutType() {
		return LayoutType.LAYOUT_COLUMN;
	}

	public static final String TAG_NAME = LayoutType.STR_LAYOUT_COLUMN;
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaColumnLayout();
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaLayoutSpan.TAG_NAME.equals(tagName) ) {
			MetaLayoutSpan item = new MetaLayoutSpan();
			item.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(item);
			resultMetaObject = item;
		}
		if (resultMetaObject == null) {
			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		return resultMetaObject;
	}
}
