package com.bokesoft.yigo.meta.form.component.panel.gridpanel;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaGridLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutSpan;

/**
 * MetaGridLayoutPanel定义网格面板元数据，每个网格布局将区域划分成行和列，定义每行及每列的大小，
 * 放置在其中的组件需要定义在划分出的行列的中位置及跨度。
 *
 * @author 王元和
 *
 */
public class MetaGridLayoutPanel extends MetaPanel {
    /** 行定义集合 */
    private MetaRowDefCollection rowDefCollection = null;
    private MetaExtraLayout metaExtraLayout = null;
    /** 列定义集合 */
    private MetaColumnDefCollection columnDefCollection = null;
    /** 奇数列背景色 */
    private String oddColumnColor = "";
    /** 强制自有布局 */
    private Boolean forceLayout = true;

    public MetaGridLayoutPanel() {
        super();
    }

    public static final String TAG_NAME = ControlType.STR_GRIDLAYOUTPANEL;

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        super.getChildMetaObjects(list);
        addAll(list, new Object[] {
                rowDefCollection, columnDefCollection,metaExtraLayout
        });
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public int getControlType() {
        return ControlType.GRIDLAYOUTPANEL;
    }

    public String getOddColumnColor() {
        return oddColumnColor;
    }

    public void setOddColumnColor(String oddColumnColor) {
        this.oddColumnColor = oddColumnColor;
    }

    public MetaExtraLayout getMetaExtraLayout() {
        return metaExtraLayout;
    }

    public void setMetaExtraLayout(MetaExtraLayout metaExtraLayout) {
        this.metaExtraLayout = metaExtraLayout;
    }

    public void setRowDefCollection(MetaRowDefCollection rowDefCollection) {
        this.rowDefCollection = rowDefCollection;
    }

    public MetaRowDefCollection getMetaRowDefCollection() {
        return this.rowDefCollection;
    }

    public void setColumnDefCollection(MetaColumnDefCollection columnDefCollection) {
        this.columnDefCollection = columnDefCollection;
    }

    public MetaColumnDefCollection getMetaColumnDefCollection() {
        return this.columnDefCollection;
    }

    /**
     * 设置是否使用自有布局
     * @param forceLayout 标志
     */
    public void setForceLayout(Boolean forceLayout) {
        this.forceLayout = forceLayout;
    }

    /**
     * 取得是否使用自有布局
     * @return 标志
     */
    public Boolean isForceLayout() {
        return this.forceLayout;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
                                                    String tagName, Object flag, int runType) throws MetaException {
        AbstractMetaObject metaObject = null;
        if (MetaRowDefCollection.TAG_NAME.equalsIgnoreCase(tagName)) {
            rowDefCollection = new MetaRowDefCollection();
            metaObject = rowDefCollection;
        } else if (MetaColumnDefCollection.TAG_NAME.equalsIgnoreCase(tagName)) {
            columnDefCollection = new MetaColumnDefCollection();
            metaObject = columnDefCollection;
        } else if (MetaExtraLayout.TAG_NAME.equalsIgnoreCase(tagName)) {
            metaExtraLayout = new MetaExtraLayout();
            metaObject = metaExtraLayout;
        } else {
            metaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
        }
        return metaObject;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaGridLayoutPanel newObject = (MetaGridLayoutPanel)super.clone();
        newObject.setRowDefCollection(rowDefCollection == null ? null : (MetaRowDefCollection)rowDefCollection.clone());
        newObject.setColumnDefCollection(columnDefCollection == null ? null : (MetaColumnDefCollection)columnDefCollection.clone());
        newObject.setMetaExtraLayout(metaExtraLayout == null ? null : (MetaExtraLayout) metaExtraLayout.clone());
        newObject.setOddColumnColor(oddColumnColor);
        newObject.setForceLayout(forceLayout);
        return newObject;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaGridLayoutPanel();
    }

    /**
     * 从网格面板的配置中生成网格布局
     * @return 网格布局
     */
    @Override
    public MetaGridLayout newLayout() {
        MetaGridLayout layout = new MetaGridLayout();
        layout.setKey(key);
        layout.setRowDefCollection(rowDefCollection);
        layout.setColumnDefCollection(columnDefCollection);

        Iterator<MetaComponent> it = this.componentArray.iterator();
        MetaComponent metaComponent = null;
        while ( it.hasNext() ) {
            metaComponent = it.next();
            MetaLayoutSpan item = new MetaLayoutSpan();
            item.setKey(metaComponent.getKey());
            item.setX(metaComponent.getX());
            item.setY(metaComponent.getY());
            item.setXSpan(metaComponent.getXSpan());
            item.setYSpan(metaComponent.getYSpan());
            item.setHeight(metaComponent.getHeight());
            item.setControlType(metaComponent.getControlType());
            layout.add(item);
        }

        return layout;
    }

    @Override
    public AbstractMetaObject getProperties() {
        return null;
    }

    // 根据位置排序,用于处理焦点
    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
        for (MetaComponent metaComponent : componentArray) {
            if (metaComponent.getY() + metaComponent.getYSpan() > rowDefCollection.size()) {
                throw new MetaException(MetaException.ROW_DEFINITION_OUT_RANGE,
                        SimpleStringFormat.format(StringTable.getString(null, "", StringTable.RowDefinitionOutRange), getKey(),metaComponent.getKey()));
            }
            if (metaComponent.getX() + metaComponent.getXSpan() > columnDefCollection.size()) {
                throw new MetaException(MetaException.COLUMN_DEFINITION_OUT_RANGE,
                        SimpleStringFormat.format(StringTable.getString(null, "", StringTable.ColumnDefinitionOutRange), getKey(),metaComponent.getKey()));
            }
        }

        this.componentArray.sort(new Comparator<MetaComponent>() {
            @Override
            public int compare(MetaComponent m1, MetaComponent m2) {
                if( m1.getY() < m2.getY() )
                    return -1;
                if( m1.getY() > m2.getY() )
                    return 1;
                return m1.getX() - m2.getX();
            }
        });
        // 子类继续doPostProcess
        super.doPostProcess(flag, callback);
    }

    @Override
    public void merge(MetaComponent meta) {
        super.merge(meta);

        MetaGridLayoutPanel metaPanel = (MetaGridLayoutPanel)meta;

        if( this.oddColumnColor == null ) {
            this.oddColumnColor = metaPanel.getOddColumnColor();
        }
        if( this.forceLayout == null ) {
            this.forceLayout = metaPanel.isForceLayout();
        }
        if (this.metaExtraLayout == null){
            this.metaExtraLayout = metaPanel.getMetaExtraLayout();
        } else {
            this.metaExtraLayout.merge(metaPanel.getMetaExtraLayout());
        }

        MetaRowDefCollection rowDefCollection2 = metaPanel.getMetaRowDefCollection();
        int rowDefSize = rowDefCollection.size();
        int rowDefSize2 = rowDefCollection2.size();
        for (int i = rowDefSize; i < rowDefSize2; i++) {
            rowDefCollection.add(rowDefCollection2.get(i));
        }

        MetaColumnDefCollection columnDefCollection2 = metaPanel.getMetaColumnDefCollection();
        int columnDefSize = columnDefCollection.size();
        int columnDefSize2 = columnDefCollection2.size();
        for (int i = columnDefSize; i < columnDefSize2; i++) {
            columnDefCollection.add(columnDefCollection2.get(i));
        }
    }
}
