package com.bokesoft.yigo.meta.form.component.grid;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.GridTreeType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

/**
 * MetaRowTree定义表格中的树形结构的规则
 * @author wangyh
 *
 */
public class MetaRowTree extends MetaBaseScript {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/** 
	 * 定义树形结构类型 {@link GridTreeType}
	 */
	private Integer treeType = GridTreeType.NONE;
	
	/**
	 * 树形单元格标识
	 */
	private String cellKey = "";

	/** 
	 * 树形表格是否全部展开
	 */
	private Boolean expand = false;
	
	/**
	 * 展开的层级
	 */
	private Integer expandLevel = -1;
	
	/**
	 * 外关系字段 
	 */
	private String foreign = "";
	
	/**
	 * 主关系字段 
	 */
	private String parent = "";

    /**
     * 加载子行的方法
     */
    private String loadMethod = "";

    /**
     * 树形节点的图片
     */
    private String image = "";

	/**
	 * 是否只展开
	 */
	private Boolean onlyExpand = false;
	
	public MetaRowTree(){
		super(TAG_NAME);
	}
	
	/**
	 * 取得树类型
	 * @return 树类型
	 */
	public Integer getTreeType() {
		return treeType;
	}

	/**
	 * 设置树类型
	 * @param treeType 树类型
	 */
	public void setTreeType(Integer treeType) {
		this.treeType = treeType;
	}
	
	/**
	 * 获取树形单元格标识
	 * @return 树形单元格标识
	 */
	public String getCellKey() {
		return cellKey;
	}

	/**
	 * 设置树形单元格标识
	 * @param cellKey 树形单元格标识
	 */
	public void setCellKey(String cellKey) {
		this.cellKey = cellKey;
	}

/**
     * 获取加载子行的方法
     * @return
     */
    public String getLoadMethod() {
        return this.loadMethod;
    }

    /**
     * 设置加载子航的方法
     * @param loadMethod
     */
    public void setLoadMethod(String loadMethod) {
        this.loadMethod = loadMethod;
    }

    /**
     * 获取节点图片
     * @return
     */
    public String getImage() {
        return this.image;
    }

    /**
     * 设置节点图片
     * @param image
     */
    public void setImage(String image) {
        this.image = image;
    }

	/**
	 * 属性表格是否展开,默认需要手动展开
	 * @return 标志
	 */
	public Boolean isExpand() {
		return expand;
	}

	/**
	 * 设置树形表格是否展开
	 * @param expand 标志
	 */
	public void setExpand(Boolean expand) {
		this.expand = expand;
	}

	/**
	 * 获取是否只展开
	 * @return onlyExpand
	 */
	public Boolean getOnlyExpand() {
		return onlyExpand;
	}

	/**
	 * 设置是否只展开
	 * @param onlyExpand 是否只展开
	 */
	public void setOnlyExpand(Boolean onlyExpand) {
		this.onlyExpand = onlyExpand;
	}

	/**
	 * 获取关系外键
	 * @return 关系外键
	 */
	public String getForeign() {
		return foreign;
	}

	/**
	 * 设值关系外键
	 * @param foreign 关系外键
	 */
	public void setForeign(String foreign) {
		this.foreign = foreign;
	}

	/**
	 * 获取关系主键
	 * @return 关系主键
	 */
	public String getParent() {
		return parent;
	}

	/**
	 * 设值关系主键
	 * @param parent 关系主键
	 */
	public void setParent(String parent) {
		this.parent = parent;
	}
	
	/**
	 * 获取展开的层级
	 * @return
	 */
	public Integer getExpandLevel() {
		return expandLevel;
	}

	/**
	 * 设置展开的层级
	 * @param expandLevel
	 */
	public void setExpandLevel(Integer expandLevel) {
		this.expandLevel = expandLevel;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "RowTree";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaRowTree newObject = (MetaRowTree) super.clone();
		newObject.setTreeType(this.treeType);
		newObject.setExpand(this.expand);
		newObject.setParent(this.parent);
		newObject.setForeign(this.foreign);
		newObject.setCellKey(this.cellKey);
        newObject.setExpandLevel(this.expandLevel);
        newObject.setLoadMethod(this.loadMethod);
        newObject.setImage(this.image);
		newObject.setOnlyExpand(this.onlyExpand);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRowTree();
	}	
	
	/**
	 * 父类覆盖了equals方法，此处如果不做处理，子类实类equals方法调用返回非预期结果
	 * 导致设计器中修改相关属性后，设计器编辑面板不会改变状态，即 添加"*"
	 */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MetaRowTree) {
            MetaRowTree tree = (MetaRowTree) obj;
            return this.treeType == tree.treeType &&
                    this.expandLevel == tree.expandLevel &&
                    this.cellKey.equals(tree.cellKey) &&
                    this.expand == tree.expand &&
                    this.loadMethod.equals(tree.loadMethod) &&
                    this.parent.equals(tree.parent) &&
                    this.foreign.equals(tree.foreign) &&
                    this.image.equals(tree.image) &&
					this.onlyExpand.equals(tree.onlyExpand) &&
                    super.equals(obj);
        }
        return false;
    }
}
