package com.bokesoft.yigo.meta.form.component.grid;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaGridFilterCollection extends GenericNoKeyCollection<MetaGridFilter> {

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(this.elementArray);
	}
	
	public static final String TAG_NAME = "GridFilterCollection";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaGridFilter.TAG_NAME.equals(tagName)) {
			MetaGridFilter filter = new MetaGridFilter();
			filter.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(filter);
			resultMetaObject = filter;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGridFilterCollection();
	}

}
