package com.bokesoft.yigo.meta.form.component.grid;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaGridColumnGroup定义表格元数据的集合，一个列分组可以包含多个列对象或列分组。
 * @author 王元和
 *
 */
public class MetaGridColumnGroup extends AbstractMetaObject implements IMetaGridColumnObject {
	/** 对象集合 */
	private ArrayList<IMetaGridColumnObject> objectArray = null;
	/** 父组 */
	private MetaGridColumnGroup parentGroup = null;
	/** 左列 */
	private int leftColumn = -1;
	/** 右列 */
	private int rightColumn = -1;
	/** 分组中定义了列扩展的行序号 */
	private int expandRowIndex = -1;
	/** 分组中定义了列扩展的单元格列序号 */
	private int expandColumnIndex = -1;
	/** 分组中定义了列扩展的单元格 */
	private MetaGridCell expandCell = null;
	public MetaGridColumnGroup(MetaGridColumnGroup parentGroup) {
		super();
		this.parentGroup = parentGroup;
		objectArray = new ArrayList<IMetaGridColumnObject>();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "ColumnGroup";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	/**
	 * 增加列对象
	 * @param column 列对齐
	 */
	public void addObject(IMetaGridColumnObject column) {
		this.objectArray.add(column);
	}
	
	/**
	 * 取得列对象的数量
	 * @return 列对象数量
	 */
	public int getObjectCount() {
		return objectArray.size();
	}
	
	/**
	 * 根据位置取得列对象
	 * @param index 位置
	 * @return 对应位置的列对象
	 */
	public IMetaGridColumnObject getObject(int index) {
		return objectArray.get(index);
	}
	
	public MetaGridColumnGroup getParentGroup() {
		return this.parentGroup;
	}
	
	public void setLeftColumn(int leftColumn) {
		this.leftColumn = leftColumn;
	}
	
	public int getLeftColumn() {
		return this.leftColumn;
	}
	
	public void setRightColumn(int rightColumn) {
		this.rightColumn = rightColumn;
	}
	
	public int getRightColumn() {
		return this.rightColumn;
	}
	
	public boolean isInRange(int index) {
		return index >= leftColumn && index <= rightColumn;
	}

	@Override
	public void printDebugInfo(int level) {
		LogSvr.getInstance().info("column group" + "\t" + level);
		Iterator<IMetaGridColumnObject> it = objectArray.iterator();
		IMetaGridColumnObject columnObject = null;
		while ( it.hasNext() ) {
			columnObject = it.next();
			columnObject.printDebugInfo(level + 1);
		}
	}

	@Override
	public int getObjectType() {
		return IMetaGridColumnObject.Group;
	}

	@Override
	public void getAll(int objectType, ArrayList<IMetaGridColumnObject> list) {
		Iterator<IMetaGridColumnObject> it = objectArray.iterator();
		IMetaGridColumnObject column = null;
		while ( it.hasNext() ) {
			column = it.next();
			if ( column.getObjectType() == objectType ) {
				list.add(column);
			}
			column.getAll(objectType, list);
		}
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return null;
	}
	
	public void setExpandRowIndex(int expandRowIndex) {
		this.expandRowIndex = expandRowIndex;
	}
	
	public int getExpandRowIndex() {
		return this.expandRowIndex;
	}
	
	public void setExpandColumnIndex(int expandColumnIndex) {
		this.expandColumnIndex = expandColumnIndex;
	}
	
	public int getExpandColumnIndex() {
		return this.expandColumnIndex;
	}
	
	public void setExpandCell(MetaGridCell expandCell) {
		this.expandCell = expandCell;
	}
	
	public MetaGridCell getExpandCell() {
		return this.expandCell;
	}
}
