package com.bokesoft.yigo.meta.form.component.grid;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaGridColumnCollection定义表格元数据中列对象的集合，由多个{@link MetaGridColumn}组成。
 * @author 王元和
 * @see MetaGridColumn
 * @see GenericNoKeyCollection
 */
public class MetaGridColumnCollection extends GenericNoKeyCollection<MetaGridColumn> {

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "GridColumnCollection";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject metaObject = null;
		if ( MetaGridColumn.TAG_NAME.equals(tagName) ) {
			MetaGridColumn metaGridColumn = new MetaGridColumn();
			metaObject = metaGridColumn;
			this.add(metaGridColumn);
		}
		return metaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGridColumnCollection();
	}

}
