package com.bokesoft.yigo.meta.form.component.grid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ColumnExpandType;
import com.bokesoft.yigo.common.def.ColumnType;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaGridColumn extends KeyPairMetaObject implements IMetaColumnExpandObject,IMetaGridColumnObject,IPropertyMerger<MetaGridColumn> {
    /**
     *
     */
    private static final long serialVersionUID = 1L;
    /** 列标识 */
    private String key = "";
    /** 用于多语种翻译列标识 */
    private String oldKey = "";
    /** 列标题 */
    private String caption = "";
    /** 列标题全称 */
    private String captionFull = "";
    /** 列英文标题 */
    private String captionEn = "";
    /** 列英文标题全称 */
    private String captionEnFull = "";
    /** 公式caption*/
    private String formulaCaption = "";
    /** 列宽 */
    private DefSize width = null;
    /** 是否可排序标志 */
    private Boolean sortable = null;
    /** 列是否可见，常量或公式，待定 */
    private String visible = "";
    /** 列的可用性*/
    private String enable = "";
    /** 选中事件,复选框类型单元格有效*/
    private MetaBaseScript onSelect = null;
    /** 列类型,-1表示未定义*/
    private Integer columnType = ColumnType.Fix;
    /** 嵌套的列集合 */
    private MetaGridColumnCollection nestColumnCollection = null;
    /** 列拓展元数据对象*/
    private MetaColumnExpand metaColumnExpand = null;
    /** 可用性依赖的组件标识*/
    private String enableDependency = "";
    /** 可见性依赖的组件标识*/
    private String visibleDependency = "";
    /** 自动生成标题,用于报表显示*/
    private Boolean autoCaption = false;
    /** 冻结,这个属性使用起来如果只配置1列,无法分清是左冻结还是右冻结,添加了Fixed属性加以替代*/
    private Boolean frozen = false;
    /** 另一个设置冻结的属性,取值为left或者right*/
    private String fixed = "";
    /** 拓展过程中使用的临时拓展值*/
    private Object expValue = null;
    /** 是否是无拓展项的拓展列*/
    private boolean invalidExpand = false;
    /** 是否是马甲删除字段 */
    private Boolean isVestDeleteCol = false;

    /** 配置文件中的key,列扩展配置会更改key属性,此属性会记录原始组件key */
    private String metaKey = "";

    private HashMap extendJson = new HashMap();

    private String metaCellImage = "";

    private boolean isNewExtField = false;

    private String image = "";

    /** ALV单元格汇总公式*/
    private String sumFormula = "";

    /** ALV分组单元格汇总公式*/
    private String groupSumFormula = "";

    /** 记录子叶列对应的原始明细单元格的key,因为列拓展会改变key,非配置属性*/
    private String orginalKey = "";

    /** 是否是列拓展的列,非配置属性*/
    private boolean isColExpand = false;

    public MetaGridColumn() {
        super();
    }

    /**
     * 获取对应的原始明细单元格的key
     * @return 对应的原始明细单元格的key
     */
    public String getOrginalKey() {
        return orginalKey;
    }

    /**
     * 设置对应的原始明细单元格的key
     * @param orginalKey 对应的原始明细单元格的key
     */
    public void setOrginalKey(String orginalKey) {
        this.orginalKey = orginalKey;
    }

    /**
     * 获取拓展值
     * @return
     */
    public Object getExpValue() {
        return expValue;
    }

    /**
     * 是否是列拓展的列
     * @return
     */
    public boolean isColExpand() {
        return isColExpand;
    }

    /**
     * 设置是否是列拓展的列
     * @param colExpand
     */
    public void setColExpand(boolean colExpand) {
        isColExpand = colExpand;
    }

    public void setMetaCellImage(String metaCellImage) {
        this.metaCellImage = metaCellImage;
    }


    public String getMetaCellImage() {
        return metaCellImage;
    }

    public void setImage(String image) {
        this.image = image;
    }


    public String getImage() {
        return image;
    }

    /**
     * 设置拓展值
     * @param expValue
     */
    public void setExpValue(Object expValue) {
        this.expValue = expValue;
    }

    /**
     * 获取列拓展元数据,这里定义了拓展的数据来源类型及列拓展的类型
     *
     * @return metaColumnExpand
     */
    @Override
    public MetaColumnExpand getColumnExpand() {
        return metaColumnExpand;
    }

    /**
     * 设置列拓展元数据对象
     *
     * @param metaColumnExpand 列扩展对象
     */
    public void setMetaColumnExpand(MetaColumnExpand metaColumnExpand) {
        this.metaColumnExpand = metaColumnExpand;
    }

    /**
     * 获取单元格汇总公式
     * @return
     */
    public String getSumFormula() {
        return sumFormula;
    }

    /**
     * 设置单元格汇总公式
     * @param sumFormula
     */
    public void setSumFormula(String sumFormula) {
        this.sumFormula = sumFormula;
    }

    /**
     * 获取分组行小计公式
     * @return
     */
    public String getGroupSumFormula() {
        return groupSumFormula;
    }

    /**
     * 设置分组行汇总公式
     * @param groupSumFormula
     */
    public void setGroupSumFormula(String groupSumFormula) {
        this.groupSumFormula = groupSumFormula;
    }

    /**
     * 取得可用性依赖关系
     * @return 依赖关系
     */
    public String getEnableDependency() {
        return enableDependency;
    }

    /**
     * 设置可用性依赖关系
     * @param enableDependency 依赖关系
     */
    public void setEnableDependency(String enableDependency) {
        this.enableDependency = enableDependency;
    }

    /**
     * 是否是无效列拓展
     * @return
     */
    public boolean isInvalidExpand() {
        return invalidExpand;
    }

    /**
     * 设置是否无效列拓展
     * @param invalidExpand
     */
    public void setInvalidExpand(boolean invalidExpand) {
        this.invalidExpand = invalidExpand;
    }

    /**
     * 获取是否冻结
     * @return 是否冻结
     */
    public Boolean isFrozen() {
        return this.frozen;
    }

    /**
     * 设置是否冻结
     * @param frozen 是否冻结
     */
    public void setFrozen(Boolean frozen) {
        this.frozen = frozen;
    }

    /**
     * 获取冻结信息
     * @return 冻结信息
     */
    public String getFixed() {
        return fixed;
    }

    /**
     * 设置冻结信息
     * @param fixed 冻结信息
     */
    public void setFixed(String fixed) {
        this.fixed = fixed;
    }

    /**
     * 取得可见性依赖关系
     * @return 依赖关系
     */
    public String getVisibleDependency() {
        return visibleDependency;
    }

    /**
     * 设置可见性依赖关系
     * @param visibleDependency 依赖关系
     */
    public void setVisibleDependency(String visibleDependency) {
        this.visibleDependency = visibleDependency;
    }

    /**
     * 是否自动生成列标题,如A,B,C...
     * @return 是否自动生成列标题的标志
     */
    public Boolean isAutoCaption() {
        return this.autoCaption;
    }

    /**
     * 设置是否自动生成列标题
     * @param autoCaption 标志
     */
    public void setAutoCaption(Boolean autoCaption) {
        this.autoCaption = autoCaption;
    }

    /**
     * 获取嵌套的列集合
     *
     * @return nestColumnCollection 列集合对象
     */
    public MetaGridColumnCollection getColumnCollection() {
        return nestColumnCollection;
    }

    /**
     * 设置嵌套的列集合
     *
     * @param nestColumnCollection 列集合对象
     */
    public void setColumnCollection(MetaGridColumnCollection nestColumnCollection) {
        this.nestColumnCollection = nestColumnCollection;
    }

    /**
     * 获得列的标识
     *
     * @return 列标识
     */
    public String getKey() {
        return key;
    }

    /**
     * 设置列的标识
     *
     * @param key 列标识
     */
    public void setKey(String key) {
        this.key = key;
    }

    /**
     * 获得列的标题
     *
     * @return 列标题
     */
    public String getCaption() {
        return caption;
    }

    /**
     * 设置列的标题
     *
     * @param caption 列标题
     */
    public void setCaption(String caption) {
        this.caption = caption;
    }

    /**
     * 获得列的标题全称
     *
     * @return 列标题 全称
     */
    public String getCaptionFull() {
        return captionFull;
    }

    /**
     * 设置列的标题全称
     *
     * @param captionFull 列标题全称
     */
    public void setCaptionFull(String captionFull) {
        this.captionFull = captionFull;
    }

    /**
     * 获取列的英文标题
     * @return 英文表题
     */
    public String getCaptionEn() {
        return captionEn;
    }

    /**
     * 设置列的英文标题
     * @param captionEn 英文标题
     */
    public void setCaptionEn(String captionEn) {
        this.captionEn = captionEn;
    }

    /**
     * 获取列的英文标题全称
     * @return 英文标题全称
     */
    public String getCaptionEnFull() {
        return captionEnFull;
    }

    /**
     * 设置列的英文标题全称
     * @param captionEnFull 英文标题全称
     */
    public void setCaptionEnFull(String captionEnFull) {
        this.captionEnFull = captionEnFull;
    }

    /**
     * 判断是否列扩展
     *
     * @return 标志
     */
    public boolean isColumnExpand() {
        return metaColumnExpand != null;
    }

    /**
     * 获取公式标题
     * @return 标题的公式定义
     */
    public String getFormulaCaption() {
        return formulaCaption;
    }

    /**
     * 设置公式标题
     * @param formulaCaption 公式
     */
    public void setFormulaCaption(String formulaCaption) {
        this.formulaCaption = formulaCaption;
    }

    /**
     * 获取选中事件
     *
     * @return 选中事件
     */
    public MetaBaseScript getOnSelect() {
        return this.onSelect;
    }

    /**
     * 设置选中事件
     *
     * @param onSelect
     *            选中事件
     */
    public void setOnSelect(MetaBaseScript onSelect) {
        this.onSelect = onSelect;
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        if( metaColumnExpand != null ) {
            list.add(metaColumnExpand);
        }
        if( nestColumnCollection != null ) {
            list.add(nestColumnCollection);
        }
        if ( onSelect != null ) {
            list.add(onSelect);
        }
    }

    public static final String TAG_NAME = "GridColumn";

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
                                                    Object node, String tagName, Object flag, int runType) throws MetaException {
        AbstractMetaObject metaObj = null;
        if (tagName.equals(MetaConstants.COLUMN_COLUMN_EXPAND)) {
            metaColumnExpand = new MetaColumnExpand();//直接初始化成员变量
            metaObj = metaColumnExpand;
        } else if (tagName.equals(MetaGridColumnCollection.TAG_NAME)) {
            nestColumnCollection = new MetaGridColumnCollection();
            metaObj = nestColumnCollection;
        } else if ( MetaConstants.Event_OnSelect.equals(tagName) ) {
            onSelect = new MetaBaseScript(MetaConstants.Event_OnSelect);
            metaObj = onSelect;
        }
        if(metaObj != null){
            metaObj.preProcessMetaObject(env, doc, node, flag, runType);
        }
        return metaObj;
    }

    /**
     * 取得列宽定义
     *
     * @return 列宽
     */
    public DefSize getWidth() {
        return this.width;
    }

    /**
     * 设置列宽定义
     *
     * @param width
     *            列宽
     */
    public void setWidth(DefSize width) {
        this.width = width;
    }

    /**
     * 设置可排序标志
     *
     * @param sortable
     *            标志
     */
    public void setSortable(Boolean sortable) {
        this.sortable = sortable;
    }

    /**
     * 取得可排序标志
     *
     * @return 标志
     */
    public Boolean getSortable() {
        return this.sortable;
    }

    /**
     * 设置可见性条件
     *
     * @param visible
     *            可见性条件
     */
    public void setVisible(String visible) {
        this.visible = visible;
    }

    /**
     * 取得可见性条件
     *
     * @return 可见性条件
     */
    public String getVisible() {
        return this.visible;
    }

    /**
     * 设置列类型
     *
     * @param columnType
	 *            列类型，取值见{@link com.bokesoft.yigo.common.def.ColumnType}
	 * @see com.bokesoft.yigo.common.def.ColumnType
     */
    public void setColumnType(Integer columnType) {
        this.columnType = columnType;
    }

    /**
     * 取得列类型
     *
	 * @return 列类型，见{@link com.bokesoft.yigo.common.def.ColumnType}
	 * @see com.bokesoft.yigo.common.def.ColumnType
     */
    public Integer getColumnType() {
        return this.columnType;
    }

    @Override
    public void printDebugInfo(int level) {
        LogSvr.getInstance().info("column" + "\t" + level);
    }

    @Override
    public int getObjectType() {
        return IMetaGridColumnObject.Column;
    }

    @Override
    public void getAll(int objectType, ArrayList<IMetaGridColumnObject> list) {
    }

    /**
     * 是否有子列
     * @return 子否有子列
     */
    public boolean hasChildren() {
        return this.nestColumnCollection != null && this.nestColumnCollection.size() > 0;
    }

    /**
     * 取得列的可用性条件
     * @return 列的可用性条件
     */
    public String getEnable() {
        return enable;
    }

    /**
     * 设值列的可用性条件
     * @param enable 可用性条件
     */
    public void setEnable(String enable) {
        this.enable = enable;
    }

    /**
     * 获取列的原本标识
     * @return oldKey
     */
    public String getOldKey() {
        return oldKey;
    }

    /**
     * 设置列的原标识
     * @param oldKey 列的原标识
     */
    public void setOldKey(String oldKey) {
        this.oldKey = oldKey;
    }

    /**
     * 获取是否是马甲删除字段
     *
     * @return
     */
    public Boolean isVestDeleted() {
        return isVestDeleteCol;
    }

    /**
     * 设置是否是马甲删除字段
     *
	 * @param isVestDeleteCol
     */
    public void setIsVestDeleteCol(Boolean isVestDeleteCol) {
        this.isVestDeleteCol = isVestDeleteCol;
    }

    public boolean isNewExtField() {
        return isNewExtField;
    }

    public void setNewExtField(boolean newExtField) {
        isNewExtField = newExtField;
    }
    /**
     * 获取配置文件中组件的key
	 * @return metaKey
     */
    public String getMetaKey() {
        return metaKey;
    }

    /**
     * 设置组件的key
     * @param metaKey
     */
    public void setMetaKey(String metaKey) {
        this.metaKey = metaKey;
    }

    public HashMap getExtendJson() {
        return extendJson;
    }

    public void setExtendJson(HashMap extendJson) {
        this.extendJson = extendJson;
    }

    @Override
    public boolean needPreLoad() {
        return false;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaGridColumn newObject = new MetaGridColumn();
        newObject.setKey(key);
        newObject.setMetaKey(metaKey);
        newObject.setOldKey(oldKey);
        newObject.setCaption(caption);
        newObject.setCaptionFull(captionFull);
        newObject.setCaptionEn(captionEn);
        newObject.setCaptionEnFull(captionEnFull);
        newObject.setWidth(width);
        newObject.setSortable(sortable);
        newObject.setVisible(visible);
        newObject.setEnable(enable);
        newObject.setFrozen(frozen);
        newObject.setFixed(fixed);
        newObject.setColumnType(columnType);
        newObject.setOnSelect(onSelect == null ? null : (MetaBaseScript)onSelect.clone());
        newObject.setMetaColumnExpand(metaColumnExpand == null ? null : (MetaColumnExpand)metaColumnExpand.clone());
        newObject.setEnableDependency(enableDependency);
        newObject.setVisibleDependency(visibleDependency);
        newObject.setFormulaCaption(formulaCaption);
        newObject.setImage(image);
        newObject.setSumFormula(sumFormula);
        newObject.setGroupSumFormula(groupSumFormula);
        newObject.setOrginalKey(orginalKey);
        newObject.setColExpand(isColExpand);

        MetaGridColumnCollection newColumnCollection = new MetaGridColumnCollection();
        if (nestColumnCollection != null) {
            int length = nestColumnCollection.size();
            for (int i = 0; i < length; i++) {
                MetaGridColumn column = nestColumnCollection.get(i);
                AbstractMetaObject obj = column.clone();
                newColumnCollection.add((MetaGridColumn) obj);
            }
            newObject.setColumnCollection(newColumnCollection);
        }
        return newObject;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaGridColumn();
    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
        super.doPostProcess(flag, callback);

        if( this.metaColumnExpand != null && this.metaColumnExpand.getExpandType() == ColumnExpandType.DATA ) {
            this.isColExpand = true;

            if( this.nestColumnCollection != null ) {
                for( MetaGridColumn column : this.nestColumnCollection ) {
                    column.setColExpand(true);
                }
            }
        }
        if( this.nestColumnCollection != null ) {
            this.nestColumnCollection.doPostProcess(flag,callback);
        }
    }

    @Override
    public void merge(MetaGridColumn metaColumn) {
        if( this.caption == null ) {
            this.caption = metaColumn.getCaption();
        }
        if( this.captionFull == null ) {
            this.captionFull = metaColumn.getCaptionFull();
        }
        if( this.captionEn == null ) {
            this.captionEn = metaColumn.getCaptionEn();
        }
        if( this.captionEnFull == null ) {
            this.captionEnFull = metaColumn.getCaptionEnFull();
        }
        if( this.formulaCaption == null ) {
            this.formulaCaption = metaColumn.getFormulaCaption();
        }
        if( this.width == null ) {
            this.width = metaColumn.getWidth();
        }
        if( this.sortable == null ) {
            this.sortable = metaColumn.getSortable();
        }
        if( this.visible == null ) {
            this.visible = metaColumn.getVisible();
        } else {
            extendJson.put("visible",metaColumn.getVisible());
        }
        if( this.enable == null ) {
            this.enable = metaColumn.getEnable();
        } else {
            extendJson.put("enable",metaColumn.getEnable());
        }
        if( this.image == null ) {
            this.image = metaColumn.getImage();
        }
        if( this.columnType == -1 ) {
            this.columnType = metaColumn.getColumnType();
        }
        MetaColumnExpand ce = metaColumn.getColumnExpand();
        if( this.metaColumnExpand == null && ce != null ) {
            this.metaColumnExpand = (MetaColumnExpand) ce.clone();
        }
        if( this.enableDependency == null ) {
            this.enableDependency = metaColumn.getEnableDependency();
        }
        if( this.visibleDependency == null ) {
            this.visibleDependency = metaColumn.getVisibleDependency();
        }
        if( this.autoCaption == null ) {
            this.autoCaption = metaColumn.isAutoCaption();
        }
        if( this.frozen == null ) {
            this.frozen = metaColumn.isFrozen();
        }
        if( this.fixed == null ) {
            this.fixed = metaColumn.getFixed();
        }
        if( this.onSelect == null ) {
            this.onSelect = metaColumn.getOnSelect();
        }
        if( this.sumFormula == null ) {
            this.sumFormula = metaColumn.getSumFormula();
        }
        if( this.groupSumFormula == null ) {
            this.groupSumFormula = metaColumn.getGroupSumFormula();
        }
    }
}
