package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaUploadButtonProperties extends AbstractMetaObject {
	
	/** 上传文件的大小,-1表示无限制 */
	private Integer maxSize = -1;
	/** 允许上传的文件的类型, 用";"隔开*/
	private String allowedTypes ="";
	/**  是否删除前一次上传的文件 **/
	private Boolean deleteOld = false;
	/**  是多文件上传 （暂时没有处理）**/
	private Boolean isMultiFile = false;
	/** 后台完成事件(定义的是一个Name, 通过Name
	 * 在Enhance的ExtAttachmentProcess中去取实现方法) **/
	private String postProcess = null;
	/** 前台完成事件 **/
	private MetaBaseScript finishedEvent = null;
	/** 上传服务的实现类标识*/
	private String provider = "";
	/** 允许上传的文件的类型~来源于公式*/
	private String allowedTypesFormula = "";

	/** 
	 * 取得上传文件的大小，-1表示无限制
	 * @return 文件大小
	 * */
	public Integer getMaxSize() {
		return maxSize;
	}

	
	/** 
	 * 设置上传文件的大小， -1表示无限制
	 * @param maxSize 文件大小
	 * */
	public void setMaxSize(Integer maxSize) {
		this.maxSize = maxSize;
	}

	
	/**
	 * 取得允许的文件类型
	 * @return 允许的文件类型
	 */
	public String getAllowedTypes() {
		return allowedTypes;
	}

	/**
	 * 设置允许的文件类型
	 * @param allowedTypes 允许的文件类型
	 */
	public void setAllowedTypes(String allowedTypes) {
		this.allowedTypes = allowedTypes;
	}

	/**
	 * 设置删除前一次上传的文件
	 * @param deleteOld 是否删除前一次上传的文件
	 */
	
	public void setDeleteOld(Boolean deleteOld) {
		this.deleteOld = deleteOld;
	}
	
	/**
	 * 获取删除前一次上传的文件
	 * @return 是否删除前一次上传的文件
	 */
	public Boolean isDeleteOld() {
		return deleteOld;
	}
	
	/**
	 * 设置是否多文件上传
	 * @param isMultiFile 是否多文件上传
	 */
	public void setMultiFile(Boolean isMultiFile) {
		this.isMultiFile = isMultiFile;
	}
	
	
	/**
	 * 获取是否多文件上传
	 * @return 是否多文件上传
	 */
	public Boolean isMultiFile() {
		return isMultiFile;
	}
	
	
	/**
	 * 设置后台上传完成事件
	 * @param postProcess 后台上传完成事件
	 */
	public void setPostProcess(String postProcess) {
		this.postProcess = postProcess;
	}
	
	
	/**
	 * 获取后台上传完成事件
	 * @return 后台上传完成事件
	 */
	public String getPostProcess() {
		return postProcess;
	}
	
	
	/**
	 * 设置前台上传完成事件
	 * @param finishedEvent 前台上传完成事件
	 */
	public void setFinishEvent(MetaBaseScript finishedEvent) {
		this.finishedEvent = finishedEvent;
	}
	
	
	/**
	 * 获取前台上传完成事件
	 * @return 前台上传完成事件
	 */
	public MetaBaseScript getFinishEvent() {
		return finishedEvent;
	}
	
	/**
	 * 设置上传服务的实现类标识
	 * @param provider 上传服务的实现类标识
	 */
	public void setProvider(String provider) {
		this.provider = provider;
	}
	
	
	/**
	 * 获取上传服务的实现类标识
	 * @return 上传服务的实现类标识
	 */
	public String getProvider() {
		return provider;
	}

	/**
	 * 设置允许的文件类型 ~来源于公式
	 * @param allowedTypesFormula 允许的文件类型~公式
	 */
	public void setAllowedTypesFormula(String allowedTypesFormula) {
		this.allowedTypesFormula = allowedTypesFormula;
	}
	
	/**
	 * 取得允许的文件类型~来源于公式
	 * @return 允许的文件类型~公式
	 */
	public String getAllowedTypesFormula() {
		return allowedTypesFormula;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if ( finishedEvent != null ) {
			list.add(finishedEvent);
		}
	}
	

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaConstants.Event_FinishedEvent.equals(tagName) ) {
			finishedEvent = new MetaBaseScript(MetaConstants.Event_FinishedEvent);
			resultMetaObject = finishedEvent;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaUploadButtonProperties newObject = new MetaUploadButtonProperties();
		newObject.setMaxSize(maxSize);
		newObject.setAllowedTypes(allowedTypes);
		newObject.setDeleteOld(deleteOld);
		newObject.setMultiFile(isMultiFile);
		newObject.setPostProcess(postProcess);
		newObject.setFinishEvent(finishedEvent == null ? null : (MetaBaseScript)finishedEvent.clone());
		newObject.setProvider(provider);
		newObject.setAllowedTypesFormula(allowedTypesFormula);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaUploadButtonProperties();
	}

}
