package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaStateItem extends AbstractMetaObject {
	/** 状态值 */
	private String value = "";
	/** 状态文本 */
	private String text = "";
	/** 图片 */
	private String icon = "";
	/** key */
	private String key = "";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}
	
	/**
	 * 设置状态值
	 * @param value 状态值
	 */
	public void setValue(String value) {
		this.value = value;
	}
	
	/**
	 * 取得状态值
	 * @return 状态值
	 */
	public String getValue() {
		return this.value;
	}
	
	/**
	 * 设置状态文本
	 * @param text 状态文本
	 */
	public void setText(String text) {
		this.text = text;
	}
	
	/**
	 * 取得状态文本
	 * @return 状态文本
	 */
	public String getText() {
		return this.text;
	}
	
	
	/**
	 * 取得图片
	 * @return 
	 */
	public String getIcon() {
		return icon;
	}

	/**
	 * 设置图片
	 * @param icon 图片
	 */
	public void setIcon(String icon) {
		this.icon = icon;
	}

	/**
	 * 取得key
	 * @return 
	 */
	public String getKey() {
		return key;
	}

	/**
	 * 设置key
	 * @param key
	 */
	public void setKey(String key) {
		this.key = key;
	}



	public static final String TAG_NAME = "StateItem";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaStateItem newObject = (MetaStateItem)newInstance();
		newObject.setValue(value);
		newObject.setText(text);
		newObject.setIcon(icon);
		newObject.setKey(key);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaStateItem();
	}

}
