package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.IconLocationType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaMultiStateButtonProperties extends AbstractMetaObject  implements IPropertyMerger<MetaMultiStateButtonProperties>{
	
	/**图片位置*/
	private Integer iconLocation = IconLocationType.LEFT;
	/** 点击事件 */
	private MetaBaseScript onClick = null;
	/** 下拉项集合 */
	private MetaStateItemCollection itemCollection = new MetaStateItemCollection();
	
	/**
	 * 获取图片方向
	 * @return
	 */
	public Integer getIconLocation() {
		return iconLocation;
	}

	/**
	 * 设置图片方向
	 * @param iconLocation 图片方向
	 */
	public void setIconLocation(Integer iconLocation) {
		this.iconLocation = iconLocation;
	}
	
	/**
	 * 设置按钮点击事件
	 * 
	 * @param onClick
	 *            按钮点击事件
	 */
	public void setOnClick(MetaBaseScript onClick) {
		this.onClick = onClick;
	}

	/**
	 * 获取按钮点击事件
	 * 
	 * @return 点击事件
	 */
	public MetaBaseScript getOnClick() {
		return this.onClick;
	}
	
	
	/**
	 * 取得下拉项集合
	 * @return 下拉项集合
	 */
	public MetaStateItemCollection getItemCollection() {
		return itemCollection;
	}

	/**
	 * 设置下拉项集合
	 * @param itemCollection 下拉项集合
	 */
	public void setItemCollection(MetaStateItemCollection itemCollection) {
		this.itemCollection = itemCollection;
	}

	@Override
	public void merge(MetaMultiStateButtonProperties properties) {
		if( this.onClick == null ){
			this.onClick = properties.getOnClick();
		}
		
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if(onClick != null){
			list.add(onClick);
		}
		if ( itemCollection != null ) {
			list.add(itemCollection);
		}
		
	}

	@Override
	public String getTagName() {
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = itemCollection.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if ( MetaConstants.Event_OnClick.equals(tagName) ) {
			onClick = new MetaBaseScript(MetaConstants.Event_OnClick);
			resultMetaObject = onClick;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaMultiStateButtonProperties newObject = new MetaMultiStateButtonProperties();
		newObject.setIconLocation(iconLocation);
		newObject.setOnClick(onClick == null ? null : (MetaBaseScript)onClick.clone());
		newObject.setItemCollection(itemCollection == null ? null : (MetaStateItemCollection)itemCollection.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMultiStateButtonProperties();
	}

}
