package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaItemFilterCollection extends GenericNoKeyCollection<MetaItemFilter> {

	private static final long serialVersionUID = 1L;

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(this.elementArray);
	}

	public static final String TAG_NAME = "ItemFilterCollection";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
													Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaItemFilter.TAG_NAME.equals(tagName)) {
			MetaItemFilter filter = new MetaItemFilter();
			filter.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(filter);
			resultMetaObject = filter;
		}
		return resultMetaObject;
	}

	@Override
	public void traversalCollectionObjects(IMetaEnv env, Object doc,
										   Object node, Object flag, int runType) throws MetaException {
	}
	public boolean isStandaloneNode() {
		return false;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return new MetaItemFilterCollection();
	}

	public MetaItemFilter get(String sItemKey) {
		Iterator<MetaItemFilter> it = this.iterator();
		MetaItemFilter filter = null;
		MetaItemFilter defaultFilter = null; // 未找到字典过滤项集合中对应于sItemKey的过滤项目时候，默认取未设置ItemKey(即ItemKey为空)的过滤项, 动态字典中可能多个字典共用过滤项
		while(it.hasNext()){
			filter = it.next();
			if(filter.getItemKey().equalsIgnoreCase(sItemKey)){
				return filter;
			}
			if (StringUtil.isBlankOrNull(filter.getItemKey())) {
				defaultFilter = filter;
			}
		}
		return defaultFilter;

	}

}
