package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.SelectEditType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaDatePickerProperties extends AbstractMetaObject implements IPropertyMerger<MetaDatePickerProperties>{
	/** 日期时间的显示格式 */
	private String dateFormat = null;

	/** 是否仅保留日期部分 */
	private Boolean isOnlyDate = false;
	
	/** 文本编辑器为空时的提示信息 */
	private String promptText = "";
	
	/** 编辑样式*/
	private Integer editType = SelectEditType.DIALOG;
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	
	}
	
	/**
	 * 设置日期时间的显示格式
	 * 
	 * @param dateFormat
	 *            显示格式
	 */
	public void setDateFormat(String dateFormat) {
		this.dateFormat = dateFormat;
	}

	/**
	 * 获取日期时间的显示格式
	 * 
	 * @return 显示格式
	 */
	public String getDateFormat() {
		return this.dateFormat;
	}

	/**
	 * 设置是否仅保留日期部分
	 * 
	 * @param isOnlyDate
	 *            是否仅保留日期部分
	 */
	public void setOnlyDate(Boolean isOnlyDate) {
		this.isOnlyDate = isOnlyDate;
	}

	/**
	 * 获取是否仅保留日期部分
	 * 
	 * @return 是否仅保留日期部分
	 */
	public Boolean isOnlyDate() {
		return this.isOnlyDate == null ? false : this.isOnlyDate;
	}
	
	/**
	 * 设置文本为空时的提示信息
	 * 
	 * @param promptText
	 *            提示信息
	 */
	public void setPromptText(String promptText) {
		this.promptText = promptText;
	}

	/**
	 * 获取文本为空时的提示信息
	 * 
	 * @return 提示信息
	 */
	public String getPromptText() {
		return this.promptText;
	}
	
	public void setEditType(Integer editType) {
		this.editType = editType;
	}
	
	public Integer getEditType() {
		return editType;
	}
	

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDatePickerProperties newObject = (MetaDatePickerProperties)newInstance();
		newObject.setDateFormat(dateFormat);
		newObject.setOnlyDate(isOnlyDate);
		newObject.setPromptText(promptText);
		newObject.setEditType(editType);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDatePickerProperties();
	}

	@Override
	public void merge(MetaDatePickerProperties properties) {
		if( this.dateFormat == null ) {
			this.dateFormat = properties.getDateFormat();
		}
		if( this.isOnlyDate == null ) {
			this.isOnlyDate = properties.isOnlyDate();
		}
		if( this.promptText == null ) {
			this.promptText = properties.getPromptText();
		}
		if(editType == -1){
			this.editType = properties.getEditType();
		}
	}

}
