package com.bokesoft.yigo.meta.form.component.control.navigationlist;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.ImageScaleType;
import com.bokesoft.yigo.common.def.NavigationListSource;
import com.bokesoft.yigo.common.def.NavigationListStyle;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

public class MetaNavigationList extends MetaComponent {

	public static final String TAG_NAME = "NavigationList";

	private MetaNavigationItemCollection itemCollection = null;
	private MetaNavigationListRow listRow = null;
	
	/**取值为List(列表式)、TileList(平铺式)；默认为TileList；*/
	private Integer style = NavigationListStyle.TiledList;
	/**来源，其值为Self（自身定义）和Entry（Entry.xml文件中的菜单树定义），默认self */
	private Integer source = NavigationListSource.Self;
	/**来源为Entry时，指定Entry.xml文件定义的特定的节点路径。如果不写，默认为根节点 */
	private String entryPath = "";
	/**是否检查所有的entry的权限。默认为true。*/
	private Boolean allEntryFilter = true;
	/**平铺列数：平铺样式时，每行的列数 */
	private Integer columnCount = 3;
	/**每个入口定义的Icon的缩放样式。 */
	private Integer imageScaleType = ImageScaleType.CENTER; 
	
	/**
	 * 设置样式
	 * @param style 样式
	 */
	public void setStyle(Integer style) {
		this.style = style;
	}
	
	/**
	 * 获取样式
	 * @return 样式
	 */
	public Integer getStyle() {
		return style;
	}
	
	/**
	 * 设置来源
	 * @param source 来源
	 */
	public void setSource(Integer source) {
		this.source = source;
	}
	
	/**
	 * 获取来源
	 * @return 来源
	 */
	public Integer getSource() {
		return source;
	}
	
	/**
	 * 设置节点路径
	 * @param entryPath 节点路径
	 */
	public void setEntryPath(String entryPath) {
		this.entryPath = entryPath;
	}
	
	/**
	 * 获取节点路径
	 * @return 节点路径
	 */
	public String getEntryPath() {
		return entryPath;
	}
	
	/**
	 * 设置是否拥有所有的入口权限
	 * @param allEntryFilter 是否拥有所有的入口权限
	 */
	public void setAllEntryFilter(Boolean allEntryFilter) {
		this.allEntryFilter = allEntryFilter;
	}
	
	/**
	 * 获取是否拥有所有的入口权限
	 * @return 是否拥有所有的入口权限
	 */
	public Boolean isAllEntryFilter() {
		return allEntryFilter;
	}
	
	/**
	 * 设置平铺列数
	 * @param columnCount 平铺列数
	 */
	public void setColumnCount(Integer columnCount) {
		this.columnCount = columnCount;
	}
	
	/**
	 * 获取平铺列数
	 * @return 平铺列数
	 */
	public Integer getColumnCount() {
		return columnCount;
	}
	
	/**
	 * 设置缩放样式
	 * @param imageScaleType 缩放样式
	 */
	public void setImageScaleType(Integer imageScaleType) {
		this.imageScaleType = imageScaleType;
	}
	
	
	/**
	 * 获取缩放样式
	 * @return 缩放样式
	 */
	public Integer getImageScaleType() {
		return imageScaleType;
	}
	
	/**
	 * 设置导航项样式
	 * @param listRow 导航项样式
	 */
	public void setListRow(MetaNavigationListRow listRow) {
		this.listRow = listRow;
	}
	
	/**
	 * 获取导航项样式
	 * @return 导航项样式
	 */
	public MetaNavigationListRow getListRow() {
		return listRow;
	}
	
	
	/**
	 * 设置导航项目
	 * @param itemCollection 导航项目
	 */
	public void setItemCollection(MetaNavigationItemCollection itemCollection) {
		this.itemCollection = itemCollection;
	}
	
	/**
	 * 获取导航项目
	 * @return 导航项目
	 */
	public MetaNavigationItemCollection getItemCollection() {
		return itemCollection;
	}
	
	
	public MetaNavigationListRow ensureListRow() {
		if (this.listRow == null) {
			this.listRow = new MetaNavigationListRow();
		}
		return this.listRow;
	}

	@Override
	public int getControlType() {
		return ControlType.NAVIGATIONLIST;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		addAll(list, new AbstractMetaObject[] { itemCollection, listRow });
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaNavigationItemCollection.TAG_NAME)) {
			itemCollection = new MetaNavigationItemCollection();
			resultMetaObject = itemCollection;
		} else if (tagName.equalsIgnoreCase(MetaNavigationListRow.TAG_NAME)) {
			listRow = new MetaNavigationListRow();
			resultMetaObject = listRow;
		}
		if (resultMetaObject == null) {
			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaNavigationList();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaNavigationList meta = (MetaNavigationList)super.clone();
		meta.setStyle(style);
		meta.setSource(source);
		meta.setEntryPath(entryPath);
		meta.setAllEntryFilter(allEntryFilter);
		meta.setColumnCount(columnCount);
		meta.setImageScaleType(imageScaleType);
		meta.setListRow(listRow == null ? null : (MetaNavigationListRow)listRow.clone());
		meta.setItemCollection(itemCollection == null ? null : (MetaNavigationItemCollection)itemCollection.clone());
		return meta;
	}
}
