package com.bokesoft.yigo.meta.form.component.control.navigationlist;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaNavigationItem extends KeyPairMetaObject {

	public static final String TAG_NAME = "NavigationItem";
	/**导航项目的标识*/
	private String key = "";
	/**导航项目的名称*/
	private String caption = "";
	/**导航项目图标*/
	private String icon = "";
	/**关联的Entry.xml文件中定义的入口的相对路径*/
	private String entryKey = "";
	/**是否检查权限*/
	private Boolean entryFilter = null;
	/**入口项定义的Icon的缩放样式。如果没写，则默认为NavigationList定义的ImageScaleType样式。*/
	private Integer imageScaleType = -1;
	/**入口项的点击事件*/
	private String onclick = null;
	

	@Override
	public String getKey() {
		return key;
	}

	/**
	 * 设置导航项目的标识
	 * @param Key 导航项目的标识
	 */
	public void setKey(String Key) {
		this.key = Key;
	}
	
	
	/**
	 * 获取导航项目的名称
	 * @return 导航项目的名称
	 */
	public String getCaption() {
		return caption;
	}
	
	/**
	 * 设置导航项目的名称
	 * @param caption 导航项目的名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 获取导航项目图标
	 * @return 导航项目图标
	 */
	
	public String getIcon() {
		return icon;
	}
	
	/**
	 * 设置导航项目图标
	 * @param icon 导航项目图标
	 */
	public void setIcon(String icon) {
		this.icon = icon;
	}
	
	/**
	 * 获取入口的相对路径
	 * @return 入口的相对路径
	 */
	public String getEntryKey() {
		return entryKey;
	}
	
	/**
	 * 设置入口的相对路径
	 * @param entryKey 入口的相对路径
	 */
	public void setEntryKey(String entryKey) {
		this.entryKey = entryKey;
	}
	
	/**
	 * 是否拥有权限
	 * @return 是否拥有权限
	 */
	public Boolean isEntryFilter() {
		return entryFilter;
	}
	
	/**
	 * 设置是否拥有权限
	 * @param entryFilter 是否拥有权限
	 */
	public void setEntryFilter(Boolean entryFilter) {
		this.entryFilter = entryFilter;
	}
	
	/**
	 * 获取缩放样式
	 * @return 缩放样式
	 */
	public Integer getImageScaleType() {
		return imageScaleType;
	}
	
	/**
	 * 设置缩放样式
	 * @param imageScaleType 缩放样式
	 */
	public void setImageScaleType(Integer imageScaleType) {
		this.imageScaleType = imageScaleType;
	}
	
	/**
	 * 获取点击事件
	 * @return 点击事件
	 */
	public String getOnclick() {
		return onclick;
	}

	/**
	 * 设置点击事件
	 * @param onclick 点击事件
	 */
	public void setOnclick(String onclick) {
		this.onclick = onclick;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject obj = null;
		return obj;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaNavigationItem meta = new MetaNavigationItem();
		meta.setKey(key);
		meta.setCaption(caption);
		meta.setIcon(icon);
		meta.setEntryKey(entryKey);
		meta.setEntryFilter(entryFilter);
		meta.setImageScaleType(imageScaleType);
		meta.setOnclick(onclick);
		return meta;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaNavigationItem();
	}
	

}
