package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDatePickerProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaUTCDatePickerProperties;

/**
 * UTC日期选择配置对象
 */
public class MetaUTCDatePicker extends MetaDatePicker {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_UTCDATEPICKER;

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.UTCDATEPICKER;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaUTCDatePicker newObject = (MetaUTCDatePicker)super.clone();
		newObject.setProperties((MetaUTCDatePickerProperties)properties.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaUTCDatePicker();
	}

	@Override
	public MetaUTCDatePickerProperties getProperties() {
		return (MetaUTCDatePickerProperties)properties;
	}
	
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaUTCDatePickerProperties) properties;
	}
	
	@Override
	public MetaDatePickerProperties newProperties() {
		return new MetaUTCDatePickerProperties();
	}
}
