package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaMultiStateButtonProperties;

public class MetaMultiStateButton extends MetaComponent  {
	/**配置文件中对应的节点的标签名称*/
	public static final String TAG_NAME = ControlType.STR_MULTISTATEBUTTON;
	
	private MetaMultiStateButtonProperties properties = new MetaMultiStateButtonProperties();
	
	/**
	 * 获取图片方向
	 * @return
	 */
	public Integer getIconLocation() {
		return this.properties.getIconLocation();
	}

	/**
	 * 设置图片方向
	 * @param iconLocation 图片方向
	 */
	public void setIconLocation(Integer iconLocation) {
		this.properties.setIconLocation(iconLocation);
	}
	
	/**
	 * 设置按钮点击事件
	 * 
	 * @param onClick
	 *            按钮点击事件
	 */
	public void setOnClick(MetaBaseScript onClick) {
		properties.setOnClick(onClick);
	}

	/**
	 * 获取按钮点击事件
	 * 
	 * @return 点击事件
	 */
	public MetaBaseScript getOnClick() {
		return properties.getOnClick();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaMultiStateButton newObject = (MetaMultiStateButton) super.clone();
		newObject.setProperties(properties.clone());
		return newObject;
	}
	
	@Override
	public int getControlType() {
		return ControlType.MULTISTATEBUTTON;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return properties;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return properties;
	}

}
