package com.bokesoft.yigo.meta.form.component.control;

import java.util.HashMap;
import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.form.MetaFormMergeHandler;
import com.bokesoft.yigo.meta.mobiledef.MetaMobileDef;

/**
 * 控件关联字段的信息对象，主要包含关联字段的标识及其所在表的标识，即columnKey和tableKey
 *
 * <p>
 * 		现在单元格和控件的DefaultFormulaValue也是放在MetaDataBinding上
 * </p>
 *
 * @author chenzs
 * @since YES1.0
 */
public class MetaDataBinding extends AbstractMetaObject implements IPropertyMerger<MetaDataBinding>{

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = "DataBinding";

	/** 关联字段所在表的标识 */
	private String tableKey = "";

	/** 关联字段的标识 */
	private String columnKey = "";

	/** 是否为必填项，默认为false,马甲时,可能为null */
	private Boolean isRequired = false;

	/** 值验证 */
	private MetaBaseScript valueValidation = null;

	/** 值确认事件 */
	private String valueChanging = "";

	/** 值确认事件节点 */
	private MetaBaseScript valueChangingNode = null;

	/** 值变化事件 */
	private String valueChanged = "";

	/** 值变化事件节点 */
	private MetaBaseScript valueChangedNode = null;

	/**值变化后事件**/
	private String valueChangeAction = "";
	/**值变化后事件节点**/
	private MetaBaseScript  valueChangeActionNode = null;

	/** 文本变化事件节点*/
	private MetaBaseScript textChangedNode = null;

	/** 默认值 */
	private String defaultValue = "";

	/** 以表达式表示的默认值 */
	private String defaultFormulaValue = "";
	/** 以表达式表示的默认值节点 */
	private MetaBaseScript defaultFormulaValueNode = null;

	/** 值依赖的域集合 */
	private String valueDependency = "";

	/** 检查规则 */
	private String checkRule = "";
	/** 检查规则节点 */
	private MetaBaseScript checkRuleNode = null;

	/** 错误描述 */
	private String errorInfo = "";

	/** 错误字符串标识 */
	private String errorStringID = "";

	/** 检查规则依赖的域集合 */
	private String checkDependency = "";

	/** 必填项图标，仅在原本支持图标的控件上生效 */
	private String requiredIcon = "";
	
	/** 检查通过图标，仅在原本支持检查图标的控件上生效 */
	private String checkRulePassIcon = "";
	
	/** 检查不通过图标，仅在原本支持检查图标的控件上生效 */
	private String checkRuleErrorIcon = "";

	private HashMap extendJson = new HashMap();

	public HashMap getExtendJson() {
		return extendJson;
	}

	public MetaDataBinding() {
		super();
	}

	/**
	 * 设置关联字段所在表的标识
	 *
	 * @param tableKey 表的标识
	 */
	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}

	/**
	 * 获取关联字段所在表的标识
	 *
	 * @return 表标识
	 */
	public String getTableKey() {
		return tableKey;
	}

	/**
	 * 设置关联字段的标识
	 *
	 * @param columnKey 关联字段的标识
	 */
	public void setColumnKey(String columnKey) {
		this.columnKey = columnKey;
	}

	/**
	 * 获取关联字段的标识
	 *
	 * @return 标识
	 */
	public String getColumnKey() {
		return this.columnKey;
	}

	/**
	 * 设置是否必填
	 * @param isRequired 是否必填标志
	 */
	public void setRequired(Boolean isRequired) {
		this.isRequired = isRequired;
	}

	/**
	 * 取得是否必填
	 * @return 是否必填标志
	 */
	public Boolean isRequired() {
		return this.isRequired;
	}

	/**
	 * 设置值验证
	 * @param valueValidation 值验证
	 */
	public void setValueValidation(MetaBaseScript valueValidation) {
		this.valueValidation = valueValidation;
	}

	/**
	 * 取得值验证
	 * @return 值验证
	 */
	public MetaBaseScript getValueValidation() {
		return this.valueValidation;
	}

	/**
	 * 设置值确认事件
	 * @param valueChanging 值确认事件
	 */
	public void setValueChanging(String valueChanging) {
		this.valueChanging = valueChanging;
		if(valueChanging != null && valueChanging.length() >0 && valueChanging.indexOf("//")==-1){
			if ( (valueChanging.length()>50)) {
				if ( valueChangingNode == null ) {
					this.valueChangingNode = new MetaBaseScript(MetaConstants.Event_ValueChanging);
				}
				valueChangingNode.setContent(valueChanging);
			} else {
				this.valueChangingNode = null;
			}
		}else if(valueChanging != null && valueChanging.length() >0){
			if (this.valueChangingNode == null) {
				this.valueChangingNode = new MetaBaseScript(MetaConstants.Event_ValueChanging);
			}
			this.valueChangingNode.setContent(valueChanging);
		}
	}

	/**
	 * 取得值确认事件
	 * @return 值确认事件
	 */
	public String getValueChanging() {
		if ( this.valueChangingNode != null ) {
			return this.valueChangingNode.getContent();
		}
		return this.valueChanging;
	}

	/**
	 * 设置值确认事件节点
	 * @param valueChangingNode 值确认事件节点
	 */
	public void setValueChangingNode(MetaBaseScript valueChangingNode) {
		this.valueChangingNode = valueChangingNode;
	}

	/**
	 * 取得值确认事件节点
	 * @return 值确认事件节点
	 */
	public MetaBaseScript getValueChangingNode() {
		return this.valueChangingNode;
	}

	/**
	 * 设置值改变事件
	 * @param valueChanged 值改变事件
	 */
	public void setValueChanged(String valueChanged) {
		this.valueChanged = valueChanged;
		if(valueChanged != null && valueChanged.length() >0 && valueChanged.indexOf("//")==-1){
			if ( (valueChanged.length()>50)) {
				if ( this.valueChangedNode == null ) {
					this.valueChangedNode = new MetaBaseScript(MetaConstants.Event_ValueChanged);
				}
				this.valueChangedNode.setContent(valueChanged);
			} else {
				this.valueChangedNode = null;
			}
		}else if(valueChanged != null && valueChanged.length() >0){
			if (this.valueChangedNode == null) {
				this.valueChangedNode = new MetaBaseScript(MetaConstants.Event_ValueChanged);
			}
			this.valueChangedNode.setContent(valueChanged);
		}
	}

	/**
	 * 取得值改变事件
	 * @return 值改变事件
	 */
	public String getValueChanged() {
		if ( this.valueChangedNode != null ) {
			return this.valueChangedNode.getContent();
		}
		return this.valueChanged;
	}

	/**
	 * 设置值改变事件节点
	 * @param valueChangedNode 值改变事件节点
	 */
	public void setValueChangedNode(MetaBaseScript valueChangedNode) {
		this.valueChangedNode = valueChangedNode;
	}

	/**
	 * 取得值改变事件节点
	 * @return 值改变事件节点
	 */
	public MetaBaseScript getValueChangedNode() {
		return this.valueChangedNode;
	}


	/**
	 * 设置值改变后事件
	 */
	public void setValueChangeAction(String valueChangeAction) {
		this.valueChangeAction = valueChangeAction;
		if(valueChangeAction != null && valueChangeAction.length() >0  && valueChangeAction.indexOf("//") == -1){
			if ( (valueChangeAction.length()>50)) {
				if ( this.valueChangeActionNode == null ) {
					this.valueChangeActionNode = new MetaBaseScript(MetaConstants.Event_ValueChangeAction);
				}
				this.valueChangeActionNode.setContent(valueChangeAction);
			} else {
				this.valueChangeActionNode = null;
			}
		}else if(valueChangeAction != null && valueChangeAction.length() >0 ){
			if (this.valueChangeActionNode == null) {
				this.valueChangeActionNode = new MetaBaseScript(MetaConstants.Event_ValueChangeAction);
			}
			this.valueChangeActionNode.setContent(valueChangeAction);
		}
	}

	/**
	 * 取得值改变后事件
	 * @return
	 */
	public String getValueChangeAction() {
		if (this.valueChangeActionNode != null) {
			return this.valueChangeActionNode.getContent();
		}
		return this.valueChangeAction;
	}

	/**
	 * 取得值改变后事件节点
	 * @return
	 */
	public MetaBaseScript getValueChangeActionNode() {
		return this.valueChangeActionNode;
	}

	/**
	 * 设置值变化后事件节点
	 * @param valueChangeActionNode
	 */
	public void setValueChangeActionNode(MetaBaseScript valueChangeActionNode) {
		this.valueChangeActionNode = valueChangeActionNode;
	}

	/**
	 * 设置文本变化事件节点
	 * @param textChangedNode 文本变化事件节点
	 */
	public void setTextChangedNode(MetaBaseScript textChangedNode){
		this.textChangedNode = textChangedNode;
	}

	/**
	 * 获取文本变化事件节点
	 * @return 文本变化事件节点
	 */
	public MetaBaseScript getTextChangedNode(){
		return this.textChangedNode;
	}

	/**
	 * 设置默认值
	 * @param defaultValue 默认值
	 */
	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	/**
	 * 取得默认值
	 * @return 默认值
	 */
	public String getDefaultValue() {
		return this.defaultValue;
	}

	/**
	 * 设置表达式表示的默认值
	 * @param defaultFormulaValue 表达式
	 */
	public void setDefaultFormulaValue(String defaultFormulaValue) {
		this.defaultFormulaValue = defaultFormulaValue;
				if(defaultFormulaValue != null && defaultFormulaValue.length() >0 && defaultFormulaValue.indexOf("//")==-1){
					if ( (defaultFormulaValue.length()>50)) {
						if (this.defaultFormulaValueNode == null) {
							this.defaultFormulaValueNode = new MetaBaseScript(MetaConstants.COMMON_DEFAULTFORMULAVALUE);
						}
						this.defaultFormulaValueNode.setContent(defaultFormulaValue);
					} else {
						this.defaultFormulaValueNode = null;
					}
				}else if(defaultFormulaValue != null && defaultFormulaValue.length() >0){
					if (this.defaultFormulaValueNode == null) {
						this.defaultFormulaValueNode = new MetaBaseScript(MetaConstants.COMMON_DEFAULTFORMULAVALUE);
					}
					this.defaultFormulaValueNode.setContent(defaultFormulaValue);
				}

	}

	/**
	 * 取得表达式表示的默认值
	 * @return 表达式
	 */
	public String getDefaultFormulaValue() {
		if (this.defaultFormulaValueNode != null) {
			return this.defaultFormulaValueNode.getContent();
		}
		return this.defaultFormulaValue;
	}

	/**
	 * 取默认值公式节点
	 * @return
	 */
	public MetaBaseScript getDefaultFormulaValueNode() {
		return defaultFormulaValueNode;
	}
	/**
	 * 设置默认值公式节点
	 * @return
	 */
	public void setDefaultFormulaValueNode(MetaBaseScript defaultFormulaValueNode) {
		this.defaultFormulaValueNode = defaultFormulaValueNode;
	}

	/**
	 * 设置值依赖的域集合
	 * @param valueDependency 值依赖域集合
	 */
	public void setValueDependency(String valueDependency) {
		this.valueDependency = valueDependency;
	}

	/**
	 * 取得值依赖域集合
	 * @return 值依赖域集合
	 */
	public String getValueDependency() {
		return this.valueDependency;
	}

	/**
	 * 设置检查规则
	 * @param checkRule 检查规则
	 */
	public void setCheckRule(String checkRule) {
		this.checkRule = checkRule;
		if(checkRule != null && checkRule.length() >0 && checkRule.indexOf("//")==-1){
			if ( (checkRule.length()>50)) {
				if (this.checkRuleNode == null) {
					this.checkRuleNode = new MetaBaseScript(MetaConstants.DATABINDING_CHECKRULE);
				}
				this.checkRuleNode.setContent(checkRule);
			} else {
				this.checkRuleNode = null;
			}
		}else if(checkRule != null && checkRule.length() >0){
			if (this.checkRuleNode == null) {
				this.checkRuleNode = new MetaBaseScript(MetaConstants.DATABINDING_CHECKRULE);
			}
			this.checkRuleNode.setContent(checkRule);
		}
	}


	/**
	 * 取得检查规则
	 * @return 取得检查规则
	 */
	public String getCheckRule() {
		if (this.checkRuleNode != null) {
			return this.checkRuleNode.getContent();
		}
		return this.checkRule;
	}
	/**
	 * 取得检查规则节点
	 * @return 取得检查规则节点
	 */
	public MetaBaseScript getCheckRuleNode() {
		return checkRuleNode;
	}
	/**
	 * 设置检查规则节点
	 * @param checkRuleNode 检查规则节点
	 */
	public void setCheckRuleNode(MetaBaseScript checkRuleNode) {
		this.checkRuleNode = checkRuleNode;
	}

	/**
	 * 设置出错信息
	 * @param errorInfo 出错信息
	 */
	public void setErrorInfo(String errorInfo) {
		this.errorInfo = errorInfo;
	}

	/**
	 * 取得出错信息
	 * @return 取得出错信息
	 */
	public String getErrorInfo() {
		return this.errorInfo;
	}

	/**
	 * 设置检查规则依赖域集合
	 * @param checkDependency 检查规则依赖域集合
	 */
	public void setCheckDependency(String checkDependency) {
		this.checkDependency = checkDependency;
	}

	/**
	 * 取得检查规则依赖域集合
	 * @return 检查规则依赖域集合
	 */
	public String getCheckDependency() {
		return this.checkDependency;
	}

	/**
	 * 设置错误字符串标识
	 * @param errorStringID 字符串标识
	 */
	public void setErrorStringID(String errorStringID) {
		this.errorStringID = errorStringID;
	}

	/**
	 * 取得错误字符串标识
	 * @return 字符串标识
	 */
	public String getErrorStringID() {
		return this.errorStringID;
	}

	/**
	 * 设置必填项图标，仅在原本支持图标的控件上生效
	 * @param requiredIcon 必填项图标
	 */
	public void setRequiredIcon(String requiredIcon) {
		this.requiredIcon = requiredIcon;
	}
	
	/**
	 * 获取必填项图标，仅在原本支持图标的控件上生效
	 * @return 必填项图标
	 */
	public String getRequiredIcon() {
		return requiredIcon;
	}
	
	/**
	 * 设置检查通过图标，仅在原本支持检查图标的控件上生效
	 * @param checkRulePassIcon 检查通过图标
	 */
	public void setCheckRulePassIcon(String checkRulePassIcon) {
		this.checkRulePassIcon = checkRulePassIcon;
	}
	
	/**
	 * 获取检查通过图标，仅在原本支持检查图标的控件上生效
	 * @return 检查通过图标
	 */
	public String getCheckRulePassIcon() {
		return checkRulePassIcon;
	}
	
	/**
	 * 设置检查不通过图标，仅在原本支持检查图标的控件上生效
	 * @param checkRuleErrorIcon 检查不通过图标
	 */
	public void setCheckRuleErrorIcon(String checkRuleErrorIcon) {
		this.checkRuleErrorIcon = checkRuleErrorIcon;
	}
	
	/**
	 * 获取检查不通过图标，仅在原本支持检查图标的控件上生效
	 * @return 检查不通过图标
	 */
	public String getCheckRuleErrorIcon() {
		return checkRuleErrorIcon;
	}
	
	/**
	 * 判断是否有定义的值
	 * @return 如果定义了默认值及默认值表达式，则返回true，否则返回false
	 */
	public boolean hasDefValue() {
		if ( (this.defaultValue != null && !this.defaultValue.isEmpty()) ||
				(this.defaultFormulaValue != null && !this.defaultFormulaValue.isEmpty()) ) {
			return true;
		}
		if (defaultFormulaValueNode != null) {
			String content = defaultFormulaValueNode.getContent();
			return content != null && content.length() > 0;
		}
		return false;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if(this.valueChangedNode != null){
			list.add(this.valueChangedNode);
		}
		if(this.checkRuleNode != null){
			list.add(this.checkRuleNode);
		}
		if(this.defaultFormulaValueNode != null){
			list.add(this.defaultFormulaValueNode);
		}

		if(this.valueChangingNode != null){
			list.add(this.valueChangingNode);
		}

		if(this.textChangedNode != null){
			list.add(this.textChangedNode);
		}
		if (this.valueChangeActionNode != null) {
			list.add(this.valueChangeActionNode);
		}
		list.add(this.valueValidation);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaConstants.Event_ValueChanging.equals(tagName) ) {
			this.valueChangingNode = new MetaBaseScript(MetaConstants.Event_ValueChanging);
			resultMetaObject = this.valueChangingNode;
		} else if ( MetaConstants.Event_ValueChanged.equals(tagName) ) {
			this.valueChangedNode = new MetaBaseScript(MetaConstants.Event_ValueChanged);
			resultMetaObject = this.valueChangedNode;
		} else if ( MetaConstants.DATABINDING_DEFAULTFORMULAVALUE.equals(tagName) ) {
			this.defaultFormulaValueNode = new MetaBaseScript(MetaConstants.DATABINDING_DEFAULTFORMULAVALUE);
			resultMetaObject = this.defaultFormulaValueNode;
		} else if ( MetaConstants.DATABINDING_CHECKRULE.equals(tagName) ) {
			this.checkRuleNode = new MetaBaseScript(MetaConstants.DATABINDING_CHECKRULE);
			resultMetaObject = this.checkRuleNode;
		} else if ( MetaConstants.Event_TextChanged.equals(tagName) ) {
			this.textChangedNode = new MetaBaseScript(MetaConstants.Event_TextChanged);
			resultMetaObject = this.textChangedNode;
		} else if ( MetaConstants.Event_ValueValidation.equals(tagName) ) {
			this.valueValidation = new MetaBaseScript(MetaConstants.Event_ValueValidation);
			resultMetaObject = this.valueValidation;
		} else if( MetaConstants.Event_ValueChangeAction.equalsIgnoreCase(tagName)){
			this.valueChangeActionNode = new MetaBaseScript(MetaConstants.Event_ValueChangeAction);
			resultMetaObject = this.valueChangeActionNode;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDataBinding newObject = new MetaDataBinding();
		newObject.setTableKey(tableKey);
		newObject.setColumnKey(columnKey);
		newObject.setRequired(isRequired);
		newObject.setValueValidation(valueValidation == null ? null : (MetaBaseScript)valueValidation.clone());
		newObject.setValueChanging(valueChanging);
		newObject.setValueChangingNode(valueChangingNode == null ? null : (MetaBaseScript)valueChangingNode.clone());
		newObject.setValueChanged(valueChanged);
		newObject.setValueChangedNode(valueChangedNode == null ? null : (MetaBaseScript)valueChangedNode.clone());
		newObject.setValueChangeAction(valueChangeAction);
		newObject.setValueChangeActionNode(valueChangeActionNode == null ? null : (MetaBaseScript) valueChangeActionNode.clone());
		newObject.setTextChangedNode(textChangedNode == null ? null : (MetaBaseScript)textChangedNode.clone());
		newObject.setDefaultValue(defaultValue);
		newObject.setDefaultFormulaValue(defaultFormulaValue);
		newObject.setDefaultFormulaValueNode(defaultFormulaValueNode == null ? null : (MetaBaseScript) defaultFormulaValueNode.clone());
		newObject.setValueDependency(valueDependency);
		newObject.setCheckRule(checkRule);
		newObject.setCheckRuleNode(checkRuleNode == null ? null : (MetaBaseScript) checkRuleNode.clone());
		newObject.setErrorInfo(errorInfo);
		newObject.setErrorStringID(errorStringID);
		newObject.setCheckDependency(checkDependency);
		newObject.setRequiredIcon(requiredIcon);
		newObject.setCheckRulePassIcon(checkRulePassIcon);
		newObject.setCheckRuleErrorIcon(checkRuleErrorIcon);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDataBinding();
	}

	/**
	 * 有无实际数据源绑定
	 * @return  如果有实际的数据源绑定返回true，否则返回false
	 */
	public boolean hasBinding(){
		return !tableKey.isEmpty() && !columnKey.isEmpty();
	}

	/**
	 * 返回valueChanged属性对象，如果没有则创建一个对象返回
	 * @return valueChanged属性对象
	 */
	public MetaBaseScript ensureValueChangedNode() {
		if (this.valueChangedNode == null) {
			this.valueChangedNode = new MetaBaseScript(MetaConstants.Event_ValueChanged);
		}
		return this.valueChangedNode;
	}
	/**
	 * 返回defaultFormulaValue属性对象，如果没有则创建一个对象返回
	 * @return valueChanged属性对象
	 */
	public MetaBaseScript ensureDefaultFormulaValueNode() {
		if (this.defaultFormulaValueNode == null) {
			this.defaultFormulaValueNode = new MetaBaseScript(MetaConstants.DATABINDING_DEFAULTFORMULAVALUE);
		}
		return this.defaultFormulaValueNode;
	}
	/**
	 * 返回valueChanged属性对象，如果没有则创建一个对象返回
	 * @return valueChanged属性对象
	 */
	public MetaBaseScript ensureCheckRuleNode() {
		if (this.checkRuleNode == null) {
			this.checkRuleNode = new MetaBaseScript(MetaConstants.DATABINDING_CHECKRULE);
		}
		return this.checkRuleNode;
	}

	public MetaBaseScript ensureTextChangedNode() {
		if (this.textChangedNode == null) {
			this.textChangedNode = new MetaBaseScript(MetaConstants.Event_TextChanged);
		}
		return this.textChangedNode;
	}

	/**
	 * 返回valueChanging属性对象，如果没有则创建一个对象返回
	 * @return valueChanging属性对象
	 */
	public MetaBaseScript ensureValueChangingNode() {
		if (this.valueChangingNode == null) {
			this.valueChangingNode = new MetaBaseScript(MetaConstants.Event_ValueChanging);
		}
		return this.valueChangingNode;
	}
	
	public void merge(MetaDataBinding dataBinding,boolean isCheck) {
		if( dataBinding == null )
			return;

		if( this.tableKey == null ) {
			this.tableKey = dataBinding.getTableKey();
		}
		if( this.columnKey == null) {
			this.columnKey = dataBinding.getColumnKey();
		}
		if( this.isRequired == null ) {
			this.isRequired = dataBinding.isRequired();
		} else {
			extendJson.put("required",dataBinding.isRequired());
		}
		if( this.valueValidation == null ) {
			this.valueValidation = dataBinding.getValueValidation();
		}
		if( this.valueChanging == null ) {
			this.valueChanging = dataBinding.getValueChanging();
		}
		if( this.valueChangingNode == null ) {
			this.valueChangingNode = dataBinding.getValueChangingNode();
		}
		if( this.valueChanged == null && this.valueChangedNode == null ) {
			this.valueChanged = dataBinding.getValueChanged();
			this.valueChangedNode = dataBinding.getValueChangedNode();
		}
		if( this.valueChangeAction == null && this.valueChangeActionNode == null ) {
			this.valueChangeAction = dataBinding.getValueChangeAction();
			this.valueChangeActionNode = dataBinding.getValueChangeActionNode();
		}
		if( this.textChangedNode == null ) {
			this.textChangedNode = dataBinding.getValueChangedNode();
		}
		if( this.defaultValue == null ) {
			this.defaultValue = dataBinding.getDefaultValue();
		}
		if( this.defaultFormulaValue == null && this.defaultFormulaValueNode == null) {
			this.defaultFormulaValue = dataBinding.getDefaultFormulaValue();
			this.defaultFormulaValueNode = dataBinding.getDefaultFormulaValueNode();
		}
		if( this.valueDependency == null ) {
			this.valueDependency = dataBinding.getValueDependency();
		}
		if( this.checkRule == null && this.checkRuleNode == null) {
			this.checkRule = dataBinding.getCheckRule();
			this.checkRuleNode = dataBinding.getCheckRuleNode();
		} else {
			extendJson.put("checkRule",dataBinding.getCheckRule());
		}
		if( this.errorInfo == null ) {
			this.errorInfo = dataBinding.getErrorInfo();
		}
		if( this.errorStringID == null ) {
			this.errorStringID = dataBinding.getErrorStringID();
		}
		if( this.checkDependency == null ) {
			this.checkDependency = dataBinding.getCheckDependency();
		}
		if( this.requiredIcon == null){
			this.requiredIcon = dataBinding.getRequiredIcon();
		}
		if( this.checkRulePassIcon == null){
			this.checkRulePassIcon = dataBinding.getCheckRulePassIcon();
		}
		if(this.checkRuleErrorIcon == null){
			this.checkRuleErrorIcon = dataBinding.getCheckRuleErrorIcon();
		}
	}
	
	@Override
	public void merge(MetaDataBinding dataBinding) {
		merge(dataBinding,true);
	}
}
