package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.PopAnim;
import com.bokesoft.yigo.common.def.SelectEditType;
import com.bokesoft.yigo.common.def.SelectStyle;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaListBoxItemCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaQueryDef;

/**
 * 下拉框配置对象
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaComboBox extends MetaComponent {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_COMBOBOX;
	
	/** 属性对象 */
	private MetaComboBoxProperties properties = new MetaComboBoxProperties();

	public MetaComboBox() {
		super();
	}

	/**
	 * 设置是否可编辑
	 *
	 * @param isEditable 是否可编辑
	 */
	public void setEditable(Boolean isEditable) {
		this.properties.setEditable(isEditable);
	}

	/**
	 * 获取是否可编辑
	 * 
	 * @return 是否可编辑
	 */
	public Boolean isEditable() {
		return this.properties.isEditable();
	}
	
	/**
	 * 设置文本为空时的提示信息
	 *
	 * @param promptText 文本为空时的提示信息
	 */
	public void setPromptText(String promptText) {
		properties.setPromptText(promptText);
	}

	/**
	 * 获取文本为空时的提示信息
	 *
	 * @return 文本为空时的提示信息
	 */
	public String getPromptText() {
		return this.properties.getPromptText();
	}
	
	/**
	 * 获取是否取整型值
	 *
	 * @return 是否取整型值，该属性用于确定在GetValue时是否返回整型值，方便进行运算
	 */
	public Boolean isIntegerValue() {
		return this.properties.isIntegerValue();
	}
	
	/**
	 * 设置是否取整型值
	 * @param integerValue 是否取整型值，该属性用于确定在GetValue时是否返回整型值，方便进行运算
	 */
	public void setIntegerValue(Boolean integerValue){
		this.properties.setIntegerValue(integerValue);
	}

	/**
	 * 设置依赖字段定义
	 *
	 * @param dependency 依赖字段定义，用','分隔
	 */
	public void setItemsDependency(String dependency){
		this.properties.setItemsDependency(dependency);
	}
	
	/**
	 * 获取依赖字段定义
	 *
	 * @return 依赖字段定义，用','分隔
	 */
	public String getItemsDependency(){
		return this.properties.getItemsDependency();
	}
	
	/**
	 * 设置下拉项集合表达式，仅{@link #getSourceType()}为{@link ComboBoxSourceType#FORMULA}时有效
	 *
	 * @param formulaItems 下拉项集合表达式
	 */
	public void setFormulaItems(MetaBaseScript formulaItems) {
		this.properties.setFormulaItems(formulaItems);
	}
	
	/**
	 * 获取下拉项集合表达式，仅{@link #getSourceType()}为{@link ComboBoxSourceType#FORMULA}时有效
	 *
	 * @return 下拉项集合表达式
	 */
	public MetaBaseScript getFormulaItems() {
		return this.properties.getFormulaItems();
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.COMBOBOX;
	}

	/**
	 * 获取下拉项的总数，仅{@link #getSourceType()}为{@link ComboBoxSourceType#ITEMS}时有效
	 *
	 * @return 下拉项总数
	 */
	public int getItemCount() {
		return this.properties.getItemCount();
	}

	/**
	 * 获取特定位置的下拉项，仅{@link #getSourceType()}为{@link ComboBoxSourceType#ITEMS}时有效
	 *
	 * @param index 位置的序号
	 * @return 特定位置的下拉项
	 */
	public MetaDefaultItem getItem(int index) {
		return this.properties.getItem(index);
	}

	/**
	 * 设置下拉项集合，仅{@link #getSourceType()}为{@link ComboBoxSourceType#ITEMS}时有效
	 *
	 * @param items 下拉项集合
	 */
	public void setItems(MetaListBoxItemCollection items) {
		this.properties.setItems(items);
	}
	
	/**
	 * 获取下拉项集合，仅{@link #getSourceType()}为{@link ComboBoxSourceType#ITEMS}时有效
	 *
	 * @return 下拉项集合
	 */
	public MetaListBoxItemCollection getItems() {
		return this.properties.getItems();
	}
	
	/**
	 * 获取查询定义，仅{@link #getSourceType()}为{@link ComboBoxSourceType#QUERY}时有效
	 *
	 * @return 查询定义
	 */
	public MetaQueryDef getQueryDef(){
		return this.properties.getQueryDef();
	}
	
	/**
	 * 设置查询定义，仅{@link #getSourceType()}为{@link ComboBoxSourceType#QUERY}时有效
	 *
	 * @param queryDef 查询定义
	 */
	public void setQueryDef(MetaQueryDef queryDef){
		this.properties.setQueryDef(queryDef);
	}

	/**
	 * 获取全局下拉项，仅{@link #getSourceType()}为{@link ComboBoxSourceType#FORMULA}时有效
	 *
	 * @return 全局下拉项
	 */
	public String getGlobalItems() {
		return this.properties.getGlobalItems();
	}
	
	/**
	 * 取得来源类型
	 *
	 * @return 来源类型，取值范围为{@link ComboBoxSourceType}
	 */
	public Integer getSourceType(){
		return this.properties.getSourceType();
	}
	
	/**
	 * 设置来源类型
	 *
	 * @param type 来源类型，取值范围为{@link ComboBoxSourceType}
	 */
	public void setSourceType(Integer type){
		this.properties.setSourceType(type);
	}
	
	/**
	 * 获取显示样式
	 *
	 * @return 显示样式，取值范围为{@link SelectStyle}
	 */
	public Integer getStyle() {
		return properties.getStyle();
	}

	/**
	 * 设置显示样式
	 *
	 * @param style 显示样式，取值范围为{@link SelectStyle}
	 */
	public void setStyle(Integer style) {
		properties.setStyle(style);
	}

	/**
	 * 获取编辑样式，仅{@link #getStyle()}为{@link SelectStyle#POP}时有效
	 *
	 * @return 编辑样式，取值范围为{@link SelectEditType}
	 */
	public Integer getEditType() {
		return properties.getEditType();
	}

	/**
	 * 设置编辑样式，仅{@link #getStyle()}为{@link SelectStyle#POP}时有效
	 *
	 * @param editType 编辑样式，取值范围为{@link SelectEditType}
	 */
	public void setEditType(Integer editType) {
		properties.setEditType(editType);
	}

	/**
	 * 获取平铺标签显示样式下的每行的列数，仅{@link #getStyle()}为{@link SelectStyle#TILED}时有效
	 *
	 * @return 平铺标签显示样式下的每行的列数
	 */
	public Integer getColumnCount() {
		return properties.getColumnCount();
	}

	/**
	 * 设置平铺标签显示样式下的每行的列数，仅{@link #getStyle()}为{@link SelectStyle#TILED}时有效
	 *
	 * @param columnCount 平铺标签显示样式下的每行的列数
	 */
	public void setColumnCount(Integer columnCount) {
		properties.setColumnCount(columnCount);
	}

	/**
	 * 获取参数组标识，仅{@link #getSourceType()}为{@link ComboBoxSourceType#PARAGROUP}时有效
	 *
	 * @return 参数组标识
	 */
	public String getGroupKey() {
		return properties.getGroupKey();
	}

	/**
	 * 设置参数组标识，仅{@link #getSourceType()}为{@link ComboBoxSourceType#PARAGROUP}时有效
	 *
	 * @param groupKey 参数组标识
	 */
	public void setGroupKey(String groupKey) {
		properties.setGroupKey(groupKey);
	}

	/**
	 * 获取弹出动画，仅{@link #getStyle()}为{@link SelectStyle#POP}或
	 * {@link SelectStyle#DROPDOWN}时有效
	 *
	 * @return 弹出动画，取值范围为{@link PopAnim}
	 */
	public String getPopAnim() {
		return properties.getPopAnim();
	}

	/**
	 * 设置弹出动画，仅{@link #getStyle()}为{@link SelectStyle#POP}或
	 * {@link SelectStyle#DROPDOWN}时有效
	 *
	 * @param popAnim 弹出动画，取值范围为{@link PopAnim}
	 */
	public void setPopAnim(String popAnim) {
		properties.setPopAnim(popAnim);
	}

	/**
	 * 取得下拉项显示方式
	 * @return 下拉项显示方式
	 */
	public Integer getTextShowType(){
		return properties.getTextShowType();
	}
	
	/**
	 * 取得下拉项显示方式
	 * @param type 下拉项显示方式
	 */
	public void setTextShowType(Integer type){
		properties.setTextShowType(type);
	}
	
	/**
	 * 获取下拉项显示方式
	 * 
	 * @return
	 */
	public String getTextShowFormat(){
		return properties.getTextShowFormat();
	}
	
	@Override
	public MetaComboBox clone() {
		MetaComboBox newObject = (MetaComboBox) super.clone();
		newObject.setProperties(properties == null ? null : properties.clone());

		return newObject;
	}

	@Override
	public MetaComboBox newInstance() {
		return new MetaComboBox();
	}

	@Override
	public MetaComboBoxProperties getProperties() {
		return properties;
	}
	
	/**
	 * 设置属性对象
	 *
	 * @param properties 属性对象
	 */
	@Override
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaComboBoxProperties) properties;
	}
}

