package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaBPMGraphProperties;

public class MetaBPMGraph extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_BPM_GRAPH;
	
	private MetaBPMGraphProperties properties = new MetaBPMGraphProperties();
	
	public MetaBPMGraph() {
		super();
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.BPM_GRAPH;
	}
	
	@Override
	public boolean receiveFocus() {
		return false;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaBPMGraph();
	}

	public AbstractMetaObject clone() {
		MetaBPMGraph newObject = (MetaBPMGraph) super.clone();
		newObject.setProperties((MetaBPMGraphProperties) properties.clone());

		return newObject;
	}

	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaBPMGraphProperties) properties;
	}

	@Override
	public MetaBPMGraphProperties getProperties() {
		return properties;
	}

}
