package com.bokesoft.yigo.meta.form.component.bar;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractCompositeObject;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericCompositeCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaMenuItemCollection extends GenericCompositeCollection {
	/** 菜单项的标识 */
	private String key = "";
	/** 菜单项的名称 */
	private String caption = "";
	public MetaMenuItemCollection() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "MenuItemCollection";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaMenuItemCollection.TAG_NAME.equals(tagName) ) {
			resultMetaObject = new MetaMenuItemCollection();
		} else if ( MetaMenuItem.TAG_NAME.equals(tagName) ) {
			resultMetaObject = new MetaMenuItem();
		}
		if ( resultMetaObject != null ) {
			this.add((AbstractCompositeObject)resultMetaObject);
		}
		return resultMetaObject;
	}

	@Override
	public int getCompositeType() {
		return MetaMenuItem.MENU_ITEM_COLLECTION;
	}

	/**
	 * 设置菜单项标识
	 * @param key 菜单项标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得菜单项标识
	 * @return 菜单项标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置菜单项名称
	 * @param caption 菜单项名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得菜单项名称
	 * @return 菜单项名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaMenuItemCollection newObject = (MetaMenuItemCollection)super.clone();
		newObject.setKey(key);
		newObject.setCaption(caption);

		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMenuItemCollection();
	}
}
