package com.bokesoft.yigo.meta.form.component.bar;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.base.AbstractCompositeObject;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

/**
 * MetaMenuItem定义菜单项，从{@link AbstractCompositeObject}继承，增加了OnClick事件定义
 * @author 王元和
 *
 */
public class MetaMenuItem extends AbstractCompositeObject {
	/** 菜单项类型 */
	public static final int MENU_ITEM = 0;
	/** 菜单项集合类型 */
	public static final int MENU_ITEM_COLLECTION = 1;
	
	/** 菜单项的标识 */
	private String key = "";
	/** 菜单项的名称 */
	private String caption = "";
	/** 菜单项的点击事件定义 */
	private MetaBaseScript onClick = null;
	
	public MetaMenuItem() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "MenuItem";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaConstants.Event_OnClick.equals(tagName) ) {
			onClick = new MetaBaseScript(MetaConstants.Event_OnClick);
			resultMetaObject = onClick;
		}
		return resultMetaObject;
	}

	@Override
	public int getCompositeType() {
		return MENU_ITEM;
	}

	/**
	 * 设置菜单项标识
	 * @param key 菜单项标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得菜单项标识
	 * @return 菜单项标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置菜单项名称
	 * @param caption 菜单项名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得菜单项名称
	 * @return 菜单项名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	/**
	 * 设置菜单项点击事件
	 * @param onClick 点击事件
	 */
	public void setOnClick(MetaBaseScript onClick) {
		this.onClick = onClick;
	}
	
	/**
	 * 取得菜单项点击事件
	 * @return 点击事件
	 */
	public MetaBaseScript getOnClick() {
		return this.onClick;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaMenuItem newObject = new MetaMenuItem();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setOnClick(onClick == null ? null : (MetaBaseScript)onClick.clone());
	
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMenuItem();
	}
}
