package com.bokesoft.yigo.meta.form.component;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;


import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.HAlignment;
import com.bokesoft.yigo.common.def.OverwriteType;
import com.bokesoft.yigo.common.def.Position;
import com.bokesoft.yigo.common.def.VAlignment;
import com.bokesoft.yigo.meta.annotation.DataElementAttribute;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.common.MetaCondition;
import com.bokesoft.yigo.meta.common.MetaPara;
import com.bokesoft.yigo.meta.form.IPropertiesElement;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.i18n.MetaI18n;

/**
 * 控件对象的基础类，所有的控件对象都是从这个类派生的
 *
 * @author chenzs
 * @since YES1.0
 */
@SuppressWarnings("serial")
public abstract class MetaComponent extends KeyPairMetaObject implements IPropertiesElement, IPropertyMerger<MetaComponent>{

    /** 标识，整个表单中不重复。默认值为空 */
    protected String key = "";

    /** 显示名称的简称，对于多数控件来说，该值并不对用户可见。默认值为空 */
	@DataElementAttribute(refName = MetaConstants.DATAELEMENT_DEFAULTCAPTION, overwriteType=OverwriteType.IF_EMPTY, allowNull=false)
    protected String caption = "";

    /** 显示名称的全称，组件默认使用简称，ToolTip优先使用全称 **/
    protected String captionFull = "";

    /** 英语语言下的显示名称简称 **/
    protected String captionEn = "";

    /** 英文语言下的显示名称全称，组件默认使用简称，ToolTip优先使用全称**/
    protected String captionEnFull = "";
    
	/** 表达式标题,默认值为空 */
	protected String formulaCaption = "";
	
	/** 表达式标题依赖,默认值为空 */
	protected String captionDependency = "";

    /** 伙伴组件的标识 */
    private String buddyKey = "";

    /** 标明该组件是哪个表格的明细组件，为空标识非子明细组件 */
    private String parentGridKey = "";

    /** 子明细内的控件绑定的母表格的单元格标识,对头控件有效 */
    private String bindingCellKey = "";

    /** 可用性，表达式，默认值为null，表示未定义 */
    private String enable = "";

    /** 可见性，表达式，默认值为null，表示未定义 */
    private String visible = "";

    /** 可用性依赖的组件标识 */
    private String enableDependency = "";

    /** 可见性依赖的组件标识 */
    private String visibleDependency = "";

    /** 组件处于父组件中的水平位置 */
    private Integer x = -1;

    /** 组件处于父组件中的垂直位置 */
    private Integer y = -1;

    /** 组件在网格面板中的水平跨度 */
    private Integer xSpan = 1;

    /** 组件在网格面板中的垂直跨度 */
    private Integer ySpan = 1;

    /** 组件本身的宽度 */
    private DefSize width = null;

    /** 组件本身的高度 */
    private DefSize height = null;

    /** 组件的最小高度 */
    private DefSize minHeight = null;

    /** 组件所在的区域代码,-1在继承的情况下取父亲的*/
    private Integer area = -1;

    /** 组件定位类型*/
    private Integer position = Position.Static;
    /** 组件的左部位置 */
    private Integer left = -1;
    /** 组件的顶部位置 */
    private Integer top = -1;
    /** 组件的右部位置 */
    private Integer right = -1;
    /** 组件的底部位置 */
    private Integer bottom = -1;
    /** 浮动类型,-1在继承的情况下取父亲的*/
    private Integer floatType = -1;

    /** 内边距 */
    private String padding = "";
    /** 左内边距的宽度 */
    private String leftPadding = "";
    /** 右内边距的宽度 */
    private String rightPadding = "";
    /** 上内边距的宽度 */
    private String topPadding = "";
    /** 下内边距的宽度 */
    private String bottomPadding = "";

    /** 外边距 */
    private String margin = "";
    /** 左外边距的宽度 */
    private String leftMargin = "";
    /** 右外边距的宽度 */
    private String rightMargin = "";
    /** 上外边距的宽度 */
    private String topMargin = "";
    /** 下外边距的宽度 */
    private String bottomMargin = "";

    /** 水平对齐方式 */
    private Integer hAlign = HAlignment.CENTER;
    /** 垂直对齐方式 */
    private Integer vAlign = VAlignment.TOP;

    /** css类名 */
    private String cssClass = "";

    /** 控件的鼠标放置时的提示信息 */
    private String tip = "";
    /** 控件的鼠标放置时的提示信息, 可动态使用表达式赋值 */
    private String formulaTip = "";

    /** 控件关联的数据字段信息对象，主要包含关联数据字段所在表的标识，以及字段标识 */
    protected MetaDataBinding dataBinding = null;
    /** 格式 */
    protected MetaFormat format = null;

    /** 边框的颜色 */
    private String borderColor = "";
    /** 边框圆角半径 */
    private String borderRadius = "";
    /** 边框宽度 */
    private String borderWidth = "";
    /** 边框样式 */
    private String borderStyle = "";

    /** 组件的查询关联 */
    private MetaCondition condition = null;
    /** 组件的tab顺序 */
    private Integer tabOrder = -1;
    /** 触发事件 */
    private MetaBaseScript activate = null;
    /** android线性布局 权重 */
    private Float weight = 0.0f;

    /** 是否为叙时簿查询字段  */
    private Boolean asQuery = false;

    /** 是否在初始化值以后重新加载不清除,默认是可以清除*/
    private Boolean clearable = true;

    /** 配置多语种*/
    private MetaI18n i18n = null;

    /** 是否可复制新增*/
    private Boolean copynew = true;

    /** 初始可用性*/
    private Boolean initEnable;
    /** 初始可见性*/
    private Boolean initVisible;
    /** 仅显示(移动端使用)*/
    private Boolean onlyShow;
    
    /** 自定义扩展属性集合*/
    private MetaCustomParaCollection cumstomParas = null;

    // 以下属性并非来自配置文件，无需读写
    /** 是否伙伴组件*/
    private Boolean isBuddy = false;
    /** 是否继承*/
    private Boolean extend = false;
    private boolean shiftExtend = false; // extend=true页面不渲染，功能马甲需要将extend设置为false, visible设置为false，才能显示。但是extend=false，功能马甲却无法引入原单控件，使用该字段进行转储extend
    /** 是否访问控制*/
    private Boolean accessControl = false;
    /** 来自于数据源的默认值*/
    private String dsDefaultValue = "";
    /** 组件样式 */
    private String compStyle = "";

    /** 是否是马甲新增的字段 */
    private boolean isNewExtField = false;
    private HashMap extendJson = new HashMap();
    //配置参数ID信息
    private String parameterID = "";
    private Boolean setParameter = false;
    private Boolean getParameter = false;


    /** 默认值仅在界面打开时计算一次 **/
    private Boolean oneTimeCompute;

    public HashMap getExtendJson() {
        return extendJson;
    }

    public MetaComponent() {

    }

    public String getParameterID() {
        return parameterID;
    }

    public void setParameterID(String parameterID) {
        this.parameterID = parameterID;
    }

    public Boolean isSetParameter() {
        return setParameter;
    }

    public void setSetParameter(Boolean setParameter) {
        this.setParameter = setParameter;
    }

    public Boolean isGetParameter() {
        return getParameter;
    }

    public void setGetParameter(Boolean getParameter) {
        this.getParameter = getParameter;
    }

    /**
     * 是否访问控制
     * @return
     */
    public Boolean isAccessControl() {
        return accessControl;
    }

    /**
     * 设置是否访问控制
     * @param accessControl
     */
    @Override
    public void setAccessControl(boolean accessControl) {
        this.accessControl = accessControl;
    }

    /**
     * 获取组件的tab顺序
     * @return tab顺序
     */
    public Integer getTabOrder() {
        return tabOrder;
    }

    /**
     * 设置组件的tab顺序
     * @param tabOrder tab顺序
     */
    public void setTabOrder(Integer tabOrder) {
        this.tabOrder = tabOrder;
    }
    public boolean isNewExtField() {
        return isNewExtField;
    }

    public void setNewExtField(boolean newExtField) {
        isNewExtField = newExtField;
    }

    /**
     * 获取边框圆角半径
     * @return 边框圆角半径
     */
    public String getBorderRadius() {
        return borderRadius;
    }

    /**
     * 设置边框圆角半径
     * @param borderRadius 边框圆角半径
     */
    public void setBorderRadius(String borderRadius) {
        this.borderRadius = borderRadius;
    }

    /**
     * 获取边框颜色
     * @return 边框颜色
     */
    public String getBorderColor() {
        return borderColor;
    }

    /**
     * 设置边框颜色
     * @param borderColor 边框颜色
     */
    public void setBorderColor(String borderColor) {
        this.borderColor = borderColor;
    }

    /**
     * 获取边框宽度
     * @return 边框宽度
     */
    public String getBorderWidth() {
        return borderWidth;
    }

    /**
     * 设置边框宽度
     * @param borderWidth 边框宽度
     */
    public void setBorderWidth(String borderWidth) {
        this.borderWidth = borderWidth;
    }

    /**
     * 获取重新加载是否清除值,默认可以清除
     * @return 是否清除值
     */
    public Boolean isClearable() {
        return this.clearable;
    }

    /**
     * 设置重新加载是否清除值
     * @param clearable 是否清除值
     */
    public void setClearable(Boolean clearable) {
        this.clearable = clearable;
    }

    public String getEnableDependency() {
        return enableDependency;
    }

    public void setEnableDependency(String enableDependency) {
        this.enableDependency = enableDependency;
    }

    public String getVisibleDependency() {
        return visibleDependency;
    }

    public void setVisibleDependency(String visibleDependency) {
        this.visibleDependency = visibleDependency;
    }

    @Override
    public boolean needCheckExtend() {
        return true;
    }

    /**
     * 获取子表单内的头控件绑定的单元格标识
     *
     * @return 绑定的单元格标识
     */
    public String getBindingCellKey() {
        return this.bindingCellKey;
    }

    /**
     * 设置子表单内的头控件绑定的单元格标识
     *
     * @param bindingCellKey 绑定的单元格标识
     */
    public void setBindingCellKey(String bindingCellKey) {
        this.bindingCellKey = bindingCellKey;
    }

    /**
     * 获取该控件所在的子明细所绑定的表格名称
     *
     * @return 控件所在的子明细绑定表格的标识
     */
    public String getParentGridKey() {
        return parentGridKey;
    }

    /**
     * 设置控件所在的子明细绑定的表格标识
     *
     * @param dtlGridKey 表格标识
     */
    public void setParentGridKey(String dtlGridKey) {
        this.parentGridKey = dtlGridKey;
    }

    /**
     * 返回该组件是否是子表单组件
     *
     * @return 组件是否是子表单组件标志
     */
    public Boolean isSubDetail() {
        return parentGridKey != null && !parentGridKey.isEmpty();
    }

    /**
     * 获取来自于数据源的默认值
     * @return 数据源的默认值
     */
    public String getDsDefaultValue() {
        return dsDefaultValue;
    }

    /**
     * 设置来自于数据源的默认值
     * @param dsDefaultValue 数据源的默认值
     */
    public void setDsDefaultValue(String dsDefaultValue) {
        this.dsDefaultValue = dsDefaultValue;
    }

    /**
     * 获取控件类型
     *
     * @return 控件类型
     */
    public abstract int getControlType();

    /**
     * 取得属性对象
     *
     * @return 属性对象，根据具体实现而定
     */
    @Override
    public abstract AbstractMetaObject getProperties();

    /**
     * 设置属性对象
     */
    public void setProperties(AbstractMetaObject properties) {

    }

    @Override
    public int getElementType() {
        return getControlType();
    }

    /**
     * 设置控件对象的标识
     *
     * @param key
     *            标识
     */
    public void setKey(String key) {
        this.key = key;
    }

    /**
     * 获取控件对象的标识
     * @return 控件标识
     */
    public String getKey() {
        return key;
    }

    /**
     * 设置控件对象的说明
     *
     * @param caption
     *            说明
     */
    public void setCaption(String caption) {
        this.caption = caption;
    }

    /**
     * 获取控件对象的说明
     *
     * @return 说明
     */
    public String getCaption() {
        return caption;
    }

    /**
     * 设置中文名称全称
     * @param captionFull 中文名称全称
     */
    public void setCaptionFull(String captionFull) {
        this.captionFull = captionFull;
    }

    /**
     * 获取中文名称全称
     * @return 中文名称全称
     */
    public String getCaptionFull() {
        return captionFull;
    }

    /**
     * 设置控件对象的英文说明
     * @param captionEn 英文说明
     */
    public void setCaptionEn(String captionEn) {
        this.captionEn = captionEn;
    }

    /**
     * 获取控件对象的英文说明
     * @return 英文说明
     */
    public String getCaptionEn() {
        return captionEn;
    }

    /**
     * 设置英文名称全称
     * @param captionEnFull
     */
    public void setCaptionEnFull(String captionEnFull) {
        this.captionEnFull = captionEnFull;
    }

    /**
     * 获取英文名称全称
     * @return 英文名称全称
     */
    public String getCaptionEnFull() {
        return captionEnFull;
    }

    /**
	 * 获取表达式标题
	 * @return
	 */
	public String getFormulaCaption() {
		return formulaCaption;
	}

	/**
	 * 设置表达式标题
	 * @param formulaCaption
	 */
	public void setFormulaCaption(String formulaCaption) {
		this.formulaCaption = formulaCaption;
	}

	/**
	 * 获取表达式标题依赖
	 * @return
	 */
	public String getCaptionDependency() {
		return captionDependency;
	}

	/**
	 * 设置表达式标题依赖
	 * @param captionDependency
	 */
	public void setCaptionDependency(String captionDependency) {
		this.captionDependency = captionDependency;
	}

    /**
     * 设置伙伴组件的标识
     *
     * @param buddyKey
     *            标识
     */
    public void setBuddyKey(String buddyKey) {
        this.buddyKey = buddyKey;
    }

    /**
     * 取得伙伴组件的标识
     *
     * @return 标识
     */
    public String getBuddyKey() {
        return this.buddyKey;
    }

    /**
     * 设置控件对象是否可用
     *
     * @param enable
     *            是否可用
     */
    public void setEnable(String enable) {
        this.enable = enable;
    }

    /**
     * 获取控件对象是否可用
     *
     * @return 是否可用
     */
    public String getEnable() {
        return this.enable;
    }

    /**
     * 设置初始可用性
     * @param initEnable 初始可用性
     */
    public void setInitEnable(Boolean initEnable) {
        this.initEnable = initEnable;
    }

    /**
     * 获取初始可用性
     * @return 初始可用性
     */
    public Boolean getInitEnable() {
        return initEnable;
    }

    /**
     * 设置控件对象是否可见
     *
     * @param visible
     *            是否可见
     */
    public void setVisible(String visible) {
        this.visible = visible;
    }

    /**
     * 获取控件对象是否可见
     *
     * @return 是否可见
     */
    public String getVisible() {
        return this.visible;
    }

    /**
     * 设置初始可见性
     * @param initVisible 初始可见性
     */
    public void setInitVisible(Boolean initVisible) {
        this.initVisible = initVisible;
    }

    /**
     * 获取初始可见性
     * @return 初始可见性
     */
    public Boolean getInitVisible() {
        return initVisible;
    }

    /**
     * 设置控件对象所处父对象的水平位置信息
     *
     * @param x
     *            控件对象所处父对象的水平位置信息
     */
    public void setX(Integer x) {
        this.x = x;
    }

    /**
     * 获取控件对象所处父对象的水平位置信息
     *
     * @return 控件对象所处父对象的水平位置信息
     */
    public Integer getX() {
        return x;
    }

    /**
     * 设置控件对象所处父对象的垂直位置信息
     *
     * @param y
     *            控件对象所处父对象的垂直位置信息
     */
    public void setY(Integer y) {
        this.y = y;
    }

    /**
     * 获取控件对象所处父对象的垂直位置信息
     *
     * @return 控件对象所处父对象的垂直位置信息
     */
    public Integer getY() {
        return y;
    }

    /**
     * 设置组件的水平跨度
     *
     * @param xSpan
     *            水平跨度
     */
    public void setXSpan(Integer xSpan) {
        this.xSpan = xSpan;
    }

    /**
     * 取得组件的水平跨度
     *
     * @return 水平跨度
     */
    public Integer getXSpan() {
        return xSpan;
    }

    /**
     * 设置组件的垂直跨度
     *
     * @param ySpan
     *            垂直跨度
     */
    public void setYSpan(Integer ySpan) {
        this.ySpan = ySpan;
    }

    /**
     * 取得组件的垂直跨度
     *
     * @return 垂直跨度
     */
    public Integer getYSpan() {
        return ySpan;
    }

    /**
     * 设置组件本身的宽度
     *
     * @param width
     *            宽度
     */
    public void setWidth(DefSize width) {
        this.width = width;
    }

    /**
     * 获取组件本身的宽度
     *
     * @return 宽度
     */
    public DefSize getWidth() {
        return this.width;
    }

    /**
     * 设置组件本身的高度
     *
     * @param height
     *            高度
     */
    public void setHeight(DefSize height) {
        this.height = height;
    }

    /**
     * 获取组件本身的高度
     *
     * @return 高度
     */
    public DefSize getHeight() {
        return this.height;
    }

    /**
     * 设置组件的最小高度
     * @param minHeight 最小高度
     */
    public void setMinHeight(DefSize minHeight) {
        this.minHeight = minHeight;
    }

    /**
     * 取得组件的最小高度
     * @return 最小高度
     */
    public DefSize getMinHeight() {
        return this.minHeight;
    }

    /**
     * 设置组件的定位类型
     *
     * @param position
     *            定位类型
     */
    public void setPosition(Integer position) {
        this.position = position;
    }

    /**
     * 取得组件的定位类型
     *
     * @return 定位类型
     */
    public Integer getPosition() {
        return this.position;
    }

    /**
     * 设置组件的左部位置
     *
     * @param left
     *            左部位置
     */
    public void setLeft(Integer left) {
        this.left = left;
    }

    /**
     * 取得组件的左部位置
     *
     * @return 左部位置
     */
    public Integer getLeft() {
        return this.left;
    }

    /**
     * 设置组件的顶部位置
     *
     * @param top
     *            顶部位置
     */
    public void setTop(Integer top) {
        this.top = top;
    }

    /**
     * 取得组件的顶部位置
     *
     * @return 顶部位置
     */
    public Integer getTop() {
        return this.top;
    }

    /**
     * 设置组件的右部位置
     *
     * @param right
     *            右部位置
     */
    public void setRight(Integer right) {
        this.right = right;
    }

    /**
     * 取得组件的右部位置
     *
     * @return 右部位置
     */
    public Integer getRight() {
        return this.right;
    }

    /**
     * 设置组件的底部位置
     *
     * @param bottom
     *            底部位置
     */
    public void setBottom(Integer bottom) {
        this.bottom = bottom;
    }

    /**
     * 取得组件的底部位置
     *
     * @return 底部位置
     */
    public Integer getBottom() {
        return this.bottom;
    }

    /**
     * 设置浮动类型
     *
     * @param floatType
     *            浮动类型
     * @see com.bokesoft.yigo.common.def.DirectionType
     */
    public void setFloatType(Integer floatType) {
        this.floatType = floatType;
    }

    /**
     * 取得浮动类型
     *
     * @return 浮动类型
     * @see com.bokesoft.yigo.common.def.DirectionType
     */
    public Integer getFloatType() {
        return this.floatType;
    }

    /**
     * 是否需要预载入
     */
    public boolean needPreLoad() {
        return true;
    }

    /**
     * 添加子控件
     *
     * @param component
     *            子控件
     */
    public void addComponent(MetaComponent component) {
    }

    /**
     * 获取子控件总数
     *
     * @return 总数
     */
    public int getComponentCount() {
        return 0;
    }

    /**
     * 取得子控件
     *
     * @param index
     *            序号
     * @return 组件
     */
    public MetaComponent getComponent(int index) {
        return null;
    }

    /**
     * 设置区域代码
     *
     * @param area
     *            区域代码，根据具体的容器意义不同
     */
    public void setArea(Integer area) {
        this.area = area;
    }

    /**
     * 取得区域代码
     *
     * @return 区域代码，根据具体的容器意义不同
     */
    public Integer getArea() {
        return this.area;
    }

    /**
     * 设置内边距
     *
     * @param padding
     *            内边距
     */
    public void setPadding(String padding) {
        this.padding = padding;
    }

    /**
     * 取得内边距
     *
     * @return 内边距
     */
    public String getPadding() {
        return this.padding;
    }

    /**
     * 设置上内边距属性，其值可能为：auto，px（如10px），%(如5%)，inherit
     *
     * @param topPadding
     *            上内边距属性
     */
    public void setTopPadding(String topPadding) {
        this.topPadding = topPadding;
    }

    /**
     * 获取上内边距属性，其值可能为：auto，px（如10px），%(如5%)，inherit
     *
     * @return 上内边距属性
     */
    public String getTopPadding() {
        return this.topPadding;
    }

    /**
     * 设置右内边距属性，其值可能为：auto，px（如10px），%(如5%)，inherit
     *
     * @param rightPadding
     *            右内边距属性
     */
    public void setRightPadding(String rightPadding) {
        this.rightPadding = rightPadding;
    }

    /**
     * 获取右内边距属性，其值可能为：auto，px（如10px），%(如5%)，inherit
     *
     * @return 右内边距属性
     */
    public String getRightPadding() {
        return this.rightPadding;
    }

    /**
     * 设置下内边距属性，其值可能为：auto，px（如10px），%(如5%)，inherit
     *
     * @param bottomPadding
     *            下内边距属性
     */
    public void setBottomPadding(String bottomPadding) {
        this.bottomPadding = bottomPadding;
    }

    /**
     * 获取下内边距属性，其值可能为：auto，px（如10px），%(如5%)，inherit
     *
     * @return 下内边距属性
     */
    public String getBottomPadding() {
        return this.bottomPadding;
    }

    /**
     * 设置左内边距属性，其值可能为：auto，px（如10px），%(如5%)，inherit
     *
     * @param leftPadding
     *            左内边距属性
     */
    public void setLeftPadding(String leftPadding) {
        this.leftPadding = leftPadding;
    }

    /**
     * 获取左内边距属性，其值可能为：auto，px（如10px），%(如5%)，inherit
     *
     * @return 左内边距属性
     */
    public String getLeftPadding() {
        return this.leftPadding;
    }

    /**
     * 设置外边距
     *
     * @param margin
     *            外边距
     */
    public void setMargin(String margin) {
        this.margin = margin;
    }

    /**
     * 取得外边距
     *
     * @return 外边距
     */
    public String getMargin() {
        return this.margin;
    }

    /**
     * 设置上外边距属性，其值可能为：auto，px（如10px），%(如5%)，inherit
     *
     * @param topMargin
     *            上外边距属性
     */
    public void setTopMargin(String topMargin) {
        this.topMargin = topMargin;
    }

    /**
     * 获取上外边距属性，其值可能为：auto，px（如10px），%(如5%)，inherit
     *
     * @return 上外边距属性
     */
    public String getTopMargin() {
        return this.topMargin;
    }

    /**
     * 设置右外边距属性，其值可能为：auto，px（如10px），%(如5%)，inherit
     *
     * @param rightMargin
     *            右外边距属性
     */
    public void setRightMargin(String rightMargin) {
        this.rightMargin = rightMargin;
    }

    /**
     * 获取右外边距属性，其值可能为：auto，px（如10px），%(如5%)，inherit
     *
     * @return 右外边距属性
     */
    public String getRightMargin() {
        return this.rightMargin;
    }

    /**
     * 设置下外边距属性，其值可能为：auto，px（如10px），%(如5%)，inherit
     *
     * @param bottomMargin
     *            下外边距属性
     */
    public void setBottomMargin(String bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    /**
     * 获取下外边距属性，其值可能为：auto，px（如10px），%(如5%)，inherit
     *
     * @return 下外边距属性
     */
    public String getBottomMargin() {
        return this.bottomMargin;
    }

    /**
     * 设置左外边距属性，其值可能为：auto，px（如10px），%(如5%)，inherit
     *
     * @param leftMargin
     *            左外边距属性
     */
    public void setLeftMargin(String leftMargin) {
        this.leftMargin = leftMargin;
    }

    /**
     * 获取左外边距属性，其值可能为：auto，px（如10px），%(如5%)，inherit
     *
     * @return 左外边距属性
     */
    public String getLeftMargin() {
        return this.leftMargin;
    }

    /**
     * 设置水平对齐方式
     *
     * @param hAlign
     *            水平对齐方式
     * @see HAlignment
     */
    public void setHAlign(Integer hAlign) {
        this.hAlign = hAlign;
    }

    /**
     * 取得水平对齐方式
     *
     * @return 水平对齐方式
     * @see HAlignment
     */
    public Integer getHAlign() {
        return this.hAlign;
    }

    /**
     * 设置垂直对齐方式
     *
     * @param vAlign
     *            垂直对齐方式
     * @see VAlignment
     */
    public void setVAlign(Integer vAlign) {
        this.vAlign = vAlign;
    }

    /**
     * 取得垂直对齐方式
     *
     * @return 垂直对齐方式
     */
    public Integer getVAlign() {
        return this.vAlign;
    }

    /**
     * 设置css类名
     *
     * @param cssClass
     *            css类名
     */
    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    /**
     * 取得css类名
     *
     * @return css类名
     */
    public String getCssClass() {
        return this.cssClass;
    }

    /**
     * 获取值变化事件
     *
     * @return 值变化事件
     */
    public String getValueChanged() {
        return this.dataBinding == null ? null : this.dataBinding.getValueChanged();
    }

    /**
     * 取得值改变事件节点
     * @return 值改变事件节点
     */
    public MetaBaseScript getValueChangedNode() {
        return this.dataBinding == null ? null : this.dataBinding.getValueChangedNode();
    }
    /**
     * 取得值改变后事件
     *
     * @return 值变化事件
     */
    public String getValueChangeAction() {
        return this.dataBinding == null ? null : this.dataBinding.getValueChangeAction();
    }
    /**
     * 取得值改变后事件节点
     * @return 值改变事件节点
     */
    public MetaBaseScript getValueChangeActionNode() {
        return this.dataBinding == null ? null : this.dataBinding.getValueChangeActionNode();
    }

    /**
     * 取得默认值公式节点
     * @return 默认值公式节点
     */
    public MetaBaseScript getDefaultFormulaValueNode() {
        return this.dataBinding == null ? null : this.dataBinding.getDefaultFormulaValueNode();
    }
    /**
     * 取得检测规则节点
     * @return 检测规则节点
     */
    public MetaBaseScript getCheckRuleNode() {
        return this.dataBinding == null ? null : this.dataBinding.getCheckRuleNode();
    }

    /**
     * 获取值确认事件
     * @return 值确认事件
     */
    public String getValueChanging() {
        return this.dataBinding == null ? null : this.dataBinding.getValueChanging();
    }

    /**
     * 取得值确认事件节点
     * @return 值确认事件节点
     */
    public MetaBaseScript getValueChangingNode() {
        return this.dataBinding == null ? null : this.dataBinding.getValueChangingNode();
    }

    public MetaDataBinding ensureDataBinding() {
        if (this.dataBinding == null) {
            this.dataBinding = new MetaDataBinding();
        }
        return this.dataBinding;
    }

    /**
     * 设置值改变事件
     *
     * @param valueChanged
     *            值改变事件
     */
    public void setValueChanged(String valueChanged) {
        ensureDataBinding().setValueChanged(valueChanged);
    }

    /**
     * 设置值改变事件节点
     * @param valueChangedNode 值改变事件节点
     */
    public void setValueChangedNode(MetaBaseScript valueChangedNode) {
        ensureDataBinding().setValueChangedNode(valueChangedNode);
    }
    /**
     * 设置默认值公式节点
     * @param defaultFormulaValueNode 默认值公式节点
     */
    public void setDefaultFormulaValueNode(MetaBaseScript defaultFormulaValueNode) {
        ensureDataBinding().setDefaultFormulaValueNode(defaultFormulaValueNode);
    }
    /**
     * 设置检查规则节点
     * @param checkRuleNode 检查规则节点
     */
    public void setCheckRuleNode(MetaBaseScript checkRuleNode) {
        ensureDataBinding().setCheckRuleNode(checkRuleNode);
    }

    /**
     * 设置值确认事件
     *
     * @param valueChanging
     * 			     值确认事件
     */
    public void setValueChanging(String valueChanging) {
        ensureDataBinding().setValueChanging(valueChanging);
    }

    /**
     * 设置值确认事件节点
     * @param valueChangingNode 值确认事件节点
     */
    public void setValueChangingNode(MetaBaseScript valueChangingNode) {
        ensureDataBinding().setValueChangingNode(valueChangingNode);
    }

    /**
     * 获取默认值
     *
     * @return 默认值
     */
    public String getDefaultValue() {
        return this.dataBinding == null ? null : this.dataBinding
                .getDefaultValue();
    }

    /**
     * 设置默认值
     *
     * @param defaultValue
     *            默认值
     */
    public void setDefaultValue(String defaultValue) {
        ensureDataBinding().setDefaultValue(defaultValue);
    }

    /**
     * 取得表达式默认值
     *
     * @return 表达式
     */
    public String getDefaultFormulaValue() {
        return this.dataBinding == null ? null : this.dataBinding
                .getDefaultFormulaValue();
    }

    /**
     * 设置表达式默认值
     *
     * @param defaultFormulaValue
     *            表达式
     */
    public void setDefaultFormulaValue(String defaultFormulaValue) {
        ensureDataBinding().setDefaultFormulaValue(defaultFormulaValue);
    }

    /**
     * 获取检查规则
     *
     * @return 检查规则
     */
    public String getCheckRule() {
        return this.dataBinding == null ? null : dataBinding.getCheckRule();
    }

    /**
     * 获取检查规则依赖
     *
     * @return 检查规则依赖
     */
    public String getCheckDependency() {
        return this.dataBinding == null ? null : dataBinding.getCheckDependency();
    }

    /**
     * 设置检查规则
     *
     * @param checkRule
     *            检查规则
     */
    public void setCheckRule(String checkRule) {
        ensureDataBinding().setCheckRule(checkRule);
    }

    /**
     * 设置控件的鼠标放置提示信息
     *
     * @param tip
     *            提示信息
     */
    public void setToolTip(String tip) {
        this.tip = tip;
    }

    /**
     * 获取控件的鼠标放置提示信息
     *
     * @return 提示信息
     */
    public String getToolTip() {
        return this.tip;
    }

    /**
     * 设置控件的鼠标放置提示信息, 可动态使用表达式赋值
     *
     * @param formulaTip
     *            提示信息
     */
    public void setFormulaTip(String formulaTip) {
        this.formulaTip = formulaTip;
    }

    /**
     * 获取控件的鼠标放置提示信息, 可动态使用表达式赋值
     *
     * @return 提示信息
     */
    public String getFormulaTip() {
        return this.formulaTip;
    }

    /**
     * 获取是否为必填项
     *
     * @return 是否为必填项标志
     */
    public Boolean isRequired() {
        return this.dataBinding == null ? null : this.dataBinding.isRequired();
    }

    /**
     * 获取组件绑定的表标识
     *
     * @return 组件绑定的表标识
     */
    public String getTableKey() {
        return this.dataBinding == null ? null : this.dataBinding.getTableKey();
    }

    /**
     * 获取组件绑定的列标识
     *
     * @return 组标绑定的列标识
     */
    public String getColumnKey() {
        return this.dataBinding == null ? null : this.dataBinding.getColumnKey();
    }

    /**
     * 取得值依赖
     * @return 值依赖
     */
    public String getValueDependency() {
        return this.dataBinding == null ? null : this.dataBinding.getValueDependency();
    }

    /**
     * 设置值依赖
     *
     * @param valueDependency 值依赖
     *
     */
    public void setValueDependency(String valueDependency) {
        ensureDataBinding().setValueDependency(valueDependency);
    }

    /**
     * 设置检查规则依赖
     *
     * @param checkDependency 检查规则依赖
     */
    public void setCheckDependency(String checkDependency) {
        ensureDataBinding().setCheckDependency(checkDependency);
    }

    /**
     * 设置是否为必填项
     *
     * @param isRequired
     *            是否为必填项标志
     */
    public void setRequired(Boolean isRequired) {
        ensureDataBinding().setRequired(isRequired);
    }

    /**
     * 设置数据绑定
     *
     * @param metaDataBinding
     *            数据绑定
     */
    public void setMetaDataBinding(MetaDataBinding metaDataBinding) {
        this.dataBinding = metaDataBinding;
    }

    /**
     * 取得数据绑定
     *
     * @return 数据绑定
     */
    public MetaDataBinding getMetaDataBinding() {
        return this.dataBinding;
    }

    /**
     * 设置格式
     *
     * @param format
     *            格式
     */
    public void setFormat(MetaFormat format) {
        this.format = format;
    }

    /**
     * 获取格式,不为空
     * @return 格式定义
     */
    public MetaFormat ensureFormat() {
        if( format == null ) {
            format = new MetaFormat();
        }
        return this.format;
    }

    /**
     * 取得格式
     *
     * @return 格式
     */
    public MetaFormat getFormat() {
        return this.format;
    }

    /**
     * 设置查询条件元数据
     *
     * @param condition
     *            查询条件元数据
     */
    public void setCondition(MetaCondition condition) {
        this.condition = condition;
    }

    /**
     * 取得查询条件元数据
     *
     * @return 查询条件元数据
     */
    public MetaCondition getCondition() {
        return this.condition;
    }

    /**
     * 取得该组件是否为查询字段组件
     *
     * @return 如果组件定义为用于查询则返回true，否则返回false
     */
    public Boolean isCondition() {
        return condition != null;
    }

    /**
     * 取得错误描述
     *
     * @return 错误描述
     */
    public String getErrorInfo() {
        return this.dataBinding == null ? null : this.dataBinding.getErrorInfo();
    }

    /**
     * 设置错误描述
     *
     * @param errorInfo
     *            错误描述
     */
    public void setErrorInfo(String errorInfo) {
        ensureDataBinding().setErrorInfo(errorInfo);
    }

    /**
     * 是否接受焦点,面板等不接受焦点
     * @return 是否处理焦点
     */
    public boolean receiveFocus() {
        return true;
    }

    /**
     * 是否是面板组件
     * @return 如果是面板返回true，否则返回false
     */
    public boolean isPanel() {
        return false;
    }

    /**
     * 设置数据绑定
     * @param dataBinding 数据绑定
     */
    public void setDataBinding(MetaDataBinding dataBinding) {
        this.dataBinding = dataBinding;
    }

    /**
     * 取得数据绑定
     * @return 数据绑定
     */
    public MetaDataBinding getDataBinding() {
        return this.dataBinding;
    }

    /**
     * 获取是否有数据绑定
     * @return 如果有数据绑定返回true，否则返回false
     */
    public boolean hasDataBinding() {
        return dataBinding == null ? false : dataBinding.hasBinding();
    }

    /**
     * 获取是否有默认值或者是默认值表达式
     * @return 如果有默认值定义返回true，否则返回false
     */
    public boolean hasDefaultValue() {
    	String defaultValue = getDefaultValue();
    	String defaultFormulaValue = getDefaultFormulaValue();
    	return (defaultValue != null && !defaultValue.isEmpty()) || (defaultFormulaValue != null && !defaultFormulaValue.isEmpty());
    }

    /**
     * 设置触发事件
     *
     * @param activate
     *            触发事件
     */
    public void setActivate(MetaBaseScript activate) {
        this.activate = activate;
    }

    /**
     * 取得触发事件
     *
     * @return 触发事件
     */
    public MetaBaseScript getActivate() {
        return this.activate;
    }

    /**
     * 取得前景色
     *
     * @return 如果有定义前景色则返回，否则返回null
     */
    public String getForeColor() {
        return this.format == null ? null : this.format.getForeColor();
    }

    /**
     * 取得背景色
     *
     * @return 如果有定义背景色则返回，否则返回null
     */
    public String getBackColor() {
        return this.format == null ? null : this.format.getBackColor();
    }

    /**
     * 取得是否是继承组件
     * @return 是否是继承组件
     */
    public Boolean isExtend() {
        return extend;
    }

    /**
     * 设置是否是继承属性
     * @param extend 是否是继承属性
     */
    public void setExtend(Boolean extend) {
        this.extend = extend;
    }

    public boolean isShiftExtend() {
        return shiftExtend;
    }

    public void setShiftExtend(boolean shiftExtend) {
        this.shiftExtend = shiftExtend;
    }

    /**
     * 获取是否伙伴组件
     * @return
     */
    public Boolean isBuddy() {
        return isBuddy;
    }

    /**
     * 设置是否伙伴组件
     * @param isBuddy
     */
    public void setBuddy(Boolean isBuddy) {
        this.isBuddy = isBuddy;
    }

    /**
     * 获取边框样式
     * @return 边框样式
     */
    public String getBorderStyle() {
        return borderStyle;
    }

    /**
     * 设置边框样式
     * @param borderStyle 边框样式
     */
    public void setBorderStyle(String borderStyle) {
        this.borderStyle = borderStyle;
    }

    /**
     * 设置是否仅显示
     * @param onlyShow 仅显示
     */
    public void setOnlyShow(Boolean onlyShow) {
        this.onlyShow = onlyShow;
    }

    /**
     * 获取是否仅显示
     * @return 是否仅显示
     */
    public Boolean isOnlyShow() {
        return onlyShow;
    }
    /**
     * 设置组件样式
     * @param style 组件样式
     */
    public void setCompStyle(String style) {
        this.compStyle = style;
    }

    /**
     * 获取组件样式
     * @return 组件样式
     */
    public String getCompStyle() {
        return compStyle;
    }
    
    /**
     * 设置自定义扩展属性集合
     * @param cumstomParas 自定义扩展属性集合
     */
    public void setCumstomParas(MetaCustomParaCollection cumstomParas) {
		this.cumstomParas = cumstomParas;
	}
    
    /**
     * 获取自定义扩展属性集合
     * @return 自定义扩展属性集合
     */
    public MetaCustomParaCollection getCumstomParas() {
		return cumstomParas;
	}

    public Boolean getOneTimeCompute() {
        return oneTimeCompute;
    }

    public void setOneTimeCompute(Boolean oneTimeCompute) {
        this.oneTimeCompute = oneTimeCompute;
    }
    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        if ( dataBinding != null ) {
            list.add(dataBinding);
        }
        if ( format != null ) {
            list.add(format);
        }
        if ( condition != null ) {
            list.add(condition);
        }
        if ( activate != null ) {
            list.add(activate);
        }
        if (i18n != null) {
            list.add(i18n);
        }
        if (cumstomParas != null) {
        	list.add(cumstomParas);
        }
        AbstractMetaObject properties = this.getProperties();
        if (properties != null) {
            properties.getChildMetaObjects(list);
        }
    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
        super.doPostProcess(flag, callback);
        if(dataBinding != null){
            dataBinding.doPostProcess(flag, callback);
        }
        if ( format != null ) {
            format.doPostProcess(flag, callback);
        }
        if ( condition != null ) {
            condition.doPostProcess(flag, callback);
        }
        if ( activate != null ) {
            activate.doPostProcess(flag, callback);
        }
        if (i18n != null) {
            i18n.doPostProcess(flag, callback);
        }
        if (cumstomParas != null) {
        	cumstomParas.doPostProcess(flag, callback);
        }
        AbstractMetaObject properties = this.getProperties();
        if (properties != null) {
            properties.doPostProcess(flag, callback);
        }
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
                                                    Object node, String tagName, Object flag, int runType)
            throws MetaException {
        AbstractMetaObject resultMetaObject = null;
        if (resultMetaObject == null) {
            if (tagName.equalsIgnoreCase(MetaDataBinding.TAG_NAME)) {
                dataBinding = new MetaDataBinding();
                resultMetaObject = dataBinding;
            } else if (tagName.equals(MetaFormat.TAG_NAME)) {
                format = new MetaFormat();
                resultMetaObject = format;
            } else if (tagName.equals(MetaCondition.TAG_NAME)) {
                condition = new MetaCondition();
                resultMetaObject = condition;
            } else if (tagName.equals(MetaConstants.Event_Activate)) {
                this.activate = new MetaBaseScript(MetaConstants.Event_Action);
                resultMetaObject = this.activate;
            } else if (tagName.equals(MetaI18n.TAG_NAME)) {
                i18n = new MetaI18n();
                resultMetaObject = this.i18n;
            } else if (tagName.equals(MetaCustomParaCollection.TAG_NAME)) {
            	cumstomParas = new MetaCustomParaCollection();
            	resultMetaObject = this.cumstomParas;
            }
        }
        AbstractMetaObject properties = this.getProperties();
        if (properties != null && resultMetaObject == null) {
            resultMetaObject = properties.createChildMetaObject(env, doc, node,
                    tagName, flag, runType);
        }
        return resultMetaObject;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaComponent newObject = (MetaComponent) newInstance();
        newObject.setKey(key);
        newObject.setCaption(caption);
        newObject.setCaptionFull(captionFull);
        newObject.setCaptionEn(captionEn);
        newObject.setCaptionEnFull(captionEnFull);
		newObject.setFormulaCaption(formulaCaption);
		newObject.setCaptionDependency(captionDependency);
        newObject.setBuddyKey(buddyKey);
        newObject.setBindingCellKey(bindingCellKey);
        newObject.setVisible(visible);
        newObject.setVisibleDependency(visibleDependency);
        newObject.setEnable(enable);
        newObject.setEnableDependency(enableDependency);
        newObject.setX(x);
        newObject.setY(y);
        newObject.setXSpan(xSpan);
        newObject.setYSpan(ySpan);
        newObject.setPosition(position);
        newObject.setLeft(left);
        newObject.setTop(top);
        newObject.setRight(right);
        newObject.setBottom(bottom);
        newObject.setFloatType(floatType);
        newObject.setArea(area);
        newObject.setTabOrder(tabOrder);
        newObject.setWidth(width);
        newObject.setHeight(height);
        newObject.setMinHeight(minHeight);
        newObject.setWeight(weight);
        newObject.setPadding(padding);
        newObject.setLeftPadding(leftPadding);
        newObject.setRightPadding(rightPadding);
        newObject.setTopPadding(topPadding);
        newObject.setBottomPadding(bottomPadding);
        newObject.setMargin(margin);
        newObject.setLeftMargin(leftMargin);
        newObject.setRightMargin(rightMargin);
        newObject.setTopMargin(topMargin);
        newObject.setBottomMargin(bottomMargin);
        newObject.setHAlign(hAlign);
        newObject.setVAlign(vAlign);
        newObject.setCssClass(cssClass);
        newObject.setToolTip(tip);
        newObject.setFormulaTip(formulaTip);
        newObject.setBorderColor(borderColor);
        newObject.setBorderRadius(borderRadius);
        newObject.setBorderWidth(borderWidth);
        newObject.setBorderStyle(borderStyle);
        newObject.setMetaDataBinding(dataBinding == null ? null
                : (MetaDataBinding) dataBinding.clone());
        newObject
                .setFormat(format == null ? null : (MetaFormat) format.clone());
        newObject.setCondition(condition == null ? null
                : (MetaCondition) condition.clone());
        newObject.setParentGridKey(parentGridKey);
        newObject.setActivate(activate == null ? null
                : (MetaBaseScript) activate.clone());
        newObject.setAsQuery(asQuery);
        newObject.setI18n(i18n == null ? null : (MetaI18n)i18n.clone());
        newObject.setCopyNew(copynew);
        newObject.setExtend(extend);
        newObject.setBuddy(isBuddy);
        newObject.setInitEnable(initEnable);
        newObject.setInitVisible(initVisible);
        newObject.setClearable(clearable);
        newObject.setOnlyShow(onlyShow);
        newObject.setCompStyle(compStyle);
        newObject.setOneTimeCompute(oneTimeCompute);
        newObject.setCumstomParas(cumstomParas == null ? null : (MetaCustomParaCollection)cumstomParas.clone());
        return newObject;
    }

    /**
     * 获取权重
     * @return 权重
     */
    public final Float getWeight() {
        return weight;
    }

    /**
     * 设置权重
     * @param weight 权重
     */
    public final void setWeight(Float weight) {
        this.weight = weight;
    }

    /**
     * 设置是否作为序时簿字段
     * @param b 标志
     */
    public void setAsQuery(Boolean b) {
        this.asQuery = b;
    }

    /**
     * 取得是否序时簿字段
     * @return 标志
     */
    public Boolean isAsQuery() {
        return this.asQuery;
    }

    /**
     * 获取配置多语种
     * @return 多语种
     */
    public MetaI18n getI18n() {
        return i18n;
    }

    /**
     * 设置配置多语种
     * @param i18n 多语种
     */
    public void setI18n(MetaI18n i18n) {
        this.i18n = i18n;
    }

    /**
     * 设置是否复制新增
     * @param copynew 标志
     */
    public void setCopyNew(Boolean copynew) {
        this.copynew = copynew;
    }

    /**
     * 取得是否复制新增
     * @return 标志
     */
    public Boolean isCopyNew() {
        return this.copynew;
    }

    @SuppressWarnings("unchecked")
    @Override
    public void merge(MetaComponent meta) {
        if( this.caption == null ) {
            this.caption = meta.getCaption();
        }
        if( this.captionFull == null ) {
            this.captionFull = meta.getCaptionFull();
        }
        if( this.captionEn == null ) {
            this.captionEn = meta.getCaptionEn();
        }
        if( this.captionEnFull == null ) {
            this.captionEnFull = meta.getCaptionEnFull();
        }
		if( this.formulaCaption == null ) {
			this.formulaCaption = meta.getFormulaCaption();
		}
		if( this.captionDependency == null ) {
			this.captionDependency = meta.getCaptionDependency();
		}
        if( this.buddyKey == null ) {
            this.buddyKey = meta.getBuddyKey();
        }
        if( this.enable == null ) {
            this.enable = meta.getEnable();
        } else {
            extendJson.put("enable",meta.getEnable());
        }
        if( this.enableDependency == null ) {
            this.enableDependency = meta.getEnableDependency();
        }
        if( this.visible == null ) {
            this.visible = meta.getVisible();
        } else {
            extendJson.put("visible",meta.getVisible());
        }
        if( this.visibleDependency == null ) {
            this.visibleDependency = meta.getVisibleDependency();
        }
        if( this.parentGridKey == null ) {
            this.parentGridKey = meta.getParentGridKey();
        }
        if( this.bindingCellKey == null ) {
            this.bindingCellKey = meta.getBindingCellKey();
        }
        if( this.tip == null ) {
            this.tip = meta.getToolTip();
        }
        if( this.formulaTip == null ) {
            this.formulaTip = meta.getFormulaTip();
        }
        if( this.activate == null ) {
            this.activate = meta.getActivate();
        }
        if( this.x == null ) {
            this.x = meta.getX();
        }
        if( this.y == null ) {
            this.y = meta.getY();
        }
        if( this.xSpan == null ) {
            this.xSpan = meta.getXSpan();
        }
        if( this.ySpan == null ) {
            this.ySpan = meta.getYSpan();
        }
        if( this.width == null ) {
            this.width = meta.getWidth();
        }
        if( this.height == null ) {
            this.height = meta.getHeight();
        }
        if( this.minHeight == null ) {
            this.minHeight = meta.getMinHeight();
        }
        if( this.hAlign == -1 ) {
            this.hAlign = meta.getHAlign();
        }
        if( this.vAlign == -1 ) {
            this.vAlign = meta.getVAlign();
        }
        if( this.area == -1 ) {
            this.area = meta.getArea();
        }
        if( this.position == -1 ) {
            this.position = meta.getPosition();
        }
        if( this.top == null ) {
            this.top = meta.getTop();
        }
        if( this.right == null ) {
            this.right = meta.getRight();
        }
        if( this.bottom == null ) {
            this.bottom = meta.getBottom();
        }
        if( this.left == null ) {
            this.left = meta.getLeft();
        }
        if( this.floatType == -1 ) {
            this.floatType = meta.getFloatType();
        }
        if( this.padding == null ) {
            this.padding = meta.getPadding();
        }
        if( this.topPadding == null ) {
            this.topPadding = meta.getTopPadding();
        }
        if( this.rightPadding == null ) {
            this.rightPadding = meta.getRightPadding();
        }
        if( this.bottomPadding == null ) {
            this.bottomPadding = meta.getBottomPadding();
        }
        if( this.leftPadding == null ) {
            this.leftPadding = meta.getLeftPadding();
        }
        if( this.margin == null ) {
            this.margin = meta.getMargin();
        }
        if( this.topMargin == null ) {
            this.topMargin = meta.getTopMargin();
        }
        if( this.rightMargin == null ) {
            this.rightMargin = meta.getRightMargin();
        }
        if( this.bottomMargin == null ) {
            this.bottomMargin = meta.getBottomMargin();
        }
        if( this.leftMargin == null ) {
            this.leftMargin = meta.getLeftMargin();
        }
        if( this.tabOrder == null ) {
            this.tabOrder = meta.getTabOrder();
        }
        if( this.clearable == null ) {
            this.clearable = meta.isClearable();
        }
        if(initEnable == null){
            initEnable = meta.getInitEnable();
        }
        if(initVisible == null){
            initVisible = meta.getInitVisible();
        }
        if( copynew == null ) {
            copynew = meta.isCopyNew();
        }
        if(format == null){
            format = meta.getFormat();
        }
        if(condition == null){
            this.condition= meta.getCondition();
        }

        if(borderColor == null){
            borderColor = meta.getBorderColor();
        }
        if(borderRadius == null){
            borderRadius = meta.getBorderRadius();
        }
        if(borderWidth == null){
            borderWidth = meta.getBorderWidth();
        }
        if(borderStyle == null){
            borderStyle = meta.getBorderStyle();
        }
        if(onlyShow == null){
            onlyShow = meta.isOnlyShow();
        }
        if(compStyle == null) {
            compStyle = meta.getCompStyle();
        }
        if (this.weight == null){
            weight = meta.getWeight();
        }
        if (this.getParameter == null){
            getParameter = meta.isGetParameter();
        }
        if (this.setParameter == null){
            setParameter = meta.isSetParameter();
        }
        if (this.cssClass == null){
            cssClass = meta.getCssClass();
        }
        if (this.asQuery == null){
            this.asQuery = meta.isAsQuery();
        }
        if (this.clearable == null){
            clearable = meta.isClearable();
        }
        if (this.copynew == null){
            copynew = meta.isCopyNew();
        }
        if(oneTimeCompute == null) {
            oneTimeCompute = meta.getOneTimeCompute();
        }
        MetaDataBinding extBinding = meta.getDataBinding();
        if( this.dataBinding == null ) {
            if( extBinding != null ) {
                this.dataBinding = (MetaDataBinding)extBinding.clone();
            }
        } else {
            if( extBinding != null ) {
                this.dataBinding.merge(extBinding);
            } else {
                this.dataBinding.merge(new MetaDataBinding());
            }
        }
        
        MetaCustomParaCollection customParaCollection = meta.getCumstomParas();
        if(customParaCollection != null && customParaCollection.size() > 0) {
        	if(this.cumstomParas == null) {
        		this.cumstomParas = new MetaCustomParaCollection();
        	}
        	Iterator<MetaPara> itPara = customParaCollection.iterator();
			while (itPara.hasNext()) {
				this.cumstomParas.add(itPara.next());
			}
        }

        AbstractMetaObject metaProperties = meta.getProperties();
        AbstractMetaObject properties = this.getProperties();
        if( properties != null && metaProperties != null ) {
            ((IPropertyMerger<AbstractMetaObject>)properties).merge(metaProperties);
        }
    }
}