package com.bokesoft.yigo.meta.form;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

/**
 * MetaTimerTask为定时器定义，包括以下属性：
 * <ul>
 * <li>Delay任务延迟时间
 * <li>Repeat是否重复执行
 * <li>Period重复时间间隔
 * <li>startOnload是否立即启动
 * </ul>
 * @author wangyh
 *
 */
public class MetaTimerTask extends MetaBaseScript {
	/** 定时任务标识 */
	private String key = "";
	/** 任务延迟时间 */
	private Integer delay = 0;
	/** 重复标志 */
	private Boolean repeat = false;
	/** 重复时间间隔  默认1分钟*/
	private Integer period = 60000;
	/** 是否立即启动 */
	private Boolean startOnload = true;
	/** 是否需要抛出异常 */
	private Boolean throwException = true;
	
	public MetaTimerTask() {
		super(TAG_NAME);
	}
	
	/**
	 * 设置定时任务标识
	 * @param key 定时任务标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得定时任务标识
	 * @return 定时任务标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置任务延迟时间
	 * @param delay 延迟时间
	 */
	public void setDelay(Integer delay) {
		this.delay = delay;
	}
	
	/**
	 * 取得任务延迟时间
	 * @return 延迟时间
	 */
	public Integer getDelay() {
		return this.delay;
	}

	/**
	 * 是否立刻启动
	 * @return 标志
	 */
	public Boolean startOnload() {
		return startOnload;
	}

	/**
	 * 设置是否立即启动
	 * @param startOnload 标志
	 */
	public void setStartOnload(Boolean startOnload) {
		this.startOnload = startOnload;
	}

	/**
	 * 设置重复标志
	 * @param repeat 重复标志
	 */
	public void setRepeat(Boolean repeat) {
		this.repeat = repeat;
	}
	
	/**
	 * 取得重复标志
	 * @return 重复标志
	 */
	public Boolean isRepeat() {
		return this.repeat;
	}
	
	/**
	 * 设置重复间隔
	 * @param period 重复间隔
	 */
	public void setPeriod(Integer period) {
		this.period = period;
	}
	
	/**
	 * 取得重复间隔
	 * @return 重复间隔
	 */
	public Integer getPeriod() {
		return this.period;
	}
	
	/**
	 * 设置是否需要抛出异常
	 * @param throwException 是否需要抛出异常
	 */
	public void setThrowException(Boolean throwException) {
		this.throwException = throwException;
	}
	
	/**
	 * 获取是否需要抛出异常
	 * @return 是否需要抛出异常
	 */
	public Boolean isThrowException() {
		return throwException;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	public static final String TAG_NAME = "TimerTask";

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTimerTask newObject = (MetaTimerTask)super.clone();
		newObject.setKey(key);
		newObject.setDelay(delay);
		newObject.setRepeat(repeat);
		newObject.setPeriod(period);
		newObject.setStartOnload(startOnload);
		newObject.setThrowException(throwException);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTimerTask();
	}

}
