package com.bokesoft.yigo.meta.form;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaFormList类定义工程中所有表单对象的基本信息的集合，该类没有相应的XML描述文件与之对应，在加载工程之后通过扫描程序生成。其包含MetaFormProfile对象的集合。
 * @author 王元和
 * @see MetaFormProfile
 */
public class MetaFormList extends GenericKeyCollection<MetaFormProfile> implements IElementMerge<MetaFormList>{

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "FormList";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject child = null;
		if ( MetaFormProfile.TAG_NAME.equals(tagName) ) {
			MetaFormProfile metaFormProfile = new MetaFormProfile();
			metaFormProfile.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(metaFormProfile);
			child = metaFormProfile;
		}
		return child;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public MetaFormList toMerge(MetaFormList obj) {
		if (obj != null) {
			Iterator<MetaFormProfile> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaFormProfile metaFormProfile = (MetaFormProfile) iterator.next();
				if (containsKey(metaFormProfile.getKey())) {
					throw new MetaException(MetaException.REPEAT_FORM_DEFINED,
							SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.RepeatFormDefined),
									metaFormProfile.getProject().getKey(), metaFormProfile.getKey()));
				}
				add(metaFormProfile);
			}
		}
		return this;
	}

}
