package com.bokesoft.yigo.meta.flatcanvas.node;

import java.util.List;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import com.bokesoft.yigo.meta.flatcanvas.convertor.IContentHandler;
import com.bokesoft.yigo.meta.flatcanvas.convertor.INode;

/**
 * 平面图中区域的文本集合
 * 
 * @author chenbinbin
 *
 */
public class MetaFCTextCollection extends MetaFCCollection<MetaFCText> {
	
	public static final String TAG_NAME = "TextCollection";
	
	@Override
	protected void loadChild(Element elem) {
		NodeList nodeList = elem.getChildNodes();
		for (int i=0; i < nodeList.getLength(); i++) {
			if (nodeList.item(i).getNodeType() == 1) {
				Element child = (Element)nodeList.item(i);
				MetaFCText textModel = new MetaFCText();
				textModel.loadFromElement(child);
				this.addItem(textModel);
			}
		}
	}

	@Override
	public List<String> getPropItemKeys() {
		return null;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	protected boolean isCollection() {
		return true;
	}

	@Override
	protected boolean saveChild(IContentHandler saveHandler, INode node) {
		boolean result = false;
		for(MetaFCText text: this.values()) {
			result |= text.saveTo(saveHandler, node);
		}
		return result;
	}

}
