package com.bokesoft.yigo.meta.flatcanvas.node;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observer;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.flatcanvas.common.AttributeItem;
import com.bokesoft.yigo.meta.flatcanvas.common.Attributes;
import com.bokesoft.yigo.meta.flatcanvas.convertor.IContentHandler;
import com.bokesoft.yigo.meta.flatcanvas.convertor.INode;
import com.bokesoft.yigo.meta.flatcanvas.struct.FCAttrNames;

/**
 * 平面图中的抽象元素类型
 * 
 * @author chenbinbin
 *
 */
public abstract class AbstractMetaFCObject extends KeyPairMetaObject {
	
	protected Attributes attrs = new Attributes();

	public AbstractMetaFCObject() {
		//initAttrs(attrs);
	}

	/**
	 * 获取节点的Key属性
	 */
	public String getKey() {
		return TypeConvertor.toString(attrs.get(FCAttrNames.ATTR_key));
	}
	
	/**
	 * 设置节点的Key属性
	 * @param key 标识
	 */
	public void setKey(String key) {
		attrs.set(FCAttrNames.ATTR_key, key);
	}
	
	/**
	 * 获取节点的Caption属性
	 * 
	 * @return 名称
	 */
	public String getCaption() {
		return TypeConvertor.toString(attrs.get(FCAttrNames.ATTR_caption));
	}
	
	/**
	 * 设置节点的Caption属性
	 * 
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		attrs.set(FCAttrNames.ATTR_caption, caption);
	}

	/**
	 * 设置节点的某个属性
	 * 
	 * @param key 标识
	 * @param v 值
	 */
	public void set(String key, Object v) {
		attrs.set(key, TypeConvertor.toString(v));
	}

	/**
	 * 获取节点的某个属性
	 * 
	 * @param key 标识
	 * @return 名称
	 */
	public String get(String key) {
		return TypeConvertor.toString(attrs.get(key));
	}
	
	/**
	 * 判断某个属性是否存在
	 * 
	 * @param key 属性标识
	 * @return 某个属性是否存在
	 */
	public boolean containAttrName(String key) {
		return attrs.containsKey(key);
	}
	
	/**
	 * 获取属性项
	 * 
	 * @param attrName 属性名
	 * @return 属性项
	 */
	public AttributeItem getAttrItem(String attrName) {
		return attrs.getAttrItem(attrName);
	}
	
	/**
	 * 载入子节点
	 * 
	 * @param elem xml文档节点
	 */
	protected abstract void loadChild(Element elem);
	
	/**
	 * 获取节点所拥有的属性集合
	 * 
	 * @return 属性集合
	 */
	public abstract List<String> getPropItemKeys();
	
	/**
	 * 获取节点标签
	 * @return 节点标签
	 */
	public abstract String getTagName();
	
	/**
	 * 是否为集合类型的节点
	 * 
	 * @return 是否集合属性
	 */
	protected abstract boolean isCollection();
	
	/**
	 * 转储当前的节点, 转化节点的表示方式, 比如转化成json或文本等方式
	 * 
	 * @param saveHandler 配置对象转储接口
	 * @param node 节点
	 * @return 是否保存的标志
	 */
	protected abstract boolean saveChild(IContentHandler saveHandler, INode node);
	
	/**
	 * 保存当前配置对象
	 * @param saveHandler 配置对象转储接口
	 * @param parentNode 父节点
	 * @return 是否保存的标志
	 */
	public boolean saveTo(IContentHandler saveHandler, INode parentNode) {
		String tagName = getTagName();
		INode node = saveHandler.createNode(tagName, isCollection());
		boolean result = saveAttrs(node);
		result |= saveChild(saveHandler, node);
		if (result) parentNode.appendChild(node);
		return result;
	}
	
	/**
	 * 保存属性
	 * @param node 节点
	 * @return 是否保存的标志
	 */
	protected boolean saveAttrs(INode node) {
		if (attrs == null) return false;
		
		int count = 0;
		for (Map.Entry<String, AttributeItem> entry: attrs.entrySet()) {
			AttributeItem item = entry.getValue();
			if (!StringUtil.isBlankOrNull(item.getValue())) {
				node.setAttribute(entry.getKey(), item == null ? "" : TypeConvertor.toString(item.getValue()));
				count ++;
			}
		}
		return count > 0;
	}
	
	/**
	 * 加载整个文档
	 * 
	 * @param document xml文档对象
	 */
	public void loadFromDocument(Document document) {
		loadFromElement(document.getDocumentElement());
	}
	
	/**
	 * 
	 * 加载节点
	 * 
	 * @param elem xml节点对象
	 */
	public void loadFromElement(Element elem) {
		if (elem == null) return;
		loadAttrsFromElement(elem);
		loadChild(elem);
	}
	
	/**
	 * 
	 * 加载节点属性
	 * 
	 * @param elem xml节点对象
	 */
	protected void loadAttrsFromElement(Element elem) {
		if (elem == null) {
			return;
		}
		NamedNodeMap map = elem.getAttributes();
		for (int i=0; i< map.getLength(); i++) {
			String key = map.item(i).getNodeName();
			String v = elem.getAttribute(key);
			this.set(key, v);
		}
	}
	
	/**
	 * 添加属性变化监听
	 * 
	 * @param observer 变化监听
	 */
	public void addAttrObserver(Observer observer) {
		attrs.addObserver(observer);
	}
	
	/**
	 * 移除属性变化监听 
	 * 
	 * @param observer 变化监听
	 */
	public void removeAttrObserver(Observer observer) {
		attrs.deleteObserver(observer);
	}
	
	/**
	 * 取得所有属性项集合
	 * @return 属性项集合
	 */
	public List<AttributeItem> getPropItems() {
		List<AttributeItem> items = new ArrayList<AttributeItem>();
		List<String> keys = getPropItemKeys();
		if (keys == null) {
			return items;
		}
		for	(String key: keys) {
			AttributeItem item = attrs.getAttrItem(key);
			if (item == null) {
				set(key, "");
			}
			items.add(attrs.getAttrItem(key));
		}
		return items;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return null;
	}

}
