package com.bokesoft.yigo.meta.flatcanvas.convertor;

/**
 * 转储对象节点接口
 * 
 * @author chenbinbin
 *
 */
public interface INode {
	
	/**
	 * 设置节点属性
	 * 
	 * @param key 标识
	 * @param value 值
	 */
	public void setAttribute(String key, Object value);
	
	/**
	 * 添加子节点
	 * 
	 * @param node 节点
	 */
	public void appendChild(INode node);
	
	/**
	 * 获取用于当前节点转储的对象
	 * 
	 * @return 数据
	 */
	public Object getData();
	
	/**
	 * 获取当前节点tagName
	 * 
	 * @return 节点标识
	 */
	public String getTagName();
	

}
