package com.bokesoft.yigo.meta.exceltemplate;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaExcelSheet extends AbstractMetaObject {
	public static final String TAG_NAME = "Sheet";

	/** ExcelSheet的名称 */
	private String name = "";

	/** ExcelSheet中的行集合*/
	private MetaExcelRows rows = null;
	
	private MetaExcelColumns columns = null;

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		this.addAll2(list, this.rows, this.columns);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		if (tagName.equalsIgnoreCase(MetaExcelRows.TAG_NAME)) {
			rows = new MetaExcelRows();
			return rows;
		} else if (tagName.equalsIgnoreCase(MetaExcelColumns.TAG_NAME)) {
			columns = new MetaExcelColumns();
			return columns;
		} else {
			throw new MetaException(MetaException.NO_ACTION_DEFINED,
					"No action defined for " + tagName);
		}
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExcelSheet();
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public MetaExcelRows getRows() {
		return rows;
	}

	public void setRows(MetaExcelRows rows) {
		this.rows = rows;
	}
	
	public void setColumns(MetaExcelColumns columns) {
		this.columns = columns;
	}
	
	public MetaExcelColumns getColumns() {
		return this.columns;
	}
	
	/**
	 * 获取sheet中涉及到所有tableKey
	 * 
	 * @return
	 */
	public List<String> getTableKeyList() {
		String tableKey = null;
		List<String> tableKeys = new ArrayList<>();
		for(MetaExcelRow row : this.getRows()) {
			tableKey = row.getTableKey();
			if (!StringUtil.isBlankOrNull(tableKey) && !tableKeys.contains(tableKey)) {
				tableKeys.add(tableKey);
				continue;
			}
			for (MetaExcelCell cell : row.getList()) {
				tableKey = cell.getTableKey();
				if (!StringUtil.isBlankOrNull(tableKey) && !tableKeys.contains(tableKey)) {
					tableKeys.add(tableKey);
				}
			}
		}
		return tableKeys;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaExcelSheet newExcelSheet = new MetaExcelSheet();
		newExcelSheet.setName(name);
		newExcelSheet.setRows(rows == null ? null : (MetaExcelRows) rows.clone());
		newExcelSheet.setColumns(columns == null ? null : (MetaExcelColumns) columns.clone());
		return newExcelSheet;
	}
	
	public void clear() {
		if ( this.rows != null ) {
			this.rows.clear();
		}
		if (this.columns != null) {
			this.columns.clear();
		}
	}
}
