package com.bokesoft.yigo.meta.exceltemplate;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaExcelRowExpand extends MetaBaseScript{
	public static final String TAG_NAME = "RowExpand";
	/** 数据类型 */
	private Integer dataType = -1;
	/** 处理标志 */
	private String tag = "";
	/** 字典标识 */
	private String itemKey = "";
	
	public MetaExcelRowExpand() {
		super(TAG_NAME);
	}
	
	/**
	 * 设置数据类型
	 * @param dataType 数据类型
	 */
	public void setDataType(Integer dataType) {
		this.dataType = dataType;
	}
	
	/**
	 * 取得数据类型
	 * @return 数据类型
	 */
	public Integer getDataType() {
		return this.dataType;
	}
	
	/**
	 * 设置处理标志
	 * @param tag 处理标志
	 */
	public void setTag(String tag) {
		this.tag = tag;
	}
	
	/**
	 * 取得处理标志
	 * @return 处理标志
	 */
	public String getTag() {
		return this.tag;
	}
	
	/**
	 * 设置字典标识
	 * @param itemKey 字典标识
	 */
	public void setItemKey(String itemKey) {
		this.itemKey = itemKey;
	}
	
	/**
	 * 取得字典标识
	 * @return 字典标识
	 */
	public String getItemKey() {
		return this.itemKey;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaExcelRowExpand newRowExpand = (MetaExcelRowExpand)super.clone();
		newRowExpand.setDataType(dataType);
		newRowExpand.setTag(tag);
		newRowExpand.setItemKey(itemKey);
		return newRowExpand;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExcelRowExpand();
	}
}
