package com.bokesoft.yigo.meta.exceltemplate;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaExcelColumn extends AbstractMetaObject {
	public static final String TAG_NAME = "Column";
	/** 列号 */
	private Integer columnIndex = -1;
	/** 列宽 */
	private Integer width = 80;

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		return null;
	}

	public Integer getColumnIndex() {
		return this.columnIndex;
	}

	public void setColumnIndex(Integer columnIndex) {
		this.columnIndex = columnIndex;
	}
	
	public Integer getWidth() {
		return this.width;
	}

	public void setWidth(Integer width) {
		this.width = width;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaExcelColumn newCell = new MetaExcelColumn();
		newCell.setColumnIndex(columnIndex);
		newCell.setWidth(width);
		return newCell;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExcelCell();
	}
}
