package com.bokesoft.yigo.meta.diff.save;

import org.w3c.dom.Document;

import com.bokesoft.yes.meta.persist.dom.AbstractSave;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaAction;
import com.bokesoft.yigo.meta.diff.impl.IDiffMetaEnv;

public class MetaDiffSaveAdapter implements IDiffMetaEnv {
	
	private AbstractSave save = null;
	
	private Document document = null;
	
	public MetaDiffSaveAdapter(AbstractSave save) {
		this.save = save;
	}
	
	@Override
	public Document saveAsDocument(AbstractMetaObject meta) throws Exception {
		document = DomHelper.createDocument();
		save.saveToDocument(document, meta);
		return document;
	}

	@Override
	public Object prepare(AbstractMetaObject meta, Object node) {
		return save.prepare(meta, node);
	}

	@Override
	public IMetaAction<AbstractMetaObject> getAction(AbstractMetaObject meta,
			Object node) {
		return save.getAction(meta, node);
	}

	@Override
	public boolean checkExtend(AbstractMetaObject meta, Object node) {
		return save.checkExtend(meta, node);
	}

	@Override
	public Document getDocument() {
		return document;
	}

}
