package com.bokesoft.yigo.meta.dataobject;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaRuleFilter定义根据规则使用的过滤条件，用于在数据源的表中动态确定过滤条件。
 * @author wangyh
 *
 */
public class MetaRuleFilter extends AbstractMetaObject {
	/** 使用规则 */
	private String rule = "";
	/** 过滤 */
	private MetaTableFilter filter = null;
	/** 参数集 */
	private MetaParameterCollection parameterCollection = null;
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { filter, parameterCollection });
	}

	public static final String TAG_NAME = "RuleFilter";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaTableFilter.TAG_NAME.equals(tagName) ) {
			this.filter = new MetaTableFilter();
			resultMetaObject = this.filter;
		} else if ( MetaParameterCollection.TAG_NAME.equals(tagName) ) {
			this.parameterCollection = new MetaParameterCollection();
			resultMetaObject = this.parameterCollection;
		}
		return resultMetaObject;
	}
	
	/**
	 * 设置规则
	 * @param rule 规则
	 */
	public void setRule(String rule) {
		this.rule = rule;
	}
	
	/**
	 * 取得规则
	 * @return 规则
	 */
	public String getRule() {
		return this.rule;
	}
	
	/**
	 * 设置过滤
	 * @param filter 过滤
	 */
	public void setFilter(MetaTableFilter filter) {
		this.filter = filter;
	}
	
	/**
	 * 取得过滤
	 * @return 过滤
	 */
	public MetaTableFilter getFilter() {
		return this.filter;
	}
	
	/**
	 * 设置参数集
	 * @param parameterCollection 参数集
	 */
	public void setParameterCollection(MetaParameterCollection parameterCollection) {
		this.parameterCollection = parameterCollection;
	}
	
	/**
	 * 取得参数集
	 * @return 参数集
	 */
	public MetaParameterCollection getParameterCollection() {
		return this.parameterCollection;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaRuleFilter newObject = (MetaRuleFilter)newInstance();
		newObject.setRule(rule);
		newObject.setFilter(filter != null ? (MetaTableFilter)filter.clone() : null);
		newObject.setParameterCollection(parameterCollection != null ? (MetaParameterCollection)parameterCollection.clone() : null);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaRuleFilter();
	}

}
