package com.bokesoft.yigo.meta.dataobject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.stream.Collectors;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.common.util.LockUtil;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.datamigration.calculate.MigrationDatabjectParas;
import com.bokesoft.yes.meta.datamigration.calculate.MigrationExtensionUtil;
import com.bokesoft.yes.meta.dataobject.SchemaCreator;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.BalanceGroupField;
import com.bokesoft.yigo.common.def.DataGroupGranularity;
import com.bokesoft.yigo.common.def.DataObjectLoadRightsType;
import com.bokesoft.yigo.common.def.DataObjectPrimaryType;
import com.bokesoft.yigo.common.def.DataObjectSecondaryType;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.DictCacheCheckMode;
import com.bokesoft.yigo.common.def.MigrationAttributeDef;
import com.bokesoft.yigo.common.def.MigrationUpdateStrategyType;
import com.bokesoft.yigo.common.def.RollDataStrategyType;
import com.bokesoft.yigo.common.def.SortType;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.def.SystemPrefix;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaExtendCollection;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.common.MetaMigrationExtension;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;

/**
 * 数据对象配置对象
 *
 * @author lishu
 * @since YES1.0
 */
public class MetaDataObject extends AbstractMetaObject implements IPropertyMerger<MetaDataObject> {

    /** 数据对象的标签名称 */
    public static final String TAG_NAME = "DataObject";

    // 简单属性
    /** 数据对象的标志，整个Solution范围内唯一。如果为空，则在默认机制中不支持持久化 */
    private String key = "";
    /** 数据对象的名称 */
    private String caption = "";
    /** 数据对象的类型，取值为Entity和Virtual,MutiTable。如果取值为Virtual，在默认的持久化机制中不能持久化。 */
    private Integer primaryType = DataObjectPrimaryType.VIRTUAL;
    /**
     * 数据对象的辅助类型；PrimayType取值为Entity时，取值范围为见
     * {@link com.bokesoft.yigo.common.def.DataObjectSecondaryType}
     */
    private Integer secondaryType = DataObjectSecondaryType.NORMAL;
    /** 主表的KEY */
    private String mainTableKey = "";
    /** 单据编号前缀 */
    private String noPrefix = "";
    /** 定制的单据编号前缀 */
    private String customNoPrefix = "";
    /** 编号的0值补位前缀 */
    private Integer zeroPrefix = 6;
    /** 迁移表更新数据时使用的策略 */
    private Integer migrationUpdateStrategy = MigrationUpdateStrategyType.INSERT_FAST;
    /** 关联的数据对象（即当前数据对象是view的数据对象，relateObjectKey表示的其单据的数据对象） */
    private String relateObjectKey= "";
    /** 登录认证标志 */
    private Boolean authenticate = true;
    /** 禁止保存*/
    private Boolean forbiddenSave = false;
    /** 禁止载入 */
    private Boolean forbiddenLoad = false;
    /** 禁止载入 */
    private Boolean forbiddenDelete = false;
    /** 配置版本 */
    private Integer version = 0;
    /** 继承的数据对象标识 */
    private String extend = "";
    // 复杂对象
    /** 数据对象包含的子对象：表的集合 */
    private MetaTableCollection tableCollection = null;
    /** 状态集合 */
    private MetaStatusCollection statusCollection = null;
    /** 检查规则集合 */
    private MetaCheckRuleCollection checkRuleCollection = null;
    /** 载入前事件处理 */
    private MetaPreLoadProcess preLoadProcess = null;
    /** 载入后事件处理 */
    private MetaPostLoadProcess postLoadProcess = null;
    /** 保存前事件处理 */
    private MetaPreSaveProcess preSaveProcess = null;
    /** 保存后事件处理 */
    private MetaPostSaveProcess postSaveProcess = null;
    /** 删除前事件处理 */
    private MetaPreDeleteProcess preDeleteProcess = null;
    /** 删除后事件处理 */
    private MetaPostDeleteProcess postDeleteProcess = null;
    /** 扩展类集合 */
    private MetaExtendCollection extendCollection = null;
    /** 迁移检查规则 */
    private MetaMigrationCheckRuleCollection migrationCheckRuleCollection = null;
    /** 针对数据操作的安全检查集合 */
    private MetaSecurityProviderCollection securityProviderCollection = null;
    /** 状态触发器集合 */
    private MetaStatusTriggerCollection statusTriggerCollection = null;
    /** 关系表 */
    private MetaRelation relation = null;
    /** 数据对象的历史版本管理 */
    private MetaHistory history = null;
    /** 批量持化对象 */
    private MetaBatchPersist batchPersist = null;
    /** 宏公式集合 */
    private MetaMacroCollection macroCollection = null;
    /** 命名处理集合 */
    private MetaNamedProcess namedProcess = null;
    /** 嵌入表集合 */
    private MetaEmbedTableCollection embedTables = null;

    // 以下的内容与配置文件读写无关，主要目的是方便程序应用
    /** 对工程的引用 */
    private IMetaProject project = null;
    /** 所在工程名称*/
    private String projectKey = null;
    /** 对主表元数据的引用 */
    private MetaTable mainTable = null;
    /** 模板是否已经处理的标志 */
    private boolean templateProcessed = false;
    /** 字典模糊查询字段 */
    private String strQueryColumns = null;
    private List<MetaColumn> queryColumns = null;
    /** 字典显示字段 */
    private String strDisplayColumns = null;
    private List<MetaColumn> displayColumns = null;
    /** 字典下拉框显示列*/
    private String strDropviewColumns = null;
    private List<MetaColumn> dropviewColumns = null;
    
    /** 迁移结转表（如果当前MetaDataObject是一个迁移表的对象） */
    private MetaTable migrationLastPointTable = null;

    /** ERP迁移主键表 2020-11-10 zhsy */
    private MetaTable erpMigrationKeysTable = null;
    /** 分库中使用的附加表 */
    private MetaTable erpMigrationKeysPreTable = null;
    /** ERP迁移增量表 2020-11-10 zhsy */
    private MetaTable erpMigrationIncrTable = null;
    /** ERP迁移新表 2021-06-24 zhsy */
    private MetaTable erpMigrationNewTable = null;
    /** 分库中使用的附加表 */
    private MetaTable erpMigrationNewPreTable = null;
    /** ERP迁移LP新表 2021-06-24 zhsy */
    private MetaTable erpMigrationLpNewTable = null;

    private boolean providerInit=false;
    /** IO工厂类标识 */
    private String IOProvider = "";
    /** 是否维护字典的tleft tright*/
    private Boolean maintainDict = true;
    /** OID过滤 */
    private MetaOIDFilter OIDFilter = null;
    /** 系统自动生成标识 */
    private boolean autoGen = false;

    /** 加载权限类型，默认为过滤权限*/
    private Integer loadRightsType = DataObjectLoadRightsType.FILTER;
    /** 权限的检查在加载后还是加载前，默认是加载前（这种模型下过滤直接通过SQL的子查询）*/
    private Boolean checkAfterLoad = false;
    /** 迁移增量表，用于只关注发生额的迁移*/
    private MetaTable migrationDeltaTable = null;
    /** 迁移增量表的表名，如果未定义则采用“主表名+_Delta”作为增量表名*/
    private String migrationDeltaDBName = "";
    /** 期间结转策略 */
    private Integer rollDataStrategy = RollDataStrategyType.NORMAL;
    /** 字典自定义查询语句 */
    private MetaDictQueryStatement dictQueryStatement = null;
    /**是否维护数据库*/
    private Boolean maintainSchema = true;
    /** 字典全局过滤条件*/
    private String globalRightFilter = "";
    private String mergeToSourceMapKey = null;
    private String browserFormKey = null;
    private String queryFormKey = null;
    /** 字典显示编码字典，useCode or Code*/
    private String showCode = SystemField.CODE_DICT_KEY;
    private boolean i18n = false;
    /**
     * 字典缓存检查策略，取值范围见{@link DictCacheCheckMode}
     */
    private Integer dictCacheCheckMode = -1;

    public MetaDataObject() {
        super();
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        addAll(list, new AbstractMetaObject[] { tableCollection, statusCollection,
                checkRuleCollection, preLoadProcess, postLoadProcess, preSaveProcess, postSaveProcess,
                preDeleteProcess,postDeleteProcess,
                extendCollection, migrationCheckRuleCollection, relation,
                history, batchPersist,
                securityProviderCollection, statusTriggerCollection,
                macroCollection, namedProcess, embedTables,OIDFilter, dictQueryStatement});
    }

    public MetaTable getMetaTable(String tableKey) {
        return tableCollection.get(tableKey);
    }

    public MetaTable getMetaTableByDBTableName(String dbTableName) {
        for (int i = 0; i < tableCollection.size(); i++) {
            MetaTable table = tableCollection.get(i);
            if (table.getDBTableName().equals(dbTableName)) {
                return table;
            }
        }
        return null;
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        AbstractMetaObject resultMetaObject = null;
        if (MetaTableCollection.TAG_NAME.equalsIgnoreCase(tagName)) {
            tableCollection = new MetaTableCollection();
            resultMetaObject = tableCollection;
        } else if (MetaCheckRuleCollection.TAG_NAME.equals(tagName)) {
            checkRuleCollection = new MetaCheckRuleCollection();
            resultMetaObject = checkRuleCollection;
        } else if (MetaPreLoadProcess.TAG_NAME.equals(tagName)) {
            preLoadProcess = new MetaPreLoadProcess();
            resultMetaObject = preLoadProcess;
        } else if (MetaPostLoadProcess.TAG_NAME.equals(tagName)) {
            postLoadProcess = new MetaPostLoadProcess();
            resultMetaObject = postLoadProcess;
        } else if (MetaPreSaveProcess.TAG_NAME.equals(tagName)) {
            preSaveProcess = new MetaPreSaveProcess();
            resultMetaObject = preSaveProcess;
        } else if (MetaPostSaveProcess.TAG_NAME.equals(tagName)) {
            postSaveProcess = new MetaPostSaveProcess();
            resultMetaObject = postSaveProcess;
        } else if (MetaExtendCollection.TAG_NAME.equals(tagName)) {
            extendCollection = new MetaExtendCollection();
            resultMetaObject = extendCollection;
        } else if (MetaMigrationCheckRuleCollection.TAG_NAME.equals(tagName)) {
            migrationCheckRuleCollection = new MetaMigrationCheckRuleCollection();
            resultMetaObject = migrationCheckRuleCollection;
        } else if (MetaRelation.TAG_NAME.equals(tagName)) {
            relation = new MetaRelation();
            resultMetaObject = relation;
        } else if (MetaStatusCollection.TAG_NAME.equals(tagName)) {
            statusCollection = new MetaStatusCollection();
            resultMetaObject = statusCollection;
        } else if (MetaHistory.TAG_NAME.equals(tagName)) {
            this.history = new MetaHistory();
            resultMetaObject = this.history;
        } else if (MetaBatchPersist.TAG_NAME.equals(tagName)) {
            this.batchPersist = new MetaBatchPersist();
            resultMetaObject = this.batchPersist;
        } else if (MetaSecurityProviderCollection.TAG_NAME.equals(tagName)) {
            this.securityProviderCollection = new MetaSecurityProviderCollection();
            resultMetaObject = this.securityProviderCollection;
        } else if (MetaStatusTriggerCollection.TAG_NAME.equals(tagName)) {
            this.statusTriggerCollection = new MetaStatusTriggerCollection();
            resultMetaObject = this.statusTriggerCollection;
        } else if ( MetaMacroCollection.TAG_NAME.equals(tagName) ) {
            this.macroCollection = new MetaMacroCollection();
            resultMetaObject = this.macroCollection;
        } else if ( MetaNamedProcess.TAG_NAME.equals(tagName) ) {
            this.namedProcess = new MetaNamedProcess();
            resultMetaObject = this.namedProcess;
        } else if ( MetaEmbedTableCollection.TAG_NAME.equals(tagName) ) {
            this.embedTables = new MetaEmbedTableCollection();
            resultMetaObject = this.embedTables;
        } else if (MetaOIDFilter.TAG_NAME.equals(tagName)) {
            this.OIDFilter = new MetaOIDFilter();
            resultMetaObject = this.OIDFilter;
        }else if (MetaPreDeleteProcess.TAG_NAME.equals(tagName)) {
            this.preDeleteProcess = new MetaPreDeleteProcess();
            resultMetaObject = this.preDeleteProcess;
        }else if (MetaPostDeleteProcess.TAG_NAME.equals(tagName)) {
            this.postDeleteProcess = new MetaPostDeleteProcess();
            resultMetaObject = this.postDeleteProcess;
        }else if (MetaDictQueryStatement.TAG_NAME.equals(tagName)){
            this.dictQueryStatement = new MetaDictQueryStatement();
            resultMetaObject = this.dictQueryStatement;
        }

        return resultMetaObject;
    }

    /**
     * 取得编号前缀
     *
     * @return 编号前缀
     */
    public String getNoPrefix() {
        return noPrefix;
    }

    /**
     * 设置编号前缀
     *
     * @param noPrefix
     *            编号前缀
     */
    public void setNoPrefix(String noPrefix) {
        this.noPrefix = noPrefix;
    }

    public String getMergeToSourceMapKey() {
        return mergeToSourceMapKey;
    }

    public void setMergeToSourceMapKey(String mergeToSourceMapKey) {
        this.mergeToSourceMapKey = mergeToSourceMapKey;
    }

    public String getBrowserFormKey() {
        return browserFormKey;
    }

    public void setBrowserFormKey(String browserFormKey) {
        this.browserFormKey = browserFormKey;
    }

    public String getQueryFormKey() {
        return queryFormKey;
    }

    public void setQueryFormKey(String queryFormKey) {
        this.queryFormKey = queryFormKey;
    }


    /**
     * 设置定制编号前缀
     *
     * @param customNoPrefix
     *            定制编号前缀
     */
    public void setCustomNoPrefix(String customNoPrefix) {
        this.customNoPrefix = customNoPrefix;
    }

    /**
     * 取得定制编号前缀
     *
     * @return 定制编号前缀
     */
    public String getCustomNoPrefix() {
        return this.customNoPrefix;
    }

    /**
     * 获取数据对象的历史版本配置对象
     *
     * @return 数据对象的历史版本配置对象
     */
    public MetaHistory getHistory() {
        return history;
    }

    /**
     * 设置数据对象的历史版本记录
     *
     * @param history
     *            据对象的历史版本配置对象
     */
    public void setHistory(MetaHistory history) {
        this.history = history;
    }

    /**
     * 获取数据对象的标志
     *
     * @return 标志
     */
    public String getKey() {
        return key;
    }

    /**
     * 获取数据对象的名称
     *
     * @return 名称
     */
    public String getCaption() {
        return caption;
    }

    /**
     * 获取数据对象的类型
     *
     * @return 类型
     */
    public Integer getPrimaryType() {
        return primaryType;
    }

    /**
     * 获取数据对象的辅助类型
     *
     * @return 辅助类型
     */
    public Integer getSecondaryType() {
        return secondaryType;
    }

    /**
     * 获取数据对象的子对象：表集合
     *
     * @return 表的集合
     */
    public MetaTableCollection getTableCollection() {
        return tableCollection;
    }

    /**
     * 设置数据数据的子对象tableCollection（表集合）
     *
     * @param tableCollection
     *            表的集合
     */
    public void setTableCollection(MetaTableCollection tableCollection) {
        this.tableCollection = tableCollection;
    }

    /**
     * 获取安全检查集合
     *
     * @return 安全检查集合
     */
    public MetaSecurityProviderCollection getSecurityProviderCollection() {
        return securityProviderCollection;
    }

    /**
     * 设值安全检查集合
     *
     * @param securityProviderCollection 安全检查集合
     */
    public void setSecurityProviderCollection(MetaSecurityProviderCollection securityProviderCollection) {
        this.securityProviderCollection = securityProviderCollection;
    }

    /**
     * 设置数据对象的标志
     *
     * @param key
     *            标志
     */
    public void setKey(String key) {
        this.key = key;
    }

    /**
     * 设置数据对象的名称
     *
     * @param caption
     *            名称
     */
    public void setCaption(String caption) {
        this.caption = caption;
    }

    /**
     * 设置数据对象的类型
     *
     * @param primaryType
     *            类型
     */
    public void setPrimaryType(Integer primaryType) {
        this.primaryType = primaryType;
    }

    /**
     * 设置数据对象的辅助类型
     *
     * @param secondaryType
     *            辅助类型
     */
    public void setSecondaryType(Integer secondaryType) {
        this.secondaryType = secondaryType;
    }

    /**
     * 取得状态集合
     *
     * @return 状态集合
     */
    public MetaStatusCollection getStatusCollection() {
        return statusCollection;
    }

    /**
     * 设置状态集合
     *
     * @param statusCollection
     *            状态集合
     */
    public void setStatusCollection(MetaStatusCollection statusCollection) {
        this.statusCollection = statusCollection;
    }

    /**
     * 获取主表的标识
     *
     * @return 主表标识
     */
    public String getMainTableKey() {
        return mainTableKey;
    }

    /**
     * 设置主表的标识
     *
     * @param mainTableKey
     *            标识
     */
    public void setMainTableKey(String mainTableKey) {
        this.mainTableKey = mainTableKey;
    }

    /**
     * 设置检查规则集合
     *
     * @param checkRuleCollection
     *            检查规则集合
     * @see MetaCheckRuleCollection
     */
    public void setCheckRuleCollection(MetaCheckRuleCollection checkRuleCollection) {
        this.checkRuleCollection = checkRuleCollection;
    }

    /**
     * 取得检查规则集合
     *
     * @return 检查规则集合
     * @see MetaCheckRuleCollection
     */
    public MetaCheckRuleCollection getCheckRuleCollection() {
        return this.checkRuleCollection;
    }

    /**
     * 设置载入前事件处理
     *
     * @param preLoadProcess
     *            载入前事件处理
     * @see MetaPreLoadProcess
     */
    public void setPreLoadProcess(MetaPreLoadProcess preLoadProcess) {
        this.preLoadProcess = preLoadProcess;
    }

    /**
     * 取得载入前事件处理
     *
     * @return 载入前事件处理
     * @see MetaPreLoadProcess
     */
    public MetaPreLoadProcess getPreLoadProcess() {
        return this.preLoadProcess;
    }

    /**
     * 设置载入后事件处理
     *
     * @param postLoadProcess
     *            载入后事件处理
     * @see MetaPostLoadProcess
     */
    public void setPostLoadProcess(MetaPostLoadProcess postLoadProcess) {
        this.postLoadProcess = postLoadProcess;
    }

    /**
     * 取得载入后事件处理
     *
     * @return 载入后事件处理
     * @see MetaPostLoadProcess
     */
    public MetaPostLoadProcess getPostLoadProcess() {
        return this.postLoadProcess;
    }

    /**
     * 设置保存前事件处理
     *
     * @param preSaveProcess
     *            保存前事件处理
     * @see MetaPreSaveProcess
     */
    public void setPreSaveProcess(MetaPreSaveProcess preSaveProcess) {
        this.preSaveProcess = preSaveProcess;
    }

    /**
     * 取得保存前事件处理
     *
     * @return 保存前事件处理
     * @see MetaPreSaveProcess
     */
    public MetaPreSaveProcess getPreSaveProcess() {
        return this.preSaveProcess;
    }

    /**
     * 设置保存后事件处理
     *
     * @param postSaveProcess
     *            保存后事件处理
     * @see MetaPostSaveProcess
     */
    public void setPostSaveProcess(MetaPostSaveProcess postSaveProcess) {
        this.postSaveProcess = postSaveProcess;
    }

    /**
     * 取得保存后事件处理
     *
     * @return 保存后事件处理
     * @see MetaPostSaveProcess
     */
    public MetaPostSaveProcess getPostSaveProcess() {
        return this.postSaveProcess;
    }

    /**
     * 取得删除前事件处理
     * @return 删除前事件处理
     */
    public MetaPreDeleteProcess getPreDeleteProcess() {
        return preDeleteProcess;
    }

    /**
     * 设置删除前事件处理
     * @param preDeleteProcess 删除前事件处理
     */
    public void setPreDeleteProcess(MetaPreDeleteProcess preDeleteProcess) {
        this.preDeleteProcess = preDeleteProcess;
    }

    /**
     * 取得删除后事件处理
     * @return 删除后事件处理
     */
    public MetaPostDeleteProcess getPostDeleteProcess() {
        return postDeleteProcess;
    }

    /**
     * 设置删除后事件处理
     * @param postDeleteProcess 删除后事件处理
     */
    public void setPostDeleteProcess(MetaPostDeleteProcess postDeleteProcess) {
        this.postDeleteProcess = postDeleteProcess;
    }

    /**
     * 设置模板是否已经处理标志
     *
     * @param templateProcessed
     *            标志
     */
    public void setTemplateProcessed(boolean templateProcessed) {
        this.templateProcessed = templateProcessed;
    }

    /**
     * 取得模板是否已经处理标志
     *
     * @return 标志
     */
    public boolean isTemplateProcessed() {
        return this.templateProcessed;
    }

    /**
     * 获取关系表对象
     *
     * @return 关系表对象
     */
    public MetaRelation getRelation() {
        return relation;
    }

    /**
     * 设置关系表对象
     *
     * @param relation
     *            关系表对象
     */
    public void setRelation(MetaRelation relation) {
        this.relation = relation;
    }

    /**
     * 设置OID过滤
     *
     * @param OIDFilter
     *            OID过滤
     */
    public void setOIDFilter(MetaOIDFilter OIDFilter) {
        this.OIDFilter = OIDFilter;
    }

    /**
     * 取得OID过滤
     *
     * @return OID过滤
     */
    public MetaOIDFilter getOIDFilter() {
        return this.OIDFilter;
    }
    /**
     * 获取继承数据对象的标识
     *
     * @return 继承数据对象的标识
     */
    public String getExtend() {
        return extend;
    }

    /**
     * 设置继承数据对象的标识
     *
     * @param extend
     *            继承数据对象的标识
     */
    public void setExtend(String extend) {
        this.extend = extend;
    }

    /**
     * 设置批量持久化对象
     *
     * @param batchPersist
     *            批量持久化对象
     */
    public void setBatchPersist(MetaBatchPersist batchPersist) {
        this.batchPersist = batchPersist;
    }

    /**
     * 取得批量持久化对象
     *
     * @return 批量持久化对象
     */
    public MetaBatchPersist getBatchPersist() {
        return this.batchPersist;
    }

    /**
     * 设置状态触器集合
     *
     * @param statusTriggerCollection
     *            状态触发器集合
     */
    public void setStatusTriggerCollection(MetaStatusTriggerCollection statusTriggerCollection) {
        this.statusTriggerCollection = statusTriggerCollection;
    }

    /**
     * 取得状态触发器集合
     *
     * @return 状态触发器集合
     */
    public MetaStatusTriggerCollection getStatusTriggerCollection() {
        return this.statusTriggerCollection;
    }

    /**
     * 判断数据对象中是否存在某列
     *
     * @param tableKey
     *            表标识
     * @param columnKey
     *            列标识
     * @return 如果数据对象中存储tableKey指定的表定义，并且指表中具有columnKey指定的列则返回true，否则返回false
     */
    public boolean contains(String tableKey, String columnKey) {
        boolean result = false;
        MetaTable table = this.tableCollection.get(tableKey);
        if (table != null) {
            result = table.containsKey(columnKey);
        }
        return result;
    }

    public void setI18n(boolean i18n) {
        this.i18n = i18n;
    }

    public boolean isI18n() {
        return this.i18n;
    }

    /**
     * 判断数据对象中是否包含给定的表
     *
     * @param tableKey 表标识
     *
     * @return 是否包含给定的表
     */
    public boolean contains(String tableKey) {
        return this.tableCollection.get(tableKey) != null;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaDataObject newObject = new MetaDataObject();
        newObject.setTableCollection(tableCollection == null ? null : (MetaTableCollection) tableCollection.clone());
        newObject.setKey(key);
        newObject.setCaption(caption);
        newObject.setBrowserFormKey(browserFormKey);
        newObject.setPrimaryType(primaryType);
        newObject.setSecondaryType(secondaryType);
        newObject.setMainTableKey(mainTableKey);
        newObject.setNoPrefix(noPrefix);
        newObject.setExtend(extend);
        newObject.setLoadRightsType(loadRightsType);
        newObject.setCheckAfterLoad(checkAfterLoad);
        newObject.setStatusCollection(statusCollection == null ? null : (MetaStatusCollection) statusCollection.clone());
        newObject.setCheckRuleCollection(checkRuleCollection == null ? null : (MetaCheckRuleCollection) checkRuleCollection.clone());
        newObject.setPreLoadProcess(preLoadProcess == null ? null : (MetaPreLoadProcess) preLoadProcess.clone());
        newObject.setPostLoadProcess(postLoadProcess == null ? null : (MetaPostLoadProcess) postLoadProcess.clone());
        newObject.setPreSaveProcess(preSaveProcess == null ? null : (MetaPreSaveProcess) preSaveProcess.clone());
        newObject.setPostSaveProcess(postSaveProcess == null ? null : (MetaPostSaveProcess) postSaveProcess.clone());
        newObject.setProject(project);
        newObject.setExtendCollection(extendCollection == null ? null : (MetaExtendCollection) extendCollection.clone());
        newObject.setMigrationCheckRuleCollection(migrationCheckRuleCollection == null ? null : (MetaMigrationCheckRuleCollection) migrationCheckRuleCollection.clone());
        newObject.setQueryColumns(strQueryColumns);
        newObject.setDisplayColumns(strDisplayColumns);
        newObject.setDropviewColumns(strDropviewColumns);
        newObject.setMigrationLastPointTable(migrationLastPointTable == null ? null : (MetaTable) migrationLastPointTable.clone());
        // ERP主键表和日志表 2020-11-10 zhsy begin
        newObject.setErpMigrationKeysTable(erpMigrationKeysTable == null ? null : (MetaTable) erpMigrationKeysTable.clone());
        newObject.setErpMigrationIncrTable(erpMigrationIncrTable == null ? null : (MetaTable) erpMigrationIncrTable.clone());
        // ERP主键表和日志表 2020-11-10 zhsy end
        // ERP主表新表和LP新表日志表 2021-06-24 zhsy begin
        newObject.setErpMigrationNewTable(erpMigrationNewTable == null ? null : (MetaTable) erpMigrationNewTable.clone());
        newObject.setErpMigrationLpNewTable(erpMigrationLpNewTable == null ? null : (MetaTable) erpMigrationLpNewTable.clone());
        // ERP主表新表和LP新表日志表 2021-06-24 zhsy end
        newObject.setHistory(history == null ? null : (MetaHistory) history.clone());
        newObject.setRelation(relation == null ? null : (MetaRelation) relation.clone());
        newObject.setBatchPersist(batchPersist == null ? null : (MetaBatchPersist) batchPersist.clone());
        newObject.setSecurityProviderCollection(securityProviderCollection == null ? null : (MetaSecurityProviderCollection) this.securityProviderCollection.clone());
        newObject.setStatusTriggerCollection(statusTriggerCollection == null ? null : (MetaStatusTriggerCollection) statusTriggerCollection.clone());
        newObject.mainTable = newObject.getTable(newObject.getMainTableKey());
        newObject.setMaintainDict(maintainDict);
        newObject.setMacroCollection(macroCollection == null ? null : (MetaMacroCollection)macroCollection.clone());
        newObject.setNamedProcess(namedProcess == null ? null : (MetaNamedProcess)namedProcess.clone());
        newObject.setEmbedTables(embedTables == null ? null : (MetaEmbedTableCollection)embedTables.clone());
        newObject.migrationDeltaTable = migrationDeltaTable == null ? null : (MetaTable)migrationDeltaTable.clone();
        newObject.setMigrationDeltaDBName(migrationDeltaDBName);

        newObject.setPreDeleteProcess(preDeleteProcess==null ? null : (MetaPreDeleteProcess) preDeleteProcess.clone());
        newObject.setPostDeleteProcess(postDeleteProcess==null ? null : (MetaPostDeleteProcess) postDeleteProcess.clone());
        newObject.setVersion(version);
        newObject.setRollDataStrategy(rollDataStrategy);
        newObject.setDictQueryStatement(dictQueryStatement);
        newObject.setMaintainSchema(maintainSchema);
        newObject.setI18n(i18n);
        newObject.setDictCacheCheckMode(dictCacheCheckMode);
        newObject.setQueryFormKey(queryFormKey);
        newObject.showCode = this.showCode;
        return newObject;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaDataObject();
    }

    /**
     * 根据表名及列名查找列定义
     *
     * @param tableKey
     *            表标识
     * @param columnKey
     *            列标识
     * @return tableKey指定的表中列定义为columnKey的列定义
     */
    public MetaColumn findColumn(String tableKey, String columnKey) {
        MetaColumn column = null;
        MetaTable table = this.tableCollection.get(tableKey);
        if (table != null) {
            column = table.get(columnKey);
        }
        return column;
    }

    /**
     * 判断是否存在字段定义
     *
     * @param tableKey
     *            表标识
     * @param columnKey
     *            　列标识
     * @return 如果存在tableKey和columnKey指定的列则返回true，否则返回false
     */
    public boolean hasColumn(String tableKey, String columnKey) {
        MetaTable table = this.tableCollection.get(tableKey);
        if (table != null) {
            return table.containsKey(columnKey);
        }
        return false;
    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
        String lockKey = SystemPrefix.META_DO_POST_PROCESS+ this.getKey();
        try {
            // dataObject存在多次调用，refDataObject 加载一次，单据模板合并数据源也会调用
            LockUtil.execute(lockKey, ()->{
                doPostProcessImpl(flag, callback);
                return true;
            });
        } catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void doPostProcessImpl(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
        if (tableCollection != null) {
            Iterator<MetaTable> iterator = tableCollection.iterator();

            MetaTable table = null;
            while (iterator.hasNext()){
                table = iterator.next();
                table.doPostProcess(flag,callback);
            }

        }
        if(this.getPrimaryType() == DataObjectPrimaryType.TEMPLATE){
            return;
        }

        if (tableCollection != null) {
            tableCollection.doPostProcess(mainTableKey);
            mainTable = tableCollection.get(mainTableKey);

            // 字典预先处理
            if (this.getSecondaryType() == DataObjectSecondaryType.DICT || this.getSecondaryType() == DataObjectSecondaryType.CHAINDICT) {
                if (mainTable == null) {
                    throw new MetaException(MetaException.PRIMARY_TABLE_NOT_DEFINED, SimpleStringFormat.format(StringTable.getString(null, "", StringTable.PrimaryTableNotDefined),
                            this.key));
                }
                boolean hasSort = false;
                for (MetaColumn col : mainTable) {
                    // oid code name nodeType enable 及显示字段 需缓存
                    if (SystemField.OID_SYS_KEY.equals(col.getKey())) {
                        col.setCache(true);
                    } else if (SystemField.CODE_DICT_KEY.equals(col.getKey())) {
                        col.setCache(true);
                    } else if (SystemField.NAME_DICT_KEY.equals(col.getKey())) {
                        col.setCache(true);
                    } else if (SystemField.NODETYPE_DICT_KEY.equals(col.getKey())) {
                        col.setCache(true);
                    } else if (SystemField.ENABLE_DICT_KEY.equals(col.getKey())) {
                        col.setCache(true);
                    } else if (SystemField.PARENTID_DICT_KEY.equals(col.getKey())) {
                        col.setCache(true);
                    } else if (this.getDisplayColumns().contains(col)) {
                        col.setCache(true);
                    } else if (this.getDropviewColumns().contains(col)) {
                        col.setCache(true);
                    }
                    if (col.getSort() != SortType.None) {
                        col.setCache(true);
                        hasSort = true;
                    }
                }
                // 如果 主表 未设置 排序字段， 则默认 设置显示列的第一个字段为排序字段
                if (!hasSort) {
                    mainTable.get(this.getDisplayColumns().get(0).getKey()).setSort(SortType.Asc);
                }

                //链式字典不维护tleft tright
                if(this.getSecondaryType() == DataObjectSecondaryType.CHAINDICT){
                    this.setMaintainDict(false);
                }
                
                // displayColumn包含useCode的情况下 showCode 为useCode
	    		if(this.getDisplayColumnsStr().indexOf(SystemField.USECODE_DICT_KEY) >-1) {
	    			this.showCode = SystemField.USECODE_DICT_KEY;
	    		}
            }

            if(mainTable != null && mainTable.isHead() && mainTable.isPersist()) {
                MetaColumn createDate = mainTable.getCreateDate();
                MetaColumn createTime = mainTable.getCREATETIMEColumn();
                // 存在 createTime的时候添加createDate 字段
                if (createTime != null && createDate == null) {
                    createDate = new MetaColumn();
                    createDate.setKey(SystemField.CREATE_DATE_SYS_KEY);
                    createDate.setDataType(DataType.LONG);
                    createDate.setDefaultValue("0");
                    createDate.setPersist(true);
                    createDate.setAutoGen(true);
                    mainTable.add(createDate);
                }
            }

            Iterator<MetaTable> it = tableCollection.iterator();
            MetaTable table = null;
            while (it.hasNext()) {
                table = it.next();
                // 只有需要存储的表只需要增加MapCount
                if ( this.primaryType == DataObjectPrimaryType.ENTITY && table.isPersist() ) {
                    MetaColumn mapCount = table.getMapCount();
                    if (mapCount == null) {
                        mapCount = new MetaColumn();
                        mapCount.setKey(SystemField.MAPCOUNT_SYS_KEY);
                        mapCount.setDataType(DataType.INT);
                        mapCount.setDefaultValue("0");
                        mapCount.setPersist(true);
                        mapCount.setAutoGen(true);
                        table.add(mapCount);
                    }
                    
                    MetaColumn lastModified = table.getLastModified();
                    if(lastModified == null) {
                    	lastModified = new MetaColumn();
                    	lastModified.setKey(SystemField.LASTMODIFIED_SYS_KEY);
                    	lastModified.setDataType(DataType.LONG);
                    	lastModified.setDefaultValue("0");
                    	lastModified.setPersist(true);
                    	lastModified.setAutoGen(true);
                        table.add(lastModified);
                    }
                }
                MetaParameterCollection pc = table.getParameterCollection();
                if (pc != null) {
                    for (MetaParameter para : pc) {
                        String tableName = para.getTargetTable();
                        String columnName = para.getTargetColumn();
                        MetaTable targetTable = table;
                        if (tableName != null && tableName.length() > 0)
                            targetTable = getMetaTable(tableName);
                        // 有些参数类型本身已经可以确定，不需要做类型转换
                        if (targetTable != null && columnName != null && !columnName.isEmpty()) {
                            para.setDataType(targetTable.get(columnName).getDataType());
                        }
                    }
                }

                try {
                    if(callback != null){
                        callback.call(this);
                    }
                } catch (Throwable e) {
                    e.printStackTrace();
                    throw new MetaException(MetaException.MIGRATIONEXTENSION_ERROR, SimpleStringFormat.format(StringTable.getString(null, "", StringTable.MigrationExtensionError), this.key));
                }
            }               
        }
    }

    public IMetaProject getProject() {
        return project;
    }

    public void setProject(IMetaProject project) {
        this.project = project;
        if( project != null ) {
            this.projectKey = project.getKey();
        }
    }

    public String getProjectKey() {
        return projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    /**
     * 设置主表
     * @param mainTable 主表
     */
    public void setMainTable(MetaTable mainTable){
        this.mainTable = mainTable;
    }

    /**
     * 取得主表
     *
     * @return 如果定义了主表并且存在，则返回该主表定义，否则返回null
     */
    public MetaTable getMainTable() {
        return mainTable;
    }

    /**
     * 取得非空主表
     *
     * @return 如果定义了主表并且存在，则返回该主表定义，否则抛出主表未定义异常
     */
    public MetaTable getMainTableNotNull() {
        if (mainTable != null) {
            return mainTable;
        }
        throw new MetaException(MetaException.PRIMARY_TABLE_NOT_DEFINED,
                SimpleStringFormat.format(StringTable.getString(null, "", StringTable.PrimaryTableNotDefined), this.key));
    }

    /**
     * 设置扩展类集合
     *
     * @param extendCollection
     *            扩展类集合
     */
    public void setExtendCollection(MetaExtendCollection extendCollection) {
        this.extendCollection = extendCollection;
    }

    /**
     * 取得扩展类集合
     *
     * @return 扩展类集合
     */
    public MetaExtendCollection getExtendCollection() {
        return this.extendCollection;
    }

    public MetaMigrationCheckRuleCollection getMigrationCheckRuleCollection() {
        return migrationCheckRuleCollection;
    }

    public void setMigrationCheckRuleCollection(MetaMigrationCheckRuleCollection migrationCheckRuleCollection) {
        this.migrationCheckRuleCollection = migrationCheckRuleCollection;
    }

    public void setQueryColumns(String s) {
        if (s != null && !s.isEmpty()) {
            this.strQueryColumns = s;
        }
    }

    public String getQueryColumnsStr() {
        if(this.strQueryColumns != null && !this.strQueryColumns.isEmpty()) {
            return this.strQueryColumns;
        }
        if(this.strDisplayColumns != null && !this.strDisplayColumns.isEmpty()) {
            return this.strDisplayColumns;
        }
        return SystemField.DEFAULT_QUERY_FIELDS;
    }

    public String getOriginalQueryColumnsStr() {
        return this.strQueryColumns;
    }

    public void setDisplayColumns(String s) {
        if (s != null && !s.isEmpty()) {
            this.strDisplayColumns = s;
        }
    }

    public String getDisplayColumnsStr() {
        return this.strDisplayColumns;
    }

    public List<MetaColumn> getQueryColumns() {
        if (this.queryColumns == null) {
            List<MetaColumn> list = new ArrayList<MetaColumn>();
            String[] columns = this.getQueryColumnsStr().split(";");

            for (String column : columns) {
                list.add(this.getMainTable().get(column));
            }
            this.queryColumns = list;
        }
        return this.queryColumns;
    }

    public List<MetaColumn> getDisplayColumns() {
        if (this.displayColumns == null) {
            List<MetaColumn> list = new ArrayList<MetaColumn>();
            String[] columns = this.strDisplayColumns.split(";");
            MetaColumn col = null;
            for (String column : columns) {
                col = this.getMainTable().get(column);
                list.add(col);
            }
            this.displayColumns = list;
        }
        return this.displayColumns;
    }

    public void setDropviewColumns(String s) {
        if (s != null && !s.isEmpty()) {
            this.strDropviewColumns = s;
        }
    }

    public String getDropviewColumnsStr() {
        return this.strDropviewColumns;
    }
    
    public List<MetaColumn> getDropviewColumns() {
        if (this.dropviewColumns == null) {
            List<MetaColumn> list = new ArrayList<MetaColumn>();
            if(strDropviewColumns != null && !strDropviewColumns.isEmpty()) {
	            String[] columns = this.strDropviewColumns.split(";");
	            MetaColumn col = null;
	            for (String column : columns) {
	                col = this.getMainTable().get(column);
	                list.add(col);
	            }
            }
            this.dropviewColumns = list;
        }
        return this.dropviewColumns;
    }
    
    public MetaTable getMigrationLastPointTable() {
        if (primaryType != DataObjectPrimaryType.ENTITY || secondaryType != DataObjectSecondaryType.MIGRATION) {
            return null;
        }

        if (mainTable != null && migrationLastPointTable == null) {
            synchronized (this) {
                if (migrationLastPointTable == null)
                    migrationLastPointTable = newPeriodPointTable(mainTable);
            }
        }

        return migrationLastPointTable;
    }

    /***
     * 获取ERP余额主键表
     * @Date 2020-11-10 13:00
     * @author zhsy
     * @return ERP余额主键表
     */
    public MetaTable getErpMigrationKeysTable() {
        if (primaryType != DataObjectPrimaryType.ENTITY || secondaryType != DataObjectSecondaryType.MIGRATION) {
            return null;
        }

        if (null != mainTable && null == erpMigrationKeysTable) {
            synchronized (this) {
                if (null == erpMigrationKeysTable) {
                    erpMigrationKeysTable = newErpKeysTable(mainTable, MigrationAttributeDef.ERP_KEYS_POSTFIX);
                }
            }
        }
        return erpMigrationKeysTable;
    }

    /***
     * 获取ERP余额主键表, 分库
     * @Date 2020-11-10 13:00
     * @author zhsy
     * @return ERP余额主键表
     */
    public MetaTable getErpMigrationKeysPreTable() {
        if (primaryType != DataObjectPrimaryType.ENTITY || secondaryType != DataObjectSecondaryType.MIGRATION) {
            return null;
        }

        if (null != mainTable && null == erpMigrationKeysPreTable) {
            synchronized (this) {
                if (null == erpMigrationKeysPreTable) {
                    erpMigrationKeysPreTable = newErpKeysTable(mainTable, MigrationAttributeDef.ERP_KEYS_POSTFIX + "PRE");
                }
            }
        }
        return erpMigrationKeysPreTable;
    }

    /***
     * 获取ERP余额增量表
     * @Date 2020-11-10 13:00
     * @author zhsy
     * @return ERP余额增量表
     */
    public MetaTable getErpMigrationIncrTable() {
        if (primaryType != DataObjectPrimaryType.ENTITY || secondaryType != DataObjectSecondaryType.MIGRATION) {
            return null;
        }

        if (null != mainTable && null == erpMigrationIncrTable) {
            synchronized (this) {
                if (null == erpMigrationIncrTable) {
                    erpMigrationIncrTable = newErpKeysOtherTable(mainTable, MigrationAttributeDef.ERP_INCR_POSTFIX);
                }
            }
        }
        return erpMigrationIncrTable;
    }

    /***
     * 获取ERP余额新表
     * @Date 2021-06-24 10:36
     * @author zhsy
     * @return ERP余额新表
     */
    public MetaTable getErpMigrationNewTable() {
        if (primaryType != DataObjectPrimaryType.ENTITY || secondaryType != DataObjectSecondaryType.MIGRATION) {
            return null;
        }

        if (null != mainTable && null == erpMigrationNewTable) {
            synchronized (this) {
                if (null == erpMigrationNewTable) {
                    erpMigrationNewTable = newErpKeysOtherTable(mainTable, MigrationAttributeDef.ERP_NEW_POSTFIX);
                }
            }
        }
        return erpMigrationNewTable;
    }

    /***
     * 获取ERP余额新表, 分库
     * @Date 2021-06-24 10:36
     * @author zhsy
     * @return ERP余额新表
     */
    public MetaTable getErpMigrationNewPreTable() {
        if (primaryType != DataObjectPrimaryType.ENTITY || secondaryType != DataObjectSecondaryType.MIGRATION) {
            return null;
        }

        if (null != mainTable && null == erpMigrationNewPreTable) {
            synchronized (this) {
                if (null == erpMigrationNewPreTable) {
                    erpMigrationNewPreTable = newErpKeysOtherTable(mainTable, MigrationAttributeDef.ERP_NEW_POSTFIX + "PRE");
                }
            }
        }
        return erpMigrationNewPreTable;
    }

    /**
     * 获取迁移表对应的增量表,仅在采用增量策略下才创建<br>
     * 增量表结构与迁移表相同，其中key加上后缀“_Delta”，数据库表名默认加上"_Delta"增量表只记录发生额<br>
     * 为增量表增加主键字段Delta_PK, Long类型
     * @return 获取迁移对应的增量表配置对象
     */
    public MetaTable getMigrationDeltaTable() {
        if (primaryType != DataObjectPrimaryType.ENTITY || secondaryType != DataObjectSecondaryType.MIGRATION
                || migrationUpdateStrategy != MigrationUpdateStrategyType.FOCUS_CHANGE) {
            return null;
        }
        if (mainTable != null && migrationDeltaTable == null) {
            synchronized (this) {
                if (migrationDeltaTable == null) {
                    migrationDeltaTable = (MetaTable)mainTable.clone();
                    migrationDeltaTable.setKey(mainTableKey + "_Delta");

                    String defaultDeltaDBName = mainTable.getBindingDBTableName() + "_Delta";
                    //Oracle表名限制在30个字符以内，如果默认表名超过30位，择取前29位
                    defaultDeltaDBName = defaultDeltaDBName.length() > 30 ? defaultDeltaDBName.substring(0, 29) : defaultDeltaDBName;
                    String dbName = StringUtil.isEmptyStr(migrationDeltaDBName) ? defaultDeltaDBName : migrationDeltaDBName;

                    migrationDeltaTable.setDBTableName(dbName);
                    //添加主键字段
                    MetaColumn column = new MetaColumn();
                    column.setKey(MigrationAttributeDef.DELTA_PK_COLUMN);
                    column.setDataType(DataType.LONG);
                    column.setPrimaryKey(true);
                    column.setAutoGen(true);
                    migrationDeltaTable.add(column);
                }
            }

        }
        return migrationDeltaTable;
    }

    /**
     * @return the migrationDeltaDBName
     */
    public String getMigrationDeltaDBName() {
        return migrationDeltaDBName;
    }

    /**
     * @param migrationDeltaDBName the migrationDeltaDBName to set
     */
    public void setMigrationDeltaDBName(String migrationDeltaDBName) {
        this.migrationDeltaDBName = migrationDeltaDBName;
    }

    public void setMigrationLastPointTable(MetaTable migrationLastPointTable) {
        this.migrationLastPointTable = migrationLastPointTable;
    }

    // ERP主键表和日志表 2020-11-10 zhsy
    public void setErpMigrationKeysTable(MetaTable erpMigrationKeysTable) {
        this.erpMigrationKeysTable = erpMigrationKeysTable;
    }

    public void setErpMigrationIncrTable(MetaTable erpMigrationIncrTable) {
        this.erpMigrationIncrTable = erpMigrationIncrTable;
    }

    // ERP主表新表和LP新表 2021-06-24 zhsy
    public void setErpMigrationNewTable(MetaTable erpMigrationNewTable) {
        this.erpMigrationNewTable = erpMigrationNewTable;
    }

    public void setErpMigrationLpNewTable(MetaTable erpMigrationLpNewTable) {
        this.erpMigrationLpNewTable = erpMigrationLpNewTable;
    }

    /**
     * 根据表标识返回表定义
     *
     * @param key
     *            表标识
     * @return 如果表集合中存在标识为key的定义则返回，否则返回null
     */
    public MetaTable getTable(String key) {
        return this.tableCollection != null ? this.tableCollection.get(key) : null;
    }

    public Integer getMigrationUpdateStrategy() {
        return migrationUpdateStrategy;
    }

    public void setMigrationUpdateStrategy(Integer migrationUpdateStrategy) {
        this.migrationUpdateStrategy = migrationUpdateStrategy;
    }

    /**
     * 为当前数据对象生成建表信息
     *
     * @return 数据库表信息列表
     */
    public ArrayList<MetaSchemaTable> getSchemeTableList() {
        if (tableCollection != null && getPrimaryType() == DataObjectPrimaryType.ENTITY) {
            SchemaCreator sc = new SchemaCreator(this);
            return sc.getSchemeTableList();
        } else
            return null;
    }

    /***
     * 获取更新策略为主键表策略的数据对象
     * @return MetaDataObject数据对象
     */
    public MetaDataObject getKeysMigrationDataObject() {
        SchemaCreator sc = new SchemaCreator(this);
        return sc.getKeysMigrationDataObject();
    }

    /***
     * 获取更新策略为主键表策略的主表表名
     * @return 主表表名
     */
    public String getKeysMigrationMainTableName() {
        SchemaCreator sc = new SchemaCreator(this);
        return sc.getKeysMigrationMainTableName();
    }

    /**
     * 为当前数据对象生成建立字典权限的建表信息
     * @return 数据库表信息列表
     */
    public ArrayList<MetaSchemaTable> getDictSchemeTableList() {
        if (tableCollection != null && getPrimaryType() == DataObjectPrimaryType.ENTITY) {
            SchemaCreator sc = new SchemaCreator(this);
            return sc.getDictSchemeTableList();
        } else
            return null;
    }

    /**
     * 取得表单权限数据库表信息
     * @return 数据库表信息
     */
    public MetaSchemaTable getFormRightsTable(){
        if (tableCollection != null && getPrimaryType() == DataObjectPrimaryType.ENTITY) {
            SchemaCreator sc = new SchemaCreator(this);
            return sc.getFormRightsTable();
        }
        return null;
    }

    /**
     * 设置IO工厂标识
     * @param IOProvider IO工厂标识
     */
    public void setIOProvider(String IOProvider) {
        this.IOProvider = IOProvider;
    }

    /**
     * 取得IO工厂标识
     * @return IO工厂标识
     */
    public String getIOProvider() {
        return this.IOProvider;
    }

    /**
     * 是否维护字典结构
     * @return 标志
     */
    public Boolean isMaintainDict(){
        return this.maintainDict;
    }

    /**
     * 设置是否维护字典结构
     * @param maintainDict 标志
     */
    public void setMaintainDict(Boolean maintainDict){
        this.maintainDict = maintainDict;
    }

    /**
     * 设置宏公式集合
     * @param macroCollection 宏公式集合
     */
    public void setMacroCollection(MetaMacroCollection macroCollection) {
        this.macroCollection = macroCollection;
    }

    /**
     * 取得宏公式集合
     * @return 宏公式集合
     */
    public MetaMacroCollection getMacroCollection() {
        return this.macroCollection;
    }

    /**
     * 设置命名处理
     * @param namedProcess 命名处理
     */
    public void setNamedProcess(MetaNamedProcess namedProcess) {
        this.namedProcess = namedProcess;
    }

    /**
     * 取得命名处理
     * @return 命名处理
     */
    public MetaNamedProcess getNamedProcess() {
        return this.namedProcess;
    }

    public String getRelateObjectKey() {
        return relateObjectKey;
    }

    public void setRelateObjectKey(String relateObjectKey) {
        this.relateObjectKey = relateObjectKey;
    }

    public Integer getZeroPrefix() {
        return zeroPrefix;
    }

    public void setZeroPrefix(Integer zeroPrefix) {
        this.zeroPrefix = zeroPrefix;
    }

    /**
     * 设置嵌入表集合
     * @param embedTables 嵌入表集合
     */
    public void setEmbedTables(MetaEmbedTableCollection embedTables) {
        this.embedTables = embedTables;
    }

    /**
     * 取得嵌入表集合
     * @return 嵌入表集合
     */
    public MetaEmbedTableCollection getEmbedTables() {
        return this.embedTables;
    }

    /**
     * 设置认证标志
     * @param authenticate 标志
     */
    public void setAuthenticate(Boolean authenticate) {
        this.authenticate = authenticate;
    }

    /**
     * 取得认证标志
     * @return 标志
     */
    public Boolean isAuthenticate() {
        return this.authenticate;
    }

    /**
     * 设置配置版本号
     * @param version 版本号
     */
    public void setVersion(Integer version){
        this.version = version;
    }

    /**
     * 获取配置版本号
     * @return 版本号
     */
    public Integer getVersion(){
        return this.version;
    }

    /**
     * 设置自定义字典查询
     * @param statement 字典自定义查询
     */
    public void setDictQueryStatement(MetaDictQueryStatement statement){
        this.dictQueryStatement = statement;
    }

    /**
     * 获取自定义字典查询
     * @return 自定义字典查询
     */
    public MetaDictQueryStatement getDictQueryStatement(){
        return this.dictQueryStatement;
    }

    private MetaTable newPeriodPointTable(MetaTable metaTable) {
        boolean isPeriodSum = false;
        for (MetaColumn column : metaTable) {
            if (column.isGroup() && column.getGroupType() == DataGroupGranularity.Period) {
                isPeriodSum = true;
                break;
            }
        }
        if (!isPeriodSum) {
            return null;
        }

        // KEYS_TABLE_FOCUS_CHANGE 根据PeriodGroup分组
        boolean isKTFocusChange = this.migrationUpdateStrategy == MigrationUpdateStrategyType.KEYS_TABLE_FOCUS_CHANGE;

        MetaTable LPTable = new MetaTable();
        LPTable.setKey(metaTable.getBindingDBTableName() + MigrationAttributeDef.POINT_POSTFIX);
        for (MetaColumn column : metaTable) {
            if (column.isGroup()) {
                // Discrete类型的分组列，不放到LP表中
                if (isKTFocusChange && column.getGroupType() == DataGroupGranularity.Discrete) {
                    continue;
                }
                MetaColumn clone = (MetaColumn) column.clone();
                if (column.getGroupType() == DataGroupGranularity.Period) {
                    clone.setGroupType(DataGroupGranularity.None);
                }
                LPTable.add(clone);
            }
        }
        LPTable.add(metaTable.getOIDColumn());
        LPTable.add(metaTable.getVERIDColumn());

        return LPTable;
    }

    /***
     * 创建ERP主键表
     * @Date 2020-11-10 14:00
     * @author zhsy
     * @param metaTable
     * @return ERP主键表
     */
    private MetaTable newErpKeysTable(MetaTable metaTable, String tableType) {
        MetaTable erpKeysTable = new MetaTable();
        erpKeysTable.setKey(StringUtil.strcat(metaTable.getBindingDBTableName(), tableType));
        String indexPrefix = metaTable.getIndexPrefix();
        if(indexPrefix != null && indexPrefix.length() > 0){
            erpKeysTable.setIndexPrefix(StringUtil.strcat(indexPrefix, tableType));
        }

        // 添加系统字段
        erpKeysTable.add(metaTable.getOIDColumn());
        erpKeysTable.add(metaTable.getVERIDColumn());

        List<MetaColumn> metaColumns = new ArrayList<>();
        // 添加分组字段
        for (MetaColumn column : metaTable) {
            if (column.isGroup()) {
                MetaColumn clone = (MetaColumn) column.clone();
                // 期间分组类型也是分组类型
                if (column.getGroupType() == DataGroupGranularity.Discrete
                        || column.getGroupType() == DataGroupGranularity.PeriodGroup) {
                    metaColumns.add(clone);
                }
            }
        }
        metaColumns.forEach(column -> erpKeysTable.add(column));
        // 如果分组字段大于16个，则增加一个汇总字段用来汇总15个字段后面的字段的值
        if (metaColumns.size() > BalanceGroupField.MYSQL_INDEX_MAX_LENGTH) {
            // 增加一个分组汇总列
            MetaColumn column = new MetaColumn();
            column.setKey(BalanceGroupField.GROUP_COUNT_FIELD);
            column.setCaption("分组汇总字段");
            column.setDataType(DataType.STRING);
            column.setLength(255);
            column.setGroupType(DataGroupGranularity.Discrete);
            erpKeysTable.add(column);
        }
        // 增加一个Hash列
        MetaColumn column = new MetaColumn();
        column.setKey(BalanceGroupField.HASH_CODE);
        column.setCaption("分组键组合后的hashCode值");
        column.setDataType(DataType.LONG);
//        column.setPrecision(22);
//        column.setLength(22);
//        column.setScale(0);
        erpKeysTable.add(column);

        return erpKeysTable;
    }

    /***
     * 创建ERP增量表策略其他表
     * @Date 2021-07-14
     * @author zhsy
     * @param metaTable 主表
     * @param tableType 表类型，如：增量表
     * @return ERP增量表策略其他表
     */
    private MetaTable newErpKeysOtherTable(MetaTable metaTable, String tableType) {
        MetaTable newTable = new MetaTable();
        newTable.setKey(StringUtil.strcat(metaTable.getBindingDBTableName(), tableType));
        String indexPrefix = metaTable.getIndexPrefix();
        if(indexPrefix != null && indexPrefix.length() > 0){
            newTable.setIndexPrefix(StringUtil.strcat(indexPrefix, tableType));
        }
        for (MetaColumn column : metaTable) {
            MetaColumn clone = (MetaColumn) column.clone();
            if (column.getGroupType() == DataGroupGranularity.Discrete) {
                continue;
            }
            // 是否为跳过列
            boolean isPassColumn = column.getBindingDBColumnName().equals(SystemField.SOID_SYS_KEY)
                    || column.getBindingDBColumnName().equals(SystemField.POID_SYS_KEY)
                    || column.getBindingDBColumnName().equals(SystemField.DVERID_SYS_KEY);
            if (isPassColumn) {
                continue;
            }
            // OID列，来自主表的OID，为了保留OID为主键的特性，其他列拷贝即可
            if (column.getBindingDBColumnName().equals(SystemField.OID_SYS_KEY)) {
                newTable.add(metaTable.getOIDColumn());
            } else {
                newTable.add(clone);
            }
        }

        // 增加一个GID列
        MetaColumn column = new MetaColumn();
        column.setKey(BalanceGroupField.GROUP_ID);
        column.setCaption("分组对象标志");
        column.setDataType(DataType.LONG);
        column.setAutoGen(true);
        newTable.add(column);
        return newTable;
    }

    private MigrationDatabjectParas migrationDatabjectParas = null;
    public MigrationDatabjectParas getMigrationDatabjectParas(IMetaFactory metaFactory) throws Throwable {
        if (migrationDatabjectParas == null) {
            synchronized (this) {
                if (migrationDatabjectParas == null)
                    migrationDatabjectParas = new MigrationDatabjectParas(metaFactory, this);
            }
        }

        return migrationDatabjectParas;
    }

    /** 迁移表中数据字段的赋值策略*/
    private Map<String, Integer> migrationDataColumnOpSignMap = null;

    public Map<String, Integer> getMigrationDataColumnOpSignMap() {
        return migrationDataColumnOpSignMap;
    }

    public void setMigrationDataColumnOpSignMap(Map<String, Integer> migrationDataColumnOpSignMap) {
        this.migrationDataColumnOpSignMap = migrationDataColumnOpSignMap;
    }

    /**
     * 计算迁移扩展属性
     * @param metaFactory 配置工厂
     * @throws Throwable 配置定义相关的错误
     */
    public void calcMigrationExtension(IMetaFactory metaFactory) throws Throwable {
        if (primaryType == DataObjectPrimaryType.ENTITY && secondaryType == DataObjectSecondaryType.MIGRATION) {
            MetaMigrationExtension migrationExtension = MigrationExtensionUtil.findMigrationExtension(metaFactory, this, this.key);
            if (migrationExtension == null) {
                return;
            }

            MetaColumn metaColumn = null;
            MetaTable mainTable = this.getMainTable();

            if (mainTable == null) {
                return;
            }

            Iterator<MetaColumn> it = mainTable.iterator();
            while(it.hasNext()) {
                metaColumn = it.next();
                if(metaColumn.getGroupType() == DataGroupGranularity.Discrete && !migrationExtension.isGroupField(metaColumn.getKey())) {
                    metaColumn.setGroupType(DataGroupGranularity.None);
                }
            }
        }
    }

    public Boolean isForbiddenSave() {
        return forbiddenSave;
    }

    public void setForbiddenSave(Boolean forbiddenSave) {
        this.forbiddenSave = forbiddenSave;
    }

    public Boolean isForbiddenLoad() {
        return forbiddenLoad;
    }

    public void setForbiddenLoad(Boolean forbiddenLoad) {
        this.forbiddenLoad = forbiddenLoad;
    }

    public Boolean isForbiddenDelete() {
        return forbiddenDelete;
    }

    public void setForbiddenDelete(Boolean forbiddenDelete) {
        this.forbiddenDelete = forbiddenDelete;
    }

    public boolean isProviderInit() {
        return providerInit;
    }

    public void setProviderInit(boolean providerInit) {
        this.providerInit = providerInit;
    }

    public boolean isAutoGen() {
        return autoGen;
    }

    public void setAutoGen(boolean autoGen) {
        this.autoGen = autoGen;
    }


    public Integer getLoadRightsType() {
        return loadRightsType;
    }

    public void setLoadRightsType(Integer loadRightsType) {
        this.loadRightsType = loadRightsType;
    }

    public String getGlobalRightFilter() {
        return globalRightFilter;
    }

    public void setGlobalRightFilter(String globalRightFilter) {
        this.globalRightFilter = globalRightFilter;
    }

    public Boolean isCheckAfterLoad() {
        return checkAfterLoad;
    }

    public void setCheckAfterLoad(Boolean checkAfterLoad) {
        this.checkAfterLoad = checkAfterLoad;
    }

    /**
     * 设置结转策略
     * @param s 结转策略
     */
    public void setRollDataStrategy(Integer s){
        this.rollDataStrategy = s;
    }

    /**
     * 获取结转策略
     * @return 结转策略
     */
    public Integer getRollDataStrategy(){
        return this.rollDataStrategy;
    }

    @Override
    public void merge(MetaDataObject dataObject) { // 以dataObject的事件为准

        for (MetaTable parentMetaTable : dataObject.tableCollection) {
            String parentTableKey = parentMetaTable.getKey();

            if (!tableCollection.containsKey(parentTableKey)) {
                // 当前没有时,继承父表单
                tableCollection.add(parentMetaTable);
            } else {
                // 当前表单中只允许新增字段
                MetaTable metaTable = tableCollection.get(parentTableKey);
                metaTable.merge(parentMetaTable);
            }
        }
        if (dataObject.checkRuleCollection != null && dataObject.checkRuleCollection.size() > 0) {
            if (this.checkRuleCollection == null || this.checkRuleCollection.size() == 0) {
                this.checkRuleCollection = dataObject.checkRuleCollection;
            } else {
                List<MetaCheckRule> metaCheckRuleList = this.checkRuleCollection.getList();
                List<Object> metaCheckRuleKeyList = metaCheckRuleList.stream().map(MetaCheckRule::getErrorInfo).collect(Collectors.toList());
                for (MetaCheckRule metaCheckRule : dataObject.checkRuleCollection) {
                    if (!metaCheckRuleKeyList.contains(metaCheckRule.getErrorInfo())) {
                        this.checkRuleCollection.add(metaCheckRule);
                    }
                }
            }

        }
        if (dataObject.embedTables != null && dataObject.embedTables.size() > 0) {
            if (this.embedTables == null || this.embedTables.size() == 0) {
                this.embedTables = dataObject.embedTables;
            } else {
                List<MetaEmbedTable> metaEmbedTableList = this.embedTables.getList();
                List<String> metaEmbedTableKeyList = metaEmbedTableList.stream().map(MetaEmbedTable::getTableKeys).collect(Collectors.toList());
                for (MetaEmbedTable embedTable : dataObject.embedTables) {
                    if (!metaEmbedTableKeyList.contains(embedTable.getTableKeys())) {
                        this.embedTables.add(embedTable);
                    }
                }
            }

        }

        if (dataObject.noPrefix != null) {
            this.noPrefix = dataObject.noPrefix;
        }
        if (dataObject.customNoPrefix != null) {
            this.customNoPrefix = dataObject.customNoPrefix;
        }
        if (dataObject.strDisplayColumns != null) {
            this.strDisplayColumns = dataObject.strDisplayColumns;
            if (this.getSecondaryType() == DataObjectSecondaryType.DICT
                    || this.getSecondaryType() == DataObjectSecondaryType.COMPDICT
                    || this.getSecondaryType() == DataObjectSecondaryType.CHAINDICT){
                this.getDisplayColumns().clear();
                this.displayColumns = null;
                this.getDisplayColumns();
            }
        }
        if (dataObject.strQueryColumns != null) {
            this.strQueryColumns = dataObject.strQueryColumns;
        }
        if (dataObject.strDropviewColumns != null) {
            this.strDropviewColumns = dataObject.strDropviewColumns;
        }
        if (dataObject.globalRightFilter != null) {
            this.globalRightFilter = dataObject.globalRightFilter;
        }
        if (dataObject.zeroPrefix != -1) {
            this.zeroPrefix = dataObject.zeroPrefix;
        }
        if (dataObject.loadRightsType != -1) {
            this.loadRightsType = dataObject.loadRightsType;
        }
        if (dataObject.checkAfterLoad != null) {
            this.checkAfterLoad = dataObject.checkAfterLoad;
        }
        if (dataObject.authenticate != null) {
            this.authenticate = dataObject.authenticate;
        }
        if (dataObject.caption != null) {
        	this.caption = dataObject.caption;
        }
        //马甲合并后需要重新生成
        this.erpMigrationKeysTable = null;
        this.erpMigrationIncrTable = null;
        this.erpMigrationNewTable = null;
        this.migrationDatabjectParas = null;
        this.migrationDeltaTable = null;
        this.migrationLastPointTable = null;
    }

    /**
     * 取得是否维护数据库
     *
     * @return 是否维护数据库
     */
    public Boolean isMaintainSchema() {
        return maintainSchema;
    }

    /**
     * 设置是否维护数据库
     *
     * @param maintainSchema
     *            是否维护数据库
     */
    public void setMaintainSchema(Boolean maintainSchema) {
        this.maintainSchema = maintainSchema;
    }

    /**
     * 检查热更新前后数据对象的表结构是否发生变化，并获取需要更新的表集合
     * @param oldObj 更新前的数据对象
     * @param dict 是否字典标志
     * @return 需要进行数据库维护的表集合
     */
    public List<MetaSchemaTable> compareAndGet(MetaDataObject oldObj, boolean dict) {
        //如果版本相同，则直接返回null
//		if (oldObj != null && oldObj.version == this.version) {
//			return null;
//		}

        if (oldObj == null) {
            return dict ? getDictSchemeTableList() : getSchemeTableList();
        }

        List<MetaSchemaTable> tableList = new ArrayList<>();
        if (this.getKey().equals(oldObj.getKey())) {
            Map<String, MetaSchemaTable> oldTableMap = oldObj.getSchemaTableMap(dict);
            Map<String, MetaSchemaTable> newTableMap = this.getSchemaTableMap(dict);
            for (Entry<String, MetaSchemaTable> entry : newTableMap.entrySet()) {
                if (oldTableMap.containsKey(entry.getKey())) {
                    MetaSchemaTable oldTable = oldTableMap.get(entry.getKey());
                    MetaSchemaTable newTable = entry.getValue();
                    if (newTable.compare(oldTable)) {
                        tableList.add(newTable);
                    }
                }else {
                    tableList.add(entry.getValue());
                }
            }
        }
        return tableList;
    }

    public Map<String, MetaSchemaTable> getSchemaTableMap(boolean dict){
        Map<String, MetaSchemaTable> tableMap = new HashMap<String, MetaSchemaTable>();
        List<MetaSchemaTable> tableList = null;
        if (dict) {
            tableList = getDictSchemeTableList();
        }else {
            tableList = getSchemeTableList();
        }
        if (tableList != null) {
            for (MetaSchemaTable schemaTable : getSchemeTableList()) {
                tableMap.put(schemaTable.getKey(), schemaTable);
            }
        }
        return tableMap;
    }
    /**
     * 比较热更新前后数据权限对象表
     * @param oldObj
     * @return
     */
    public MetaSchemaTable compareAndGetFormRights(MetaDataObject oldObj) {
        // 如果版本相同，则直接返回null
//		if (oldObj != null && oldObj.version == this.version) {
//			return null;
//		}

        boolean change = false;
        if (oldObj == null) {
            change = true;
        }

        if (this.getKey().equals(oldObj.getKey())) {
            String newMainKey = this.getMainTableKey();
            String oldMainKey = oldObj.getMainTableKey();
            if (!newMainKey.equals(oldMainKey)) {
                change = true;
            }
        }


        if (change && tableCollection != null && getPrimaryType() == DataObjectPrimaryType.ENTITY) {
            SchemaCreator sc = new SchemaCreator(this);
            return sc.getFormRightsTable();
        }

        return null;
    }

    /**
     * 获取字典缓存检查策略
     * @return 字典缓存检查策略
     */
    public Integer getDictCacheCheckMode() {
        return dictCacheCheckMode;
    }

    /**
     * 设置字典缓存检查策略
     * @param dictCacheCheckMode 字典缓存检查策略
     */
    public void setDictCacheCheckMode(Integer dictCacheCheckMode) {
        this.dictCacheCheckMode = dictCacheCheckMode;
    }
    
    /**
     * 获取字典显示编码
     * @return 显示编码
     */
    public String getShowCode() {
    	return this.showCode;
    }
}