package com.bokesoft.yigo.meta.datamigration;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaDMTargetField定义迁移的目标字段，只需要定义目标字段的标识。
 * @author 王元和
 * @since YES 1.0
 */
public class MetaDMTargetField extends KeyPairMetaObject {
	/** 目标字段标识 */
	private String fieldKey = null;
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "TargetField";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}
	
	/**
	 * 设置字段标识
	 * @param fieldKey 字段标识
	 * @see #fieldKey
	 */
	public void setFieldKey(String fieldKey) {
		this.fieldKey = fieldKey;
	}
	
	/**
	 * 取得字段标识
	 * @return 字段标识
	 * @see #fieldKey
	 */
	public String getFieldKey() {
		return this.fieldKey;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaDMTargetField newTargetField = new MetaDMTargetField();
		newTargetField.setFieldKey(fieldKey);
		return newTargetField;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return new MetaDMTargetField();
	}

	@Override
	public String getKey() {
		return fieldKey;
	}
}
