package com.bokesoft.yigo.meta.datamigration;

/**
 * 期间值计算方式
 * @author 王元和
 *
 */
public class DMPeriodValuePeekType {
	/** 默认 */
	public static final int Default = 0;
	public static final String STR_Default = "Default";
	
	/** 字段值 */
	public static final int Value = 1;
	public static final String STR_Value = "Value";
	
	/** 值映射 */
	public static final int Map = 2;
	public static final String STR_Map = "Map";

	public static int parse(String s) {
		int type = -1;
		if ( STR_Default.equalsIgnoreCase(s) ) {
			type = Default;
		} else if ( STR_Value.equalsIgnoreCase(s) ) {
			type = Value;
		} else if ( STR_Map.equalsIgnoreCase(s) ) {
			type = Map;
		}
		return type;
	}
	
	public static String toString(Integer type) {
		if(type == null)
			return "";
		
		String s = "";
		switch ( type ) {
		case Default:
			s = STR_Default;
			break;
		case Value:
			s = STR_Value;
			break;
		case Map:
			s = STR_Map;
			break;
		}
		return s;
	}
}
