package com.bokesoft.yigo.meta.datamap.target;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 映射目标表集合
 * 
 * @author Administrator
 *
 */
public class MetaTargetTableCollection extends GenericKeyCollection<MetaTargetTable> {

	/** 水平位置 */
	private Integer x = -1;
	/** 垂直位置 */
	private Integer y = -1;
	/** 宽度 */
	private Integer width = -1;
	/** 高度 */
	private Integer height = -1;

	/** 标签名 */
	public static final String TAG_NAME = "TargetTableCollection";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	public void setX(Integer x) {
		this.x = x;
	}

	public Integer getX() {
		return this.x;
	}

	public void setY(Integer y) {
		this.y = y;
	}

	public Integer getY() {
		return this.y;
	}

	public void setWidth(Integer width) {
		this.width = width;
	}

	public Integer getWidth() {
		return this.width;
	}

	public void setHeight(Integer height) {
		this.height = height;
	}

	public Integer getHeight() {
		return this.height;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		if (MetaTargetTable.TAG_NAME.equals(tagName)) {
			MetaTargetTable table = new MetaTargetTable();
			table.preProcessMetaObject(env, doc, node, flag, runType);
			add(table);
			return table;
		}
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTargetTableCollection newObject = (MetaTargetTableCollection) super.clone();
		newObject.setX(x);
		newObject.setY(y);
		newObject.setWidth(width);
		newObject.setHeight(height);

		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTargetTableCollection();
	}

}
