package com.bokesoft.yigo.meta.datamap.source;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 源数据表对象
 * 
 * @author 刘翔翔
 *
 */
public class MetaSourceTable extends GenericNoKeyCollectionWithKey<MetaSourceField> {

	/** 标签名 */
	public static final String TAG_NAME = "SourceTable";
	/** 源数据表的标识 */
	private String key = "";
	/** 是否为主表 */
	private Boolean isPrimary = false;
	/** 数据映射目标表 */
	private String targetTableKey = "";
	/** 表的映射条件 */
	private String condition = "";

	@Override
	public String getKey() {
		return key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject child = null;
		if (MetaSourceField.TAG_NAME.equals(tagName)) {
			child = new MetaSourceField();
			add((MetaSourceField) child);
			child.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return child;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSourceTable();
	}

	public Boolean isPrimary() {
		return isPrimary;
	}

	public void setPrimary(Boolean isPrimary) {
		this.isPrimary = isPrimary;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getTargetTableKey() {
		return targetTableKey;
	}

	public void setTargetTableKey(String targetTableKey) {
		this.targetTableKey = targetTableKey;
	}

	public String getCondition() {
		return condition;
	}

	public void setCondition(String condition) {
		this.condition = condition;
	}
	
	@Override
	public AbstractMetaObject clone() {
	// TODO Auto-generated method stub
		MetaSourceTable newSourceTable = (MetaSourceTable) super.clone();
		newSourceTable.setKey(key);
		newSourceTable.setPrimary(isPrimary);
		newSourceTable.setTargetTableKey(targetTableKey);
		newSourceTable.setCondition(condition);
		return newSourceTable;
	}
}
