package com.bokesoft.yigo.meta.datamap.diagram;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaFeedbackObject extends GenericKeyCollectionWithKey<MetaFeedbackTable> {
	/** 水平位置 */
	private Integer x = -1;
	/** 垂直位置 */
	private Integer y = -1;
	/** 宽度 */
	private Integer width = -1;
	/** 高度 */
	private Integer height = -1;

	/** 对象标识 */
	private String key = "";

	public MetaFeedbackObject() {
		super();
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "FeedbackObject";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	/**
	 * 设置对象标识
	 * 
	 * @param key
	 *            对象标识
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 取得对象标识
	 * 
	 * @return 对象标识
	 */
	public String getKey() {
		return this.key;
	}

	public Integer getX() {
		return x;
	}

	public void setX(Integer x) {
		this.x = x;
	}

	public Integer getY() {
		return y;
	}

	public void setY(Integer y) {
		this.y = y;
	}

	public Integer getWidth() {
		return width;
	}

	public void setWidth(Integer width) {
		this.width = width;
	}

	public Integer getHeight() {
		return height;
	}

	public void setHeight(Integer height) {
		this.height = height;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaFeedbackTable.TAG_NAME.equals(tagName)) {
			MetaFeedbackTable feedbackTable = new MetaFeedbackTable();
			feedbackTable.preProcessMetaObject(env, doc, node, flag, runType);
			add(feedbackTable);
			resultMetaObject = feedbackTable;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFeedbackObject();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaFeedbackObject newObject = (MetaFeedbackObject) super.clone();
		newObject.setKey(key);
		newObject.setX(x);
		newObject.setY(y);
		newObject.setWidth(width);
		newObject.setHeight(height);
		return newObject;
	}
}
