package com.bokesoft.yigo.meta.datamap.calculate;

import java.util.ArrayList;
import java.util.HashMap;

import com.bokesoft.yes.common.util.ConstUtil;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.datamap.MetaMap;
import com.bokesoft.yigo.meta.datamap.source.FieldType;
import com.bokesoft.yigo.meta.datamap.source.MetaSourceField;
import com.bokesoft.yigo.meta.datamap.source.MetaSourceTable;
import com.bokesoft.yigo.meta.datamap.target.MetaFeedback;
import com.bokesoft.yigo.meta.datamap.target.MetaTargetField;
import com.bokesoft.yigo.meta.datamap.target.MetaTargetTable;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;

/**
 * 解析之后的映射设置
 * 
 * @author 刘翔翔
 *
 */
public class MetaMapParas {

	/** 映射的KEY */
	private MetaMap meta;

	/** 映射的KEY */
	private String key;

	/** 关注字段 */
	private MetaSourceField focusField;

	/** 关注字段指向的目标字段的数据类型 */
	private Integer tgtFocusFieldDataType;

	/** 关系Key字段 */
	private MetaSourceField mapKeyField;

	/** 主源表的KEY */
	private String primarySourceTableKey;

	/** 主源表的KEY */
	private String primaryTgtTableKey;

	/** 关注字段所在的主映射边 */
	private MetaMapEdge primaryMapEdge;

	/** 关联主表的参数 */
	private HashMap<String, RefFieldMap> refFieldMap = new HashMap<String, RefFieldMap>();

	/** 源单的计算中涉及到的所有头表 */
	private ArrayList<String> sourceHeadTableList = new ArrayList<String>();

	/** 目标单的所有头表 */
	private ArrayList<String> targetHeadTableList = new ArrayList<String>();

	/** 拥有关联关系 */
	private boolean needMapValue = false;

	/** 负向 */
	private boolean isNegtive = false;

	public MetaMapParas(MetaMap meta, IMetaFactory factory) throws Throwable {
		this.meta = meta;
		logicCheck(meta);
		key = meta.getKey();
		MetaDataObject srcDataObject = factory.getDataObject(meta.getSrcDataObjectKey());
		MetaDataObject tgtDataObject = factory.getDataObject(meta.getTgtDataObjectKey());

		if (srcDataObject == null)
			throw new MetaException(MetaException.NO_DATAOBJECT_DEFINED, SimpleStringFormat.format(StringTable.getString(null, "", StringTable.NoDataObjectDefined), meta.getSrcDataObjectKey()));

		if (tgtDataObject == null)
			throw new MetaException(MetaException.NO_DATAOBJECT_DEFINED, SimpleStringFormat.format(StringTable.getString(null, "", StringTable.NoDataObjectDefined), meta.getTgtDataObjectKey()));

		// 定位特殊字段
		for (MetaSourceTable table : meta.getSourceTableCollection()) {
			if (table.isPrimary()) {
				primarySourceTableKey = table.getKey();
				primaryTgtTableKey = table.getTargetTableKey();
				for (MetaSourceField field : table) {
					if (field.getEdgeType() == FieldType.EDGE_FOCUS) {
						focusField = field;
						isNegtive = focusField.isNegtive();
						tgtFocusFieldDataType = tgtDataObject.getMetaTable(primaryTgtTableKey).get(field.getTargetFieldKey()).getDataType();
					}

					if (field.getEdgeType() == FieldType.EDGE_MAP_KEY) {
						mapKeyField = field;
						Integer dataType = DataType.STRING;
						// mapKey字段的预处理只能单独做
						if (field.getType() == FieldType.CONST) {
							field.setConstValue(ConstUtil.getValue(field.getDefinition(), dataType));
						} else if (field.getType() == FieldType.FIELD) {
							Integer srcDataType = srcDataObject.getMetaTable(table.getKey()).get(field.getDefinition()).getDataType();
							if (!srcDataType.equals(dataType)) {
								field.setNeedTypeConvert(true);
								field.setTargetFieldDataType(dataType);
							}
						} else {
							field.setNeedTypeConvert(true);
							field.setTargetFieldDataType(dataType);
						}
					}
				}
			}
		}

		// 移除冗余内容
		ArrayList<MetaSourceTable> reomveEmptyTables = new ArrayList<MetaSourceTable>();
		for (MetaSourceTable table : meta.getSourceTableCollection()) {
			RefFieldMap map = refFieldMap.get(table.getKey());
			// MetaTable metaTable =
			// tgtDataObject.getMetaTable(table.getTargetTableKey());
			ArrayList<MetaSourceField> reomveEmptyColumns = new ArrayList<MetaSourceField>();

			for (MetaSourceField sourceField : table) {
				// 关联字段的特殊处理
				if (sourceField.getRefFieldKey() != null && sourceField.getRefFieldKey().length() > 0) {
					if (map == null) {
						map = new RefFieldMap(table.getKey());
						refFieldMap.put(table.getKey(), map);
					}
					map.add(sourceField.getDefinition(), sourceField.getRefFieldKey());
				}

				// 边类型不明确的，移除
				if (sourceField.getEdgeType() < 0) {
					reomveEmptyColumns.add(sourceField);
					continue;
				}

				if (sourceField.getTargetTableKey() == null || sourceField.getTargetTableKey().length() == 0)
					sourceField.setTargetTableKey(table.getTargetTableKey());
				// 目标表、字段未设置的（关联字段除外），移除
				if (sourceField.getTargetTableKey() == null || sourceField.getTargetTableKey().length() == 0 || sourceField.getTargetFieldKey() == null || sourceField.getTargetFieldKey().length() == 0) {
					reomveEmptyColumns.add(sourceField);
					continue;
				}

				// 目标字段不存在，报错
				MetaTable metaTable = tgtDataObject.getMetaTable(sourceField.getTargetTableKey());
				if (metaTable == null) {
					throw new MetaException(MetaException.MAP_TARGET_TABLE_MISS, SimpleStringFormat.format(StringTable.getString(null, "", StringTable.MapTargetTableMiss), sourceField.getTargetFieldKey(), table.getTargetTableKey()));
				} else {
					MetaColumn metaField = metaTable.get(sourceField.getTargetFieldKey());
					if (metaField == null) {
						throw new MetaException(MetaException.MAP_TARGET_FIELD_MISS, SimpleStringFormat.format(StringTable.getString(null, "", StringTable.MapTargetFieldMiss), sourceField.getTargetFieldKey(), table.getTargetTableKey()));
					}
				}
			}
			for (MetaSourceField f : reomveEmptyColumns)
				table.remove(f);
			if (!table.isPrimary() && table.size() == 0) {
				reomveEmptyTables.add(table);
				refFieldMap.remove(table.getKey());
			}
		}
		// 移除空白的表格
		for (MetaSourceTable t : reomveEmptyTables)
			meta.getSourceTableCollection().remove(t.getKey());

		// 查找头表
		for (MetaTable table : srcDataObject.getTableCollection())
			if (table.getTableMode() == TableMode.HEAD && meta.getSourceTable(table.getKey()) != null)
				sourceHeadTableList.add(table.getKey());
		for (MetaTable table : tgtDataObject.getTableCollection())
			if (table.getTableMode() == TableMode.HEAD && meta.getTargetTableCollection().get(table.getKey()) != null)
				targetHeadTableList.add(table.getKey());

		needMapValue = (mapKeyField != null || focusField != null) && meta.getMapRelationValue();

		// 计算映射边
		primaryMapEdge = getNewEdge(meta, primarySourceTableKey, srcDataObject, tgtDataObject);
		HashMap<String, MetaMapEdge> edgeMap = new HashMap<String, MetaMapEdge>();
		edgeMap.put(primarySourceTableKey, primaryMapEdge);
		boolean needContinue;
		do {
			needContinue = false;
			for (MetaTable table : srcDataObject.getTableCollection()) {
				String parentKey = table.getLevelID() == 2 ? srcDataObject.getMainTableKey() : table.getParentKey();
				MetaMapEdge parentEdge = edgeMap.get(parentKey);
				MetaMapEdge edge = edgeMap.get(table.getKey());
				if (parentEdge != null && edge == null && meta.getSourceTable(table.getKey()) != null) {
					edge = getNewEdge(meta, table.getKey(), srcDataObject, tgtDataObject);
					parentEdge.putChildEdgeList(edge);
					edgeMap.put(edge.getSourceTableKey(), edge);
					if (table.getLevelID() == 2)
						edge.setMainTableParent(true);
					needContinue = true;
				}
			}
		} while (needContinue);

		// 查找关联字段
		for (MetaSourceTable table : meta.getSourceTableCollection()) {
			for (MetaSourceField field : table) {
				if (field.getTargetTableKey() == null || field.getTargetTableKey().length() == 0)
					field.setTargetTableKey(table.getTargetTableKey());

				if (field.getTargetFieldKey() == null || field.getTargetFieldKey().length() == 0)
					continue;
				// 源值部分的预处理
				MetaColumn column = tgtDataObject.getMetaTable(field.getTargetTableKey()).get(field.getTargetFieldKey());
				field.setTargetFieldAccessControl(column.isAccessControl());
				Integer dataType = column.getDataType();
				if (field.getType() == FieldType.CONST) {
					field.setConstValue(ConstUtil.getValue(field.getDefinition(), dataType));
				} else if (field.getType() == FieldType.FIELD) {
					Integer srcDataType = srcDataObject.getMetaTable(table.getKey()).get(field.getDefinition()).getDataType();
					if (!srcDataType.equals(dataType)) {
						field.setNeedTypeConvert(true);
						field.setTargetFieldDataType(dataType);
					}
				} else {
					field.setNeedTypeConvert(true);
					field.setTargetFieldDataType(dataType);
				}
			}
		}

		// 预处理反填的内容
		for (MetaTargetTable table : meta.getTargetTableCollection()) {
			for (MetaTargetField field : table) {
				for (MetaFeedback fb : field) {
					MetaColumn tgtField = factory.getDataObject(fb.getDataObjectKey()).getMetaTable(fb.getTableKey()).get(fb.getFieldKey());
					fb.setTargetFieldDataType(tgtField.getDataType());
					if (field.getType() == FieldType.CONST) {
						fb.setConstValue(ConstUtil.getValue(field.getDefinition(), tgtField.getDataType()));
					} else if (field.getType() == FieldType.FIELD) {
						MetaColumn src = tgtDataObject.getMetaTable(table.getKey()).get(field.getDefinition());
						if (src.getDataType() != tgtField.getDataType()) {
							fb.setNeedTypeConvert(true);
						}
					} else {
						fb.setNeedTypeConvert(true);
					}

					if (fb.getPostTrigger() != null) {
						String path = fb.getPostTrigger().getContent().trim();
						if (path != null && path.length() > 0) {
							fb.setPostClassPath(path);
						}
					}
				}
			}

		}
	}

	public static void logicCheck(MetaMap meta) throws Throwable {
		if (meta.getAllowSurplus() && (meta.getMaxPushValue() == null || meta.getMaxPushValue().length() == 0)) {
			throw new MetaException(MetaException.MAX_PUSH_VALUE_UNDIFINED, SimpleStringFormat.format(StringTable.getString(null, "", StringTable.MaxPushValueUndefined), meta.getKey()));
		}
	}

	/**
	 * 创建一个映射边对象
	 * 
	 * @param sourceTableKey
	 * @return
	 */
	private MetaMapEdge getNewEdge(MetaMap meta, String sourceTableKey, MetaDataObject srcDataObject, MetaDataObject tgtDataObject) {
		MetaMapEdge edge = new MetaMapEdge(sourceTableKey);
		edge.searchEdgeMap(meta, srcDataObject, tgtDataObject);
		return edge;
	}

	public MetaMapEdge getPrimaryMapEdge() {
		return primaryMapEdge;
	}

	public String getKey() {
		return key;
	}

	public HashMap<String, RefFieldMap> getRefFieldMap() {
		return refFieldMap;
	}

	public String getPrimarySourceTableKey() {
		return primarySourceTableKey;
	}

	public MetaSourceField getFocusField() {
		return focusField;
	}

	public String getPrimaryTgtTableKey() {
		return primaryTgtTableKey;
	}

	public ArrayList<String> getSourceHeadTableList() {
		return sourceHeadTableList;
	}

	public ArrayList<String> getTargetHeadTableList() {
		return targetHeadTableList;
	}

	public MetaMap getMeta() {
		return meta;
	}

	public MetaSourceField getMapKeyField() {
		return mapKeyField;
	}

	public boolean isNeedMapValue() {
		return needMapValue;
	}

	public Integer getTgtFocusFieldDataType() {
		return tgtFocusFieldDataType;
	}

	public boolean isNegtive() {
		return isNegtive;
	}

	public void setNegtive(boolean isNegtive) {
		this.isNegtive = isNegtive;
	}

}
