package com.bokesoft.yigo.meta.commondef;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaStatus定义数据对象中的状态集合，包括状态的标识、名称以及值(整型)
 * 
 * @author 王元和
 *
 */
public class MetaStatus extends KeyPairMetaObject {

	public static final String TAG_NAME = "Status";

	/** 状态标识 */
	private String key = "";
	/** 状态名称 */
	private String caption = "";
	/** 状态值 */
	private Integer value = -1;
	/** 是否独立状态。在表单中该属性有效，表示定义自己独立的状态定义，即使在全局定义中存在，也使用自身的属性 */
	private Boolean standalone = false;

	public MetaStatus() {
		super();
	}

	/**
	 * 设置状态标识
	 * 
	 * @param key
	 *            状态标识
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 取得状态标识
	 */
	@Override
	public String getKey() {
		return key;
	}

	/**
	 * 设置状态名称
	 * 
	 * @param caption
	 *            状态名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}

	/**
	 * 取得状态名称
	 * 
	 * @return 状态名称
	 */
	public String getCaption() {
		return this.caption;
	}

	/**
	 * 设置状态值
	 * 
	 * @param value
	 *            状态值
	 */
	public void setValue(Integer value) {
		this.value = value;
	}

	/**
	 * 取得状态值
	 * 
	 * @return 状态值
	 */
	public Integer getValue() {
		return this.value;
	}

	/**
	 * 设置是否独立状态
	 * 
	 * @param standalone
	 *            标志
	 */
	public void setStandalone(Boolean standalone) {
		this.standalone = standalone;
	}

	/**
	 * 取是否独立状态标志
	 * 
	 * @return 标志
	 */
	public Boolean isStandalone() {
		return this.standalone;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaStatus newObject = new MetaStatus();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setValue(value);
		newObject.setStandalone(standalone);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaStatus();
	}

}
