package com.bokesoft.yigo.meta.common;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaCustomDataItem为自定义数据项，以[key,value]形式定义
 * @author wangyh
 *
 */
public class MetaCustomDataItem extends KeyPairMetaObject {
	/** 标识 */
	private String key = "";
	/** 值 */
	private String value = "";
	public MetaCustomDataItem() {
		super();
	}
	
	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	@Override
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置值
	 * @param value 值
	 */
	public void setValue(String value) {
		this.value = value;
	}
	
	/**
	 * 取得值
	 * @return 值
	 */
	public String getValue() {
		return this.value;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	public static final String TAG_NAME = "CustomDataItem";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaCustomDataItem newObject = (MetaCustomDataItem)newInstance();
		newObject.setKey(key);
		newObject.setValue(value);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCustomDataItem();
	}

}
