package com.bokesoft.yigo.meta.common;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;


/**
 * MetaCustomData定义二次开发者在配置对象中增加的自定义数据集合，以[key,value]形式存储
 * @author 王元和
 * @since YES 1.0
 */
public class MetaCustomData extends GenericKeyCollection<MetaCustomDataItem> {
	public MetaCustomData() {
		super();
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "CustomData";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaCustomDataItem.TAG_NAME.equals(tagName) ) {
			MetaCustomDataItem customDataItem = new MetaCustomDataItem();
			customDataItem.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(customDataItem);
			resultMetaObject = customDataItem;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCustomData();
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		// TODO
	}
}
