package com.bokesoft.yigo.meta.charging;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaChargingRuleGroup定义计费规则组，每个组由多个计费规则组成，计算过程中对每个计费对象只计算第一个满足条件规则
 * @author wangyh
 *
 */
public class MetaChargingRuleGroup extends AbstractMetaObject {
	/** 标识 */
	private String key = "";
	/** 名称 */
	private String caption = "";
	/** 描述 */
	private String description = "";
	/** 规则集合 */
	private MetaChargingRuleCollection rules = null;
	/** 参数集合 */
	private MetaChargingParaCollection paras = null;
	/** 计费目标 */
	private MetaChargingTargetObject target = null;
	
	public MetaChargingRuleGroup() {
		super();
		this.paras = new MetaChargingParaCollection();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		this.addAll2(list, rules, paras);
	}

	public static final String TAG_NAME = "ChargingRuleGroup";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaChargingRuleCollection.TAG_NAME.equals(tagName) ) {
			this.rules = new MetaChargingRuleCollection();
			resultMetaObject = this.rules;
		} else if ( MetaChargingPara.TAG_NAME.equals(tagName) ) {
			MetaChargingPara para = new MetaChargingPara();
			paras.add(para);
			resultMetaObject = para;
		} else if ( MetaChargingTargetObject.TAG_NAME.equals(tagName) ) {
			this.target = new MetaChargingTargetObject();
			resultMetaObject = this.target;
		}
		return resultMetaObject;
	}
	
	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得标识
	 * @return 标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得名称
	 * @return 名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	/**
	 * 设置描述
	 * @param description 描述
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * 取得描述
	 * @return 描述
	 */
	public String getDescription() {
		return this.description;
	}
	
	/**
	 * 设置规则集合
	 * @param rules 规则集合
	 */
	public void setRules(MetaChargingRuleCollection rules) {
		this.rules = rules;
	}
	
	/**
	 * 取得规则集合
	 * @return 规则集合
	 */
	public MetaChargingRuleCollection getRules() {
		return this.rules;
	}
	
	/**
	 * 设置参数集合
	 * @param paras 参数集合
	 */
	public void setParas(MetaChargingParaCollection paras) {
		this.paras = paras;
	}
	
	/**
	 * 取得参数集合
	 * @return 参数集合
	 */
	public MetaChargingParaCollection getParas() {
		return this.paras;
	}
	
	/**
	 * 设置目标
	 * @param target 目标
	 */
	public void setTarget(MetaChargingTargetObject target) {
		this.target = target;
	}
	
	/**
	 * 取得目标
	 * @return 目标
	 */
	public MetaChargingTargetObject getTarget() {
		return this.target;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaChargingRuleGroup newObject = (MetaChargingRuleGroup)newInstance();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setDescription(description);
		newObject.setRules(rules == null ? null : (MetaChargingRuleCollection)rules.clone());
		newObject.setParas(paras == null ? null : (MetaChargingParaCollection)paras.clone());
		newObject.setTarget(target == null ? null : (MetaChargingTargetObject)target.clone());
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaChargingRuleGroup();
	}

}
