package com.bokesoft.yigo.meta.charging;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.charging.MetaChargingObjectProfile;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaChargingObjectList extends GenericKeyCollection<MetaChargingObjectProfile> implements IElementMerge<MetaChargingObjectList>
{

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "ChargingObjectList";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaChargingObjectList();
	}

	@Override
	public MetaChargingObjectList toMerge(MetaChargingObjectList obj) {
		if (obj != null) {
			Iterator<MetaChargingObjectProfile> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaChargingObjectProfile metaChargingObjectProfile = (MetaChargingObjectProfile) iterator.next();
				if (containsKey(metaChargingObjectProfile.getKey())) {
					throw new MetaException(MetaException.REPEAT_BIZ_EXTEND_DEFINED,
							SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.RepeatBizExtendDefined),
									metaChargingObjectProfile.getProject().getKey(), metaChargingObjectProfile.getKey()));
				}
				add(metaChargingObjectProfile);
			}
		}
		return this;
	}

}
