package com.bokesoft.yigo.meta.calendar;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 节日设置
 * 
 * @author 刘翔翔
 *
 */
public class MetaVacation extends GenericNoKeyCollection<MetaDay> {

	public static final String TAG = "Vacation";

	/** 中文名称 */
	private String caption = "";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		MetaDay amo = null;
		if (tagName.equalsIgnoreCase(MetaDay.TAG)) {
			amo = new MetaDay();
			amo.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(amo);
		}
		return amo;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaVacation();
	}

	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}
}
