package com.bokesoft.yigo.meta.bpm.process.perm.extend;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.process.monitor.MetaMonitorCollection;

public class MetaPermConfiguration extends AbstractMetaObject {

	public static final String TAG_NAME = "PermConfiguration";
	
	private MetaExternalPermCollection externalPermCollection = null;
	
	public void setExternalPermCollection(MetaExternalPermCollection externalPermCollection) {
		this.externalPermCollection = externalPermCollection;
	}
	
	public MetaExternalPermCollection getExternalPermCollection() {
		return externalPermCollection;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] {externalPermCollection});

	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaExternalPermCollection.TAG_NAME.equals(tagName)) {
			externalPermCollection = new MetaExternalPermCollection();
			resultMetaObject = externalPermCollection;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaPermConfiguration meta = new MetaPermConfiguration();
		meta.setExternalPermCollection(externalPermCollection == null ? null : (MetaExternalPermCollection)externalPermCollection.clone());
		return meta;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaPermConfiguration();
	}

}
