package com.bokesoft.yigo.meta.bpm.process.perm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;

public abstract class MetaItem extends KeyPairMetaObject {

	private String key = "";

	@Override
	public final String getKey() {
		return key;
	}

	public final void setKey(String key) {
		this.key = key;
	}
	
	@Override
	public JSONObject toJSON() throws SerializationException {
		JSONObject obj = new JSONObject();
		obj.put("tag-name", getTagName());
		obj.put("key", key);
		return obj;
	}
	
	@Override
	public void fromJSON(JSONObject json) throws SerializationException {
		key = json.optString("key");
	}

}
