package com.bokesoft.yigo.meta.bpm.process.node;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yigo.common.def.BPMLockType;
import com.bokesoft.yigo.common.def.DocRefType;
import com.bokesoft.yigo.common.def.NodePattern;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.AbstractBPMElement;
import com.bokesoft.yigo.meta.bpm.process.attachment.MetaNodeAttachment;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaNodeGraphic;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaPreCondition;
import com.bokesoft.yigo.meta.bpm.process.data.MetaDataSpecification;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaTransitionCollection;

/**
 * 业务流程的节点抽象基类，包含节点的通用属性属性。
 * 
 * @author 刘翔翔
 * 
 */
public abstract class MetaNode extends AbstractBPMElement {

	/** 节点所在的流程的标识 */
	private String BPMKey = "";

	/** 节点是否被启用 */
	private Boolean inUse = true;
	
	/** 标签*/
	private String tag = "";
	
	/** 用户数据*/
	private String userData = "";

	/** 节点产生的工作项是否可以撤销 */
	private Boolean workitemRevoke = true;
	
	/** 节点工作项撤销条件*/
	private String revokeCondition = "";

	/** 撤销工作项通用名称 */
	private String retreatCaption = "";

	/** 节点模板的KEY */
	private String templateKey = "";
	
	/** 流程自有状态节点状态定义*/
	private Integer bpmState = -1;
	
	/** 节点撤销事件*/
	private String revokeTrigger = "";
	
	/** 单据引用*/
	private String refDocKey = "";
	/** 默认新增类型*/
	private Integer refType = DocRefType.NEW;
	
	/** 工作项模式 */
	private String pattern = NodePattern.STR_NORMAL;

	/** 节点的所有连接 */
	protected MetaTransitionCollection transitionCollection = new MetaTransitionCollection();
	
	/** 前置条件 */
	private MetaPreCondition preCondition = null;
	
	/**
	 * 节点的输入输出数据定义
	 */
	protected MetaDataSpecification dataSpecification = null;

	/** 节点图形属性 */
	protected MetaNodeGraphic graphic = new MetaNodeGraphic();

	/** 附件 */
	protected MetaNodeAttachment nodeAttachment = new MetaNodeAttachment();

	private Boolean stop = false;
	
	/** 是否同步*/
	private Boolean sync = false;
	
	/** 驳回后是否锁定工作项，默认值为None*/
	private Integer lockWorkitem = BPMLockType.NONE;
	
	/** 是否是流程外任务*/
	private Boolean excluded = false;
	
	/** 处理时计算出的属性*/
	private boolean marked = false;

	private int deep;
	
	
	/**
	 * @return 节点所在的流程的标识
	 */
	public String getBPMKey() {
		return BPMKey;
	}

	/**
	 * @param BPMKey
	 *            设置节点所在的流程的标识
	 */
	public void setBPMKey(String BPMKey) {
		this.BPMKey = BPMKey;
	}

	public String getTag() {
		return tag;
	}
	
	public void setTag(String tag) {
		this.tag = tag;
	}
	
	public String getUserData() {
		return userData;
	}
	
	public void setUserData(String userData) {
		this.userData = userData;
	}
	
	/**
	 * @return the templateKey
	 */
	public String getTemplateKey() {
		return templateKey;
	}

	/**
	 * @param templateKey
	 *            the templateKey to set
	 */
	public void setTemplateKey(String templateKey) {
		this.templateKey = templateKey;
	}
	
	
	public Integer getBPMState() {
		return bpmState;
	}
	
	public void setBPMState(Integer bpmState) {
		this.bpmState = bpmState;
	}
	
	public String getRevokeTrigger() {
		return revokeTrigger;
	}
	
	public void setRevokeTrigger(String revokeTrigger) {
		this.revokeTrigger = revokeTrigger;
	}

	public Boolean isSync() {
		return sync;
	}

	public void setSync(Boolean sync) {
		this.sync = sync;
	}

	public Integer getLockWorkitem() {
		return lockWorkitem;
	}

	public void setLockWorkitem(Integer lockWorkitem) {
		this.lockWorkitem = lockWorkitem;
	}

	/**
	 * @return the inUse
	 */
	public Boolean isInUse() {
		return inUse;
	}

	/**
	 * @param inUse
	 *            the inUse to set
	 */
	public void setInUse(Boolean inUse) {
		this.inUse = inUse;
	}
	
	public void setPattern(String pattern) {
		this.pattern = pattern;
	}
	
	public String getPattern() {
		return pattern;
	}

	public String getRefDocKey() {
		return refDocKey;
	}

	public void setRefDocKey(String refDocKey) {
		this.refDocKey = refDocKey;
	}

	public Integer getRefType() {
		return refType;
	}

	public void setRefType(Integer refType) {
		this.refType = refType;
	}

	public Boolean isWorkitemRevoke() {
		return workitemRevoke;
	}

	public void setWorkitemRevoke(Boolean workitemRevoke) {
		this.workitemRevoke = workitemRevoke;
	}
	
	public String getRevokeCondition() {
		return revokeCondition;
	}
	
	public void setRevokeCondition(String revokeCondition) {
		this.revokeCondition = revokeCondition;
	}

	public String getRetreatCaption() {
		return retreatCaption;
	}

	public void setRetreatCaption(String retreatCaptiom) {
		this.retreatCaption = retreatCaptiom;
	}

	/**
	 * @return the transitionCollection
	 */
	public MetaTransitionCollection getTransitionCollection() {
		return transitionCollection;
	}

	public void setTransitionCollection(MetaTransitionCollection transitionCollection) {
		this.transitionCollection = transitionCollection;
	}
	
	public MetaPreCondition getPreCondition(){
		return preCondition;
	}
	
	public void setPreCondition(MetaPreCondition preCondition){
		this.preCondition = preCondition;
	}
	
	public MetaDataSpecification getDataSpecification() {
		return dataSpecification;
	}

	public void setDataSpecification(MetaDataSpecification dataSpecification) {
		this.dataSpecification = dataSpecification;
	}

	public Boolean getStop(){
		return stop;
	}
	
	public void setStop(Boolean stop) {
		this.stop = stop;
	}
	
	public int getDeep() {
		return deep;
	}
	
	public void setDeep(int deep) {
		this.deep = deep;
	}
	
	public void setMarked() {
		this.marked = true;
	}
	
	public void setUnMarked(){
		this.marked = false;
	}
	
	public boolean isMarked() {
		return marked;
	}

	/**
	 * @return the excluded
	 */
	public Boolean isExcluded() {
		return excluded;
	}

	/**
	 * @param excluded the excluded to set
	 */
	public void setExcluded(Boolean excluded) {
		this.excluded = excluded;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { transitionCollection, graphic, nodeAttachment});
		if(preCondition != null){
			list.add(preCondition);
		}
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject child = null;
		if (tagName.equalsIgnoreCase(MetaTransitionCollection.TAG_NAME)) {
			transitionCollection = new MetaTransitionCollection();
			child = transitionCollection;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaNodeGraphic.TAG_NAME)) {
			graphic = new MetaNodeGraphic();
			child = graphic;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaNodeAttachment.TAG)) {
			nodeAttachment = new MetaNodeAttachment();
			child = nodeAttachment;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		}else if (MetaDataSpecification.TAG_NAME.equals(tagName)) {
			dataSpecification = new MetaDataSpecification();
			child = dataSpecification;
		}else if (MetaPreCondition.TAG_NAME.equals(tagName)) {
			preCondition = new MetaPreCondition();
			child = preCondition;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return child;
	}

	public abstract int getNodeType();

	public MetaNodeGraphic getNodeGraphic() {
		return graphic;
	}

	public void setNodeGraphic(MetaNodeGraphic graphic) {
		this.graphic = graphic;
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = super.toJSON();
		obj.put("caption", getCaption());
		obj.put("bpm-key", this.BPMKey);
		obj.put("in-use", inUse);
		obj.put("template-key", templateKey);
		obj.put("state", bpmState);

		if (transitionCollection != null) {
			obj.put("transitions", transitionCollection.toJSON());
		}
		if (graphic != null) {
			obj.put("graphic", graphic.toJSON());
		}
		
		if (dataSpecification != null) {
			obj.put("dataSpecification", dataSpecification.toJSON());
		}

		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		super.fromJSON(json);
		setCaption(json.optString("caption"));
		this.BPMKey = json.optString("bpm-key");
		this.inUse = json.optBoolean("in-use");
		this.templateKey = json.optString("template-key");
		this.bpmState = json.optInt("state");

		if (json.has("transitions")) {
			transitionCollection = new MetaTransitionCollection();
			transitionCollection.fromJSON(json.getJSONObject("transitions"));
		}
		if (json.has("graphic")) {
			graphic = new MetaNodeGraphic();
			graphic.fromJSON(json.getJSONObject("graphic"));
		}
		if (json.has("dataSpecification")) {
			dataSpecification = new MetaDataSpecification();
			dataSpecification.fromJSON(json.getJSONObject("dataSpecification"));
		}
	}

	@Override
	public AbstractMetaObject clone() {
		MetaNode newNode = (MetaNode) super.clone();
		newNode.setBPMKey(BPMKey);
		newNode.setInUse(inUse);
		newNode.setTemplateKey(templateKey);
		newNode.setRevokeTrigger(revokeTrigger);
		newNode.setBPMState(bpmState);
		newNode.setRefDocKey(refDocKey);
		newNode.setRefType(refType);
		newNode.setExcluded(excluded);
		newNode.setTransitionCollection(transitionCollection == null ? null : (MetaTransitionCollection) transitionCollection.clone());
		newNode.setNodeGraphic(graphic == null ? null : (MetaNodeGraphic) graphic.clone());
		newNode.setRevokeCondition(revokeCondition);
		newNode.setRetreatCaption(retreatCaption);
		newNode.sync = sync;
		newNode.dataSpecification = dataSpecification == null ? null : (MetaDataSpecification)dataSpecification.clone();
		newNode.preCondition = preCondition == null ? null : (MetaPreCondition)preCondition.clone();
		newNode.setTag(tag);
		newNode.setUserData(userData);
		newNode.setWorkitemRevoke(workitemRevoke);
		newNode.setPattern(pattern);
		newNode.setNodeAttachment(nodeAttachment == null ? null : (MetaNodeAttachment)nodeAttachment.clone());
		newNode.setStop(stop);
		return newNode;
	}

	public MetaNodeAttachment getNodeAttachment() {
		return nodeAttachment;
	}
	
	public void setNodeAttachment(MetaNodeAttachment nodeAttachment) {
		this.nodeAttachment = nodeAttachment;
	}
}
