package com.bokesoft.yigo.meta.bpm.process.node;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaMessageReceive extends MetaNode {
	public static final String TAG_NAME = "MessageReceive";
	
	private MetaBaseScript action = null;
	private String condition="";
	private Integer messageCount = 1;

	public MetaBaseScript getAction() {
		return action;
	}

	public void setAction(MetaBaseScript action) {
		this.action = action;
	}

	public String getCondition() {
		return condition;
	}

	public void setCondition(String condition) {
		this.condition = condition;
	}

	public Integer getMessageCount() {
		return messageCount;
	}

	public void setMessageCount(Integer messageCount) {
		this.messageCount = messageCount;
	}

	@Override
	public int getNodeType() {
		return NodeType.MESSAGE_RECEIVE;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMessageReceive();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaMessageReceive obj = (MetaMessageReceive) super.clone();
		obj.action = action == null ? null : (MetaBaseScript)action.clone();
		obj.condition = condition;
		obj.messageCount = messageCount;
		return obj;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new Object[] {action});
		super.getChildMetaObjects(list);
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject child = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if (BPMConstants.NODE_ACTION.equals(tagName)) {
			action = new MetaBaseScript(BPMConstants.NODE_ACTION);
			child = action;
		}
		return child;
	}

}
