package com.bokesoft.yigo.meta.bpm.process.monitor;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaLoggerCollection extends GenericKeyCollection<MetaLogger> implements IElementMerge<MetaLoggerCollection> {

	public final static String TAG_NAME = "LoggerCollection";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaLogger.TAG_NAME.equals(tagName)) {
			MetaLogger logger = new MetaLogger();
			logger.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(logger);
			resultMetaObject = logger;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaLoggerCollection();
	}

	@Override
	public MetaLoggerCollection toMerge(MetaLoggerCollection obj) {
		if (obj != null) {
			Iterator<MetaLogger> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaLogger metaLogger = (MetaLogger) iterator.next();
				if (containsKey(metaLogger.getKey())) {
					throw new MetaException(MetaException.REPEAT_BPM_MONITOR_LOGGER_DEFINED,
							SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.RepeatBPMMonitorLoggerDefined),
									metaLogger.getKey()));
				}
				add(metaLogger);
			}
		}
		return this;
	}

}
